/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element;

import com.mojang.blaze3d.platform.Window;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ElementMemories;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.properties.RuntimePropertyContainer;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElement
implements Renderable,
GuiEventListener,
NarratableEntry,
NavigatableWidget {
    public static final AbstractElement EMPTY_ELEMENT = new AbstractElement(null){

        @Override
        public void m_88315_(@NotNull GuiGraphics g, int i1, int i2, float f) {
        }
    };
    public static final int STAY_ON_SCREEN_EDGE_ZONE_SIZE = 2;
    public final ElementBuilder<?, ?> builder;
    public ElementAnchorPoint anchorPoint = ElementAnchorPoints.MID_CENTERED;
    public String anchorPointElementIdentifier = null;
    protected AbstractElement cachedElementAnchorPointParent = null;
    public int posOffsetX = 0;
    public int posOffsetY = 0;
    public int baseWidth = 0;
    public int baseHeight = 0;
    public String advancedX;
    public Integer cachedAdvancedX;
    public long lastAdvancedXParse = -1L;
    public String advancedY;
    public Integer cachedAdvancedY;
    public long lastAdvancedYParse = -1L;
    public String advancedWidth;
    public Integer cachedAdvancedWidth;
    public long lastAdvancedWidthParse = -1L;
    public String advancedHeight;
    public Integer cachedAdvancedHeight;
    public long lastAdvancedHeightParse = -1L;
    public boolean stretchX = false;
    public boolean stretchY = false;
    public boolean stayOnScreen = true;
    public volatile boolean visible = true;
    public volatile AppearanceDelay appearanceDelay = AppearanceDelay.NO_DELAY;
    public volatile float appearanceDelayInSeconds = 1.0f;
    public long appearanceDelayEndTime = -1L;
    @NotNull
    public Fading fadeIn = Fading.NO_FADING;
    @NotNull
    public Fading fadeOut = Fading.NO_FADING;
    public float fadeInSpeed = 1.0f;
    public float fadeOutSpeed = 1.0f;
    public boolean shouldDoFadeInIfNeeded = false;
    public boolean fadeInStarted = false;
    public boolean fadeInFinished = false;
    public boolean shouldDoFadeOutIfNeeded = false;
    public boolean fadeOutStarted = false;
    public boolean fadeOutFinished = false;
    public long lastFadeInTick = -1L;
    public long lastFadeOutTick = -1L;
    public float opacity = 1.0f;
    @NotNull
    public String baseOpacity = "1.0";
    public float lastBaseOpacity = -1.0f;
    public long lastBaseOpacityParse = -1L;
    public float cachedBaseOpacity = 1.0f;
    public boolean becameVisible = false;
    public boolean becameInvisible = false;
    public boolean isNewMenu = ScreenCustomization.isNewMenu();
    public boolean fadeInElementJustCreated = true;
    public boolean fadeOutElementJustCreated = true;
    public boolean appearanceDelayElementJustCreated = true;
    public boolean lastTickAppearanceDelayed = false;
    public boolean autoSizing = false;
    public int autoSizingBaseScreenWidth = 0;
    public int autoSizingBaseScreenHeight = 0;
    public double autoSizingLastTickScreenWidth = -1.0;
    public double autoSizingLastTickScreenHeight = -1.0;
    public int autoSizingWidth = 0;
    public int autoSizingHeight = 0;
    public boolean stickyAnchor = false;
    public float customGuiScale = -1.0f;
    public LoadingRequirementContainer loadingRequirementContainer = new LoadingRequirementContainer();
    @Nullable
    public String customElementLayerName = null;
    private String instanceIdentifier;
    @Nullable
    protected Layout parentLayout;
    @Nullable
    protected RuntimePropertyContainer cachedMemory;

    public AbstractElement(@NotNull ElementBuilder<?, ?> builder) {
        this.builder = builder;
        this.instanceIdentifier = ScreenCustomization.generateUniqueIdentifier();
    }

    public void setParentLayout(@Nullable Layout parentLayout) {
        this.parentLayout = parentLayout;
    }

    @Nullable
    public Layout getParentLayout() {
        return this.parentLayout;
    }

    public abstract void m_88315_(@NotNull GuiGraphics var1, int var2, int var3, float var4);

    public void renderInternal(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickBaseOpacity();
        this.renderTick_Head();
        this.tickVisibleInvisible();
        this.renderTick_Inner_Stage_1();
        if (!AbstractElement.isEditor()) {
            this.tickAppearanceDelay(this.shouldRender());
            this.tickFadeInOut(this.shouldRender());
        }
        if (!this.shouldRender()) {
            return;
        }
        this.renderTick_Inner_Stage_2();
        this.m_88315_(graphics, mouseX, mouseY, partial);
        this.renderTick_Tail();
    }

    public void renderTick_Head() {
    }

    public void renderTick_Inner_Stage_1() {
    }

    public void renderTick_Inner_Stage_2() {
    }

    public void renderTick_Tail() {
    }

    public void tickBaseOpacity() {
        if (this.fadeInStarted && !this.fadeInFinished) {
            return;
        }
        if (this.fadeOutStarted && !this.fadeOutFinished) {
            return;
        }
        float newBaseOpacity = this.getBaseOpacity();
        if (newBaseOpacity != this.lastBaseOpacity) {
            this.updateOpacity();
        }
        this.lastBaseOpacity = newBaseOpacity;
    }

    public void tickVisibleInvisible() {
        if (!this._shouldRender()) {
            if (!this.becameInvisible) {
                this.becameInvisible = true;
                this.onBecomeInvisible();
            }
            this.becameVisible = false;
            return;
        }
        this.becameInvisible = false;
        if (!this.becameVisible) {
            this.becameVisible = true;
            this.onBecomeVisible();
        }
    }

    public void tickAppearanceDelay(boolean shouldRender) {
        if (!shouldRender) {
            return;
        }
        if (this.lastTickAppearanceDelayed && !this.isAppearanceDelayed()) {
            this.getMemory().putProperty("appearance_delay_applied", true);
        }
        this.lastTickAppearanceDelayed = this.isAppearanceDelayed();
    }

    public void tickFadeInOut(boolean shouldRender) {
        if (shouldRender) {
            boolean fadeInIsResize = !this.isNewMenu && this.fadeInElementJustCreated;
            boolean fadeInDone = this.getMemory().putPropertyIfAbsentAndGet("fade_in_done", false);
            if (!fadeInIsResize || !fadeInDone) {
                if (this.fadeIn != Fading.NO_FADING && this.shouldDoFadeInIfNeeded && this.lastBaseOpacity > 0.0f && (this.fadeIn != Fading.FIRST_TIME || !fadeInDone)) {
                    if (!this.fadeInStarted) {
                        this.fadeInStarted = true;
                        this.opacity = 0.0f;
                    }
                    if (this.lastFadeInTick + (long)(50.0f * this.fadeInSpeed) < System.currentTimeMillis()) {
                        this.lastFadeInTick = System.currentTimeMillis();
                        this.opacity += 0.02f;
                    }
                    if (this.opacity >= this.lastBaseOpacity) {
                        this.opacity = this.lastBaseOpacity;
                        this.shouldDoFadeInIfNeeded = false;
                        this.fadeInFinished = true;
                        this.getMemory().putProperty("fade_in_done", true);
                    }
                }
            } else {
                this.shouldDoFadeInIfNeeded = false;
                this.fadeInStarted = false;
                this.fadeInFinished = false;
            }
        }
        this.fadeInElementJustCreated = false;
        if (this.fadeOut != Fading.NO_FADING && this.shouldDoFadeOutIfNeeded && this.lastBaseOpacity > 0.0f && !this.fadeOutFinished) {
            boolean fadeOutDone = this.getMemory().putPropertyIfAbsentAndGet("fade_out_done", false);
            if (this.fadeOut != Fading.FIRST_TIME || !fadeOutDone) {
                if (!this.fadeOutStarted) {
                    this.fadeOutStarted = true;
                    this.opacity = this.lastBaseOpacity;
                }
                if (this.lastFadeOutTick + (long)(50.0f * this.fadeOutSpeed) < System.currentTimeMillis()) {
                    this.lastFadeOutTick = System.currentTimeMillis();
                    this.opacity -= 0.02f;
                }
                if (this.opacity <= 0.0f) {
                    this.opacity = 0.0f;
                    this.shouldDoFadeOutIfNeeded = false;
                    this.fadeOutFinished = true;
                    this.getMemory().putProperty("fade_out_done", true);
                }
            }
        }
    }

    public void onBecomeVisible() {
        this.applyAppearanceDelay();
        this.updateOpacity();
        this.fadeInStarted = false;
        this.fadeInFinished = false;
        this.fadeOutStarted = false;
        this.fadeOutFinished = false;
        this.shouldDoFadeInIfNeeded = true;
        this.shouldDoFadeOutIfNeeded = false;
    }

    public void onBecomeInvisible() {
        this.updateOpacity();
        this.fadeInStarted = false;
        this.fadeInFinished = false;
        this.fadeOutStarted = false;
        this.fadeOutFinished = false;
        this.shouldDoFadeOutIfNeeded = true;
        this.shouldDoFadeInIfNeeded = false;
        if (this.fadeOutElementJustCreated) {
            this.shouldDoFadeOutIfNeeded = false;
        }
        this.fadeOutElementJustCreated = false;
    }

    public void applyAppearanceDelay() {
        boolean isResize = !this.isNewMenu && this.appearanceDelayElementJustCreated;
        this.appearanceDelayElementJustCreated = false;
        if (AbstractElement.isEditor()) {
            this.appearanceDelayEndTime = -1L;
            return;
        }
        boolean applied = this.getMemory().putPropertyIfAbsentAndGet("appearance_delay_applied", false);
        this.appearanceDelayEndTime = !(isResize && applied || this.appearanceDelay == AppearanceDelay.NO_DELAY || !(this.appearanceDelayInSeconds > 0.0f)) ? (this.appearanceDelay == AppearanceDelay.FIRST_TIME && applied ? -1L : System.currentTimeMillis() + (long)this.appearanceDelayInSeconds * 1000L) : -1L;
        this.lastTickAppearanceDelayed = this.isAppearanceDelayed();
    }

    public void updateOpacity() {
        this.opacity = this.getBaseOpacity();
    }

    public float getBaseOpacity() {
        long now = System.currentTimeMillis();
        if (this.lastBaseOpacityParse + 30L > now) {
            return this.cachedBaseOpacity;
        }
        this.lastBaseOpacityParse = now;
        String s = PlaceholderParser.replacePlaceholders(this.baseOpacity);
        if (MathUtils.isFloat((String)s)) {
            float f = Float.parseFloat(s);
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.cachedBaseOpacity = f;
            return f;
        }
        this.cachedBaseOpacity = 1.0f;
        return 1.0f;
    }

    public void tick() {
    }

    public void onCloseScreen() {
    }

    public void onOpenScreen() {
    }

    public void onBeforeResizeScreen() {
    }

    public void onDestroyElement() {
    }

    @Nullable
    public List<GuiEventListener> getWidgetsToRegister() {
        return null;
    }

    @NotNull
    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public void setInstanceIdentifier(@NotNull String id) {
        this.instanceIdentifier = Objects.requireNonNull(id);
    }

    public int getAbsoluteX() {
        int x = 0;
        if (this.anchorPoint != null) {
            x = this.anchorPoint.getElementPositionX(this);
        }
        if (this.advancedX != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedXParse + 30L > now && this.cachedAdvancedX != null) {
                x = this.cachedAdvancedX;
            } else {
                String s = PlaceholderParser.replacePlaceholders(this.advancedX).replace(" ", "");
                if (MathUtils.isDouble((String)s)) {
                    x = (int)Double.parseDouble(s);
                    this.cachedAdvancedX = x;
                    this.lastAdvancedXParse = now;
                }
            }
        }
        if (this.stretchX) {
            x = 0;
        } else if (this.stayOnScreen) {
            if (x < 2) {
                x = 2;
            }
            if (x > AbstractElement.getScreenWidth() - 2 - this.getAbsoluteWidth()) {
                x = AbstractElement.getScreenWidth() - 2 - this.getAbsoluteWidth();
            }
        }
        return x;
    }

    public int getAbsoluteY() {
        int y = 0;
        if (this.anchorPoint != null) {
            y = this.anchorPoint.getElementPositionY(this);
        }
        if (this.advancedY != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedYParse + 30L > now && this.cachedAdvancedY != null) {
                y = this.cachedAdvancedY;
            } else {
                String s = PlaceholderParser.replacePlaceholders(this.advancedY).replace(" ", "");
                if (MathUtils.isDouble((String)s)) {
                    y = (int)Double.parseDouble(s);
                    this.cachedAdvancedY = y;
                    this.lastAdvancedYParse = now;
                }
            }
        }
        if (this.stretchY) {
            y = 0;
        } else if (this.stayOnScreen) {
            if (y < 2) {
                y = 2;
            }
            if (y > AbstractElement.getScreenHeight() - 2 - this.getAbsoluteHeight()) {
                y = AbstractElement.getScreenHeight() - 2 - this.getAbsoluteHeight();
            }
        }
        return y;
    }

    public void setAutoSizingBaseWidthAndHeight() {
        Window window = Minecraft.m_91087_().m_91268_();
        double guiWidth = (double)AbstractElement.getScreenWidth() * window.m_85449_();
        double guiHeight = (double)AbstractElement.getScreenHeight() * window.m_85449_();
        this.autoSizingBaseScreenWidth = (int)guiWidth;
        this.autoSizingBaseScreenHeight = (int)guiHeight;
    }

    public void updateAutoSizing(boolean ignoreLastTickScreenSize) {
        Window window = Minecraft.m_91087_().m_91268_();
        double guiWidth = (double)AbstractElement.getScreenWidth() * window.m_85449_();
        double guiHeight = (double)AbstractElement.getScreenHeight() * window.m_85449_();
        if (this.autoSizingLastTickScreenWidth != guiWidth || this.autoSizingLastTickScreenHeight != guiHeight || ignoreLastTickScreenSize) {
            if (this.autoSizing && this.autoSizingBaseScreenWidth > 0 && this.autoSizingBaseScreenHeight > 0) {
                double percentX = Math.max(1.0, guiWidth / (double)this.autoSizingBaseScreenWidth * 100.0);
                double percentY = Math.max(1.0, guiHeight / (double)this.autoSizingBaseScreenHeight * 100.0);
                double percent = Math.min(percentX, percentY);
                this.autoSizingWidth = Math.max(1, (int)(percent / 100.0 * (double)this.baseWidth));
                this.autoSizingHeight = Math.max(1, (int)(percent / 100.0 * (double)this.baseHeight));
                if ((double)this.autoSizingBaseScreenWidth == guiWidth && (double)this.autoSizingBaseScreenHeight == guiHeight) {
                    this.autoSizingWidth = 0;
                    this.autoSizingHeight = 0;
                }
            } else {
                this.autoSizingWidth = 0;
                this.autoSizingHeight = 0;
            }
        }
        this.autoSizingLastTickScreenWidth = guiWidth;
        this.autoSizingLastTickScreenHeight = guiHeight;
    }

    public int getAbsoluteWidth() {
        if (this.advancedWidth != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedWidthParse + 30L > now && this.cachedAdvancedWidth != null) {
                return this.cachedAdvancedWidth;
            }
            String s = PlaceholderParser.replacePlaceholders(this.advancedWidth).replace(" ", "");
            if (MathUtils.isDouble((String)s)) {
                this.cachedAdvancedWidth = (int)Double.parseDouble(s);
                this.lastAdvancedWidthParse = now;
                return this.cachedAdvancedWidth;
            }
        }
        if (this.stretchX) {
            return AbstractElement.getScreenWidth();
        }
        this.updateAutoSizing(false);
        if (this.autoSizing && this.autoSizingWidth > 0) {
            return this.autoSizingWidth;
        }
        return this.baseWidth;
    }

    public int getAbsoluteHeight() {
        if (this.advancedHeight != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedHeightParse + 30L > now && this.cachedAdvancedHeight != null) {
                return this.cachedAdvancedHeight;
            }
            String s = PlaceholderParser.replacePlaceholders(this.advancedHeight).replace(" ", "");
            if (MathUtils.isDouble((String)s)) {
                this.cachedAdvancedHeight = (int)Double.parseDouble(s);
                this.lastAdvancedHeightParse = now;
                return this.cachedAdvancedHeight;
            }
        }
        if (this.stretchY) {
            return AbstractElement.getScreenHeight();
        }
        this.updateAutoSizing(false);
        if (this.autoSizing && this.autoSizingHeight > 0) {
            return this.autoSizingHeight;
        }
        return this.baseHeight;
    }

    @Nullable
    public AbstractElement getElementAnchorPointParent() {
        if (this.anchorPointElementIdentifier == null) {
            return null;
        }
        if (this.cachedElementAnchorPointParent == null) {
            this.cachedElementAnchorPointParent = AbstractElement.getElementByInstanceIdentifier(this.anchorPointElementIdentifier);
        }
        return this.cachedElementAnchorPointParent;
    }

    public void setElementAnchorPointParent(@Nullable AbstractElement element) {
        this.cachedElementAnchorPointParent = element;
    }

    public int getChildElementAnchorPointX() {
        return this.getAbsoluteX();
    }

    public int getChildElementAnchorPointY() {
        return this.getAbsoluteY();
    }

    public boolean isAppearanceDelayed() {
        return System.currentTimeMillis() < this.appearanceDelayEndTime;
    }

    public boolean shouldRender() {
        if (this.isAppearanceDelayed() && !AbstractElement.isEditor()) {
            return false;
        }
        boolean b = this._shouldRender();
        if (!AbstractElement.isEditor() && !b && this.fadeOutStarted && !this.fadeOutFinished) {
            return true;
        }
        return b;
    }

    protected boolean _shouldRender() {
        if (!this.loadingRequirementsMet()) {
            return false;
        }
        return this.visible;
    }

    protected boolean loadingRequirementsMet() {
        if (AbstractElement.isEditor()) {
            return true;
        }
        return this.loadingRequirementContainer.requirementsMet();
    }

    @NotNull
    public Component getDisplayName() {
        if (this.customElementLayerName != null) {
            return Component.m_237113_((String)this.customElementLayerName);
        }
        return this.builder.getDisplayName(this);
    }

    @NotNull
    public RuntimePropertyContainer getMemory() {
        if (this.cachedMemory == null) {
            this.cachedMemory = ElementMemories.getMemory(this.getInstanceIdentifier());
        }
        return this.cachedMemory;
    }

    public static String fixBackslashPath(String path) {
        if (path != null) {
            return path.replace("\\", "/");
        }
        return null;
    }

    protected static boolean isEditor() {
        return AbstractElement.getScreen() instanceof LayoutEditorScreen;
    }

    @Nullable
    public static Screen getScreen() {
        return Minecraft.m_91087_().f_91080_;
    }

    public static int getScreenWidth() {
        Screen s = AbstractElement.getScreen();
        return s != null ? s.f_96543_ : 0;
    }

    public static int getScreenHeight() {
        Screen s = AbstractElement.getScreen();
        return s != null ? s.f_96544_ : 0;
    }

    @Nullable
    public static AbstractElement getElementByInstanceIdentifier(String identifier) {
        identifier = identifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        if (AbstractElement.isEditor()) {
            AbstractEditorElement editorElement = ((LayoutEditorScreen)AbstractElement.getScreen()).getElementByInstanceIdentifier(identifier);
            if (editorElement != null) {
                return editorElement.element;
            }
        } else {
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
            if (layer != null) {
                return layer.getElementByInstanceIdentifier(identifier);
            }
        }
        return null;
    }

    @NotNull
    public static Component buildComponent(@NotNull String serializedComponentOrPlainText) {
        if (!(serializedComponentOrPlainText = PlaceholderParser.replacePlaceholders(serializedComponentOrPlainText)).startsWith("{")) {
            return Component.m_237113_((String)serializedComponentOrPlainText);
        }
        try {
            MutableComponent c = Component.Serializer.m_130701_((String)serializedComponentOrPlainText);
            if (c != null) {
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Component.m_237113_((String)serializedComponentOrPlainText);
    }

    public void m_93692_(boolean var1) {
    }

    public boolean m_93696_() {
        return false;
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("AbstractElements are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("AbstractElements are not navigatable!");
    }

    public static enum AppearanceDelay {
        NO_DELAY("no_delay"),
        FIRST_TIME("first_time"),
        EVERY_TIME("every_time");

        public final String name;

        private AppearanceDelay(String name) {
            this.name = name;
        }

        @Nullable
        public static AppearanceDelay getByName(@NotNull String name) {
            for (AppearanceDelay d : AppearanceDelay.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum Fading {
        NO_FADING("no_fading"),
        FIRST_TIME("first_time"),
        EVERY_TIME("every_time");

        private final String name;

        private Fading(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public static Fading getByName(@NotNull String name) {
            for (Fading mode : Fading.values()) {
                if (!mode.getName().equals(name)) continue;
                return mode;
            }
            return null;
        }
    }

    public static enum Alignment {
        LEFT("left"),
        RIGHT("right"),
        CENTERED("centered");

        public final String key;

        private Alignment(String key) {
            this.key = key;
        }

        public static Alignment getByName(@NotNull String name) {
            for (Alignment a : Alignment.values()) {
                if (!a.key.equals(name)) continue;
                return a;
            }
            return null;
        }
    }
}

