/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.world.structure;

import com.izofar.takesapillage.init.ModStructures;
import com.izofar.takesapillage.util.ModStructureUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class PillagerStructure
extends Structure {
    public static final Codec<PillagerStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PillagerStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.intRange((int)0, (int)30).fieldOf("terrain_search_radius").forGetter(structure -> structure.terrainSearchRadius), (App)Codec.intRange((int)0, (int)30).fieldOf("max_terrain_range").forGetter(structure -> structure.maxTerrainRange), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, PillagerStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final int terrainSearchRadius;
    private final int maxTerrainRange;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public PillagerStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, int terrainSearchRadius, int maxTerrainRange, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.terrainSearchRadius = terrainSearchRadius;
        this.maxTerrainRange = maxTerrainRange;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructures.PILLAGER_STRUCTURE.get();
    }

    private static boolean checkLocation(Structure.GenerationContext context, int terrainSearchRadius, int maxTerrainRange) {
        int i = context.f_226628_().f_45578_ >> 4;
        int j = context.f_226628_().f_45579_ >> 4;
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_188584_((long)(i ^ j << 4) ^ context.f_226627_());
        return ModStructureUtils.isRelativelyFlat(context, terrainSearchRadius, maxTerrainRange) && ModStructureUtils.isOnLand(context, terrainSearchRadius);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!PillagerStructure.checkLocation(context, this.terrainSearchRadius, this.maxTerrainRange)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_226628_().m_151394_(0);
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockpos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }
}

