/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterwitchhuts.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterwitchhuts.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
public class BrewingStandProcessor
extends StructureProcessor {
    public static final BrewingStandProcessor INSTANCE = new BrewingStandProcessor();
    public static final Codec<BrewingStandProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_().m_60734_() == Blocks.f_50255_) {
            RandomSource randomSource = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_());
            CompoundTag tag = blockInfoGlobal.f_74677_();
            ListTag itemsListTag = tag.m_128437_("Items", 10);
            this.populateItemsList(itemsListTag, randomSource);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), blockInfoGlobal.f_74676_(), tag);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.BREWING_STAND_PROCESSOR;
    }

    private void populateItemsList(ListTag itemsListTag, RandomSource randomSource) {
        int n = randomSource.m_188503_(5);
        switch (n) {
            case 0: {
                this.addBrewingRecipe(itemsListTag, "minecraft:glistering_melon_slice", "minecraft:healing", randomSource);
                break;
            }
            case 1: {
                this.addBrewingRecipe(itemsListTag, "minecraft:sugar", "minecraft:swiftness", randomSource);
                break;
            }
            case 2: {
                this.addBrewingRecipe(itemsListTag, "minecraft:pufferfish", "minecraft:water_breathing", randomSource);
                break;
            }
            case 3: {
                this.addBrewingRecipe(itemsListTag, "minecraft:golden_carrot", "minecraft:night_vision", randomSource);
                break;
            }
            case 4: {
                this.addBrewingRecipe(itemsListTag, "minecraft:phantom_membrane", "minecraft:slow_falling", randomSource);
            }
        }
    }

    private void addBrewingRecipe(ListTag itemsListTag, String inputItemId, String outputPotionId, RandomSource randomSource) {
        itemsListTag.add((Object)((Tag)Util.m_137469_((Object)new CompoundTag(), itemTag -> this.putInputItem((CompoundTag)itemTag, inputItemId, (byte)(randomSource.m_188503_(4) + 2)))));
        itemsListTag.add((Object)((Tag)Util.m_137469_((Object)new CompoundTag(), itemTag -> {
            this.putPotionInSlot((CompoundTag)itemTag, (byte)1, outputPotionId);
            if (randomSource.m_188501_() < 0.5f) {
                this.putPotionInSlot((CompoundTag)itemTag, (byte)0, outputPotionId);
            }
            if (randomSource.m_188501_() < 0.5f) {
                this.putPotionInSlot((CompoundTag)itemTag, (byte)2, outputPotionId);
            }
        })));
    }

    private void putInputItem(CompoundTag itemTag, String itemId, byte count) {
        itemTag.m_128344_("Slot", (byte)3);
        itemTag.m_128359_("id", itemId);
        itemTag.m_128344_("Count", count);
    }

    private void putPotionInSlot(CompoundTag itemTag, byte slot, String potionId) {
        itemTag.m_128344_("Slot", slot);
        itemTag.m_128359_("id", "minecraft:potion");
        itemTag.m_128344_("Count", (byte)1);
        itemTag.m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), potionTag -> potionTag.m_128359_("Potion", potionId)));
    }
}

