/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.base.Joiner;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum NoteBlockProvider implements IBlockComponentProvider
{
    INSTANCE;

    private static final String[] PITCH;
    private static final ChatFormatting[] OCTAVE;
    private static final ChatFormatting[] OCTAVE_LIGHT;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        NoteBlockInstrument instrument = (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_);
        String key = "jade.instrument." + instrument.m_7912_();
        String name = I18n.m_118936_((String)key) ? I18n.m_118938_((String)key, (Object[])new Object[0]) : Joiner.on((char)' ').join(Stream.of(instrument.m_7912_().replace('_', ' ').split(" ")).map(StringUtils::capitalize).toList());
        if (instrument.m_262503_()) {
            int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
            String pitch = PITCH[note % PITCH.length];
            ChatFormatting octave = (IThemeHelper.get().isLightColorScheme() ? OCTAVE_LIGHT : OCTAVE)[note / PITCH.length];
            tooltip.add((Component)Component.m_237113_((String)"%s %s".formatted(name, octave + pitch)));
        } else {
            tooltip.add((Component)Component.m_237113_((String)name));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_NOTE_BLOCK;
    }

    static {
        PITCH = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};
        OCTAVE = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.YELLOW, ChatFormatting.GOLD};
        OCTAVE_LIGHT = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE};
    }
}

