/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.mixinsq;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.AdjustableOverwriteNode;
import com.bawnorton.mixinsquared.adjuster.tools.type.MethodListAnnotationNode;
import com.bawnorton.mixinsquared.api.MixinAnnotationAdjuster;
import com.google.common.collect.Sets;
import cpw.mods.modlauncher.Launcher;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.CompatibleHashes;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.utils.MethodNodeHasher;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.loading.LoadingModList;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.service.MixinService;

public class ATLMixinAdjuster
implements MixinAnnotationAdjuster {
    private static final boolean IS_SRG = Launcher.INSTANCE.environment().findNameMapping("srg").isPresent();
    private static final AdjustableAnnotationNode UNIQUE = AdjustableAnnotationNode.fromNode((AnnotationNode)new AnnotationNode(Unique.class.descriptorString()));
    public static final Map<String, Lazy<Integer>> hashCodes = new ConcurrentHashMap<String, Lazy<Integer>>();
    public static final Map<MethodNode, List<Integer>> compatibleHashes = new ConcurrentHashMap<MethodNode, List<Integer>>();
    public static final Set<String> computingHashes = Sets.newConcurrentHashSet();

    public AdjustableAnnotationNode adjust(List<String> targetClassNames, String mixinClassName, MethodNode handlerNode, AdjustableAnnotationNode annotationNode) {
        if (!IS_SRG && mixinClassName.startsWith("dev.uncandango.alltheleaks.mixin.core.")) {
            return ATLMixinAdjuster.processHashes(targetClassNames, mixinClassName, annotationNode, handlerNode);
        }
        if (this.isModernfixFeatureOn("main.IngredientWithCountMixin", mixinClassName, "perf.faster_ingredients.IngredientMixin")) {
            return UNIQUE;
        }
        if (this.isModernfixFeatureOn("main.IngredientItemValueMixin", mixinClassName, "perf.ingredient_item_deduplication.IngredientItemValueMixin")) {
            return UNIQUE;
        }
        if (this.isATLFeatureOn(Set.of("main.IngredientSetMixin", "main.NormalizedTypedItemStackMixin"), mixinClassName, !ATLProperties.get().ingredientDedupe)) {
            return UNIQUE;
        }
        return annotationNode;
    }

    private boolean isModernfixFeatureOn(String myMixin, String currentMixin, String modernfixMixin) {
        if (("dev.uncandango.alltheleaks.mixin.core." + myMixin).equals(currentMixin) && LoadingModList.get().getModFileById("modernfix") != null) {
            return ModernFixMixinPlugin.instance.isOptionEnabled(modernfixMixin);
        }
        return false;
    }

    private boolean isATLFeatureOn(Set<String> myMixin, String currentMixin, boolean feature) {
        if (myMixin.stream().anyMatch(mixin -> ("dev.uncandango.alltheleaks.mixin.core." + mixin).equals(currentMixin))) {
            return feature;
        }
        return false;
    }

    private static synchronized AdjustableAnnotationNode processHashes(List<String> targetClassNames, String mixinClassName, AdjustableAnnotationNode annotationNode, MethodNode handlerNode) {
        if (annotationNode.desc.equals(CompatibleHashes.class.descriptorString())) {
            if (targetClassNames.size() > 1) {
                throw new IllegalArgumentException("CompatibleHashes can't be applied to multiple target classes!");
            }
            annotationNode.get("values").ifPresentOrElse(hashes -> compatibleHashes.put(handlerNode, (List<Integer>)hashes), () -> compatibleHashes.put(handlerNode, List.of(Integer.valueOf(0))));
            computingHashes.add(mixinClassName);
            try {
                ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(targetClassNames.get(0));
                for (MethodNode method : classNode.methods) {
                    Lazy calcHash = Lazy.of(() -> MethodNodeHasher.hash(classNode, method.name + method.desc));
                    String fullName = method.name + method.desc;
                    hashCodes.put(fullName, (Lazy<Integer>)calcHash);
                }
                return annotationNode;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (!computingHashes.contains(mixinClassName)) {
            return annotationNode;
        }
        ArrayList<CallSite> methods = null;
        if (annotationNode instanceof MethodListAnnotationNode) {
            MethodListAnnotationNode methodListAnnotationNode = (MethodListAnnotationNode)annotationNode;
            if (!IS_SRG) {
                methodListAnnotationNode.applyRefmap();
            }
            methods = methodListAnnotationNode.getMethod();
        }
        if (annotationNode instanceof AdjustableOverwriteNode) {
            methods = new ArrayList<CallSite>(List.of(handlerNode.name + handlerNode.desc));
        }
        if (methods == null) {
            return annotationNode;
        }
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Object searchMethod;
            String method = (String)it.next();
            Object object = method.startsWith("L") && method.indexOf(";m_") > 0 ? method.substring(method.indexOf(";m_") + 1) : (searchMethod = method.indexOf(40) == -1 ? method + "(" : method);
            if (((String)searchMethod).indexOf(42) > 0) {
                searchMethod = ((String)searchMethod).replace("*", "");
            }
            boolean found = false;
            for (String key : hashCodes.keySet()) {
                if (!key.startsWith((String)searchMethod)) continue;
                found = true;
                Integer hash = (Integer)hashCodes.get(key).get();
                AllTheLeaks.LOGGER.debug("Method Hash {} calculated for method {} at mixin {}", new Object[]{hash, method, mixinClassName});
                List<Integer> expectedHashes = compatibleHashes.get(handlerNode);
                if (expectedHashes.contains(hash)) continue;
                AllTheLeaks.LOGGER.info("Method {} at mixin {} cancelled due to not matching hash: Actual {}, Expected: {}", new Object[]{method, mixinClassName, hash, expectedHashes});
                it.remove();
                break;
            }
            if (found) continue;
            IllegalArgumentException ex = new IllegalArgumentException("Method " + (String)searchMethod + " not found in possible methods of the class " + targetClassNames.get(0));
            AllTheLeaks.LOGGER.error(ex.getMessage(), (Throwable)ex);
            methods.clear();
        }
        hashCodes.clear();
        compatibleHashes.clear();
        computingHashes.remove(mixinClassName);
        if (methods.isEmpty()) {
            AllTheLeaks.LOGGER.info("Mixin annotation {} at mixin {} removed due to no methods available", (Object)annotationNode, (Object)mixinClassName);
            return UNIQUE;
        }
        return annotationNode;
    }
}

