/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.mixin.core.main;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.DataStructures.PlayerActivityHistory;
import dev.uncandango.alltheleaks.annotation.CompatibleHashes;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CrashUtils.class}, remap=false)
public class CrashUtilsMixin {
    @CompatibleHashes(values={-346956539})
    @Redirect(method={"setupFtbChunksUnloading"}, at=@At(value="INVOKE", target="Ljava/util/Timer;scheduleAtFixedRate(Ljava/util/TimerTask;JJ)V"))
    private void cancelTimerIfExists(Timer instance, TimerTask task, long delay, long period) {
        instance.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return;
                }
                ServerLevel world = server.m_129880_(Level.f_46428_);
                if (world == null) {
                    return;
                }
                PlayerActivityHistory history = new PlayerActivityHistory(world);
                CrashUtils.LOGGER.info("Unloading chunks for players that have not been online in: " + CrashUtils.SERVER_CONFIG.getExpireTimeInDays() + " Days");
                CrashUtils.LOGGER.info(history.getPlayersInChunkClearTime().size() + " Player(s) affected ");
                for (String player : history.getPlayersInChunkClearTime()) {
                    CrashUtils.LOGGER.info("Unloading " + player + "'s Chunks");
                    world.m_7654_().m_129892_().m_230957_(world.m_7654_().m_129893_(), "ftbchunks unload_all " + player);
                }
            }
        }, delay, period);
    }
}

