/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.MineGuardianEntity;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class MineGuardianAnchorEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> GUARDIAN_UUID = SynchedEntityData.m_135353_(MineGuardianAnchorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> GUARDIAN_ID = SynchedEntityData.m_135353_(MineGuardianAnchorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MineGuardianAnchorEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public MineGuardianAnchorEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.MINE_GUARDIAN_ANCHOR.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public MineGuardianAnchorEntity(MineGuardianEntity mineGuardianEntity) {
        this((EntityType)ACEntityRegistry.MINE_GUARDIAN_ANCHOR.get(), mineGuardianEntity.m_9236_());
        this.setGuardianUUID(mineGuardianEntity.m_20148_());
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        this.m_146884_(mineGuardianEntity.m_20182_().m_82520_(0.0, 0.5, 0.0));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(GUARDIAN_UUID, Optional.empty());
        this.f_19804_.m_135372_(GUARDIAN_ID, (Object)-1);
    }

    public void m_8119_() {
        super.m_8119_();
        Entity guardian = this.getGuardian();
        if (!this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_((double)0.9f));
        this.m_20256_(this.m_20184_().m_82542_((double)0.9f, (double)0.9f, (double)0.9f));
        if (!this.m_9236_().f_46443_) {
            if (guardian == null && this.f_19797_ > 20) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (guardian instanceof MineGuardianEntity) {
                MineGuardianEntity mineGuardian = (MineGuardianEntity)guardian;
                LivingEntity attackTarget = mineGuardian.m_5448_();
                boolean hasTarget = attackTarget != null && attackTarget.m_6084_();
                this.f_19804_.m_135381_(GUARDIAN_ID, (Object)mineGuardian.m_19879_());
                mineGuardian.setAnchorUUID(this.m_20148_());
                double distance = this.m_20270_((Entity)mineGuardian);
                int i = mineGuardian.getMaxChainLength();
                double distanceGoal = (mineGuardian.m_20072_() ? (double)i + Math.sin((float)this.f_19797_ * 0.1f + (float)i * 0.5f) * 0.25 : 5.0) + (double)(hasTarget ? 5 : 0);
                double waterHeight = mineGuardian.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get());
                double waterUp = Math.min(waterHeight, 1.0) * (double)0.005f;
                if (mineGuardian.m_20072_() && !hasTarget) {
                    double f = this.m_20185_() + (double)((float)(-Math.sin((float)this.f_19797_ * 0.025f + (float)i)) * 0.5f);
                    double f1 = this.m_20189_() + (double)((float)Math.cos((float)this.f_19797_ * 0.025f + (float)i) * 0.5f);
                    double f2 = this.m_20186_() + distanceGoal;
                    Vec3 vec3 = new Vec3(f, f2, f1).m_82546_(guardian.m_20182_());
                    mineGuardian.m_20256_(mineGuardian.m_20184_().m_82549_(vec3.m_82490_(waterUp)));
                }
                if (distance > distanceGoal) {
                    double disRem = Math.min(distance - distanceGoal, 1.0) * (double)0.1f;
                    Vec3 moveTo = this.getChainFrom(1.0f).m_82546_(mineGuardian.m_20182_());
                    if (moveTo.m_82553_() > 1.0) {
                        moveTo = moveTo.m_82541_();
                    }
                    mineGuardian.m_20256_(mineGuardian.m_20184_().m_82542_(hasTarget ? 1.0 : (double)0.8f, hasTarget ? 1.0 : (double)0.8f, hasTarget ? 1.0 : (double)0.8f).m_82549_(moveTo.m_82490_(disRem)));
                }
            }
        }
    }

    public UUID getGuardianUUID() {
        return ((Optional)this.f_19804_.m_135370_(GUARDIAN_UUID)).orElse(null);
    }

    public void setGuardianUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(GUARDIAN_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getGuardian() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getGuardianUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(GUARDIAN_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void linkWithGuardian(Entity head) {
        this.setGuardianUUID(head.m_20148_());
        this.f_19804_.m_135381_(GUARDIAN_ID, (Object)head.m_19879_());
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("GuardianUUID")) {
            this.setGuardianUUID(compound.m_128342_("GuardianUUID"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        if (this.getGuardianUUID() != null) {
            compound.m_128362_("GuardianUUID", this.getGuardianUUID());
        }
    }

    public Vec3 getChainTo(float partialTicks) {
        Entity entity = this.getGuardian();
        if (entity instanceof MineGuardianEntity) {
            MineGuardianEntity mineGuardianEntity = (MineGuardianEntity)entity;
            return mineGuardianEntity.m_20318_(partialTicks);
        }
        return this.m_20318_(partialTicks).m_82520_(0.0, 1.0, 0.0);
    }

    public Vec3 getChainFrom(float partialTicks) {
        return this.m_20318_(partialTicks).m_82520_(0.0, 1.0, 0.0);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_5829_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return !this.m_213877_();
    }

    public boolean m_6097_() {
        return !this.m_213877_();
    }
}

