/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.server.entity.item.GumballEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class GumballRenderer
extends EntityRenderer<GumballEntity> {
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_3.png");
    private static final ResourceLocation TEXTURE_4 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_4.png");
    private static final ResourceLocation TEXTURE_5 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_5.png");
    private static final ResourceLocation TEXTURE_6 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_6.png");
    private static final ResourceLocation TEXTURE_7 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_7.png");
    private static final ResourceLocation TEXTURE_8 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_8.png");
    private static final ResourceLocation TEXTURE_9 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_9.png");
    private static final ResourceLocation TEXTURE_10 = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_10.png");
    private static final ResourceLocation TEXTURE_EXPLODING = new ResourceLocation("alexscaves", "textures/entity/gumball/gumball_exploding.png");

    public GumballRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(GumballEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.m_85836_();
        float explodeAmount = entity.getExplodeProgress(partialTicks);
        float scale = entity.isExplosive() ? 0.5f + explodeAmount * 0.2f : 0.25f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        GumballRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1, 1.0f);
        GumballRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1, 1.0f);
        GumballRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0, 1.0f);
        GumballRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0, 1.0f);
        if (entity.isExplosive()) {
            float explodeColorChange = entity.getBounces() >= entity.getMaximumBounces() ? 1.0f - 0.5f * (1.0f + Mth.m_14031_((float)(((float)entity.f_19797_ + partialTicks) * 0.9f))) : 0.0f;
            VertexConsumer vertexconsumer2 = multiBufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)TEXTURE_EXPLODING));
            GumballRenderer.vertex(vertexconsumer2, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1, explodeColorChange);
            GumballRenderer.vertex(vertexconsumer2, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1, explodeColorChange);
            GumballRenderer.vertex(vertexconsumer2, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0, explodeColorChange);
            GumballRenderer.vertex(vertexconsumer2, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0, explodeColorChange);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int p_253829_, float x, int y, int u, int v, float alpha) {
        vertexConsumer.m_252986_(matrix4f, x - 0.5f, (float)y - 0.25f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(p_253829_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(GumballEntity gumballEntity) {
        switch (gumballEntity.getColor()) {
            case 0: {
                return TEXTURE_0;
            }
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case 3: {
                return TEXTURE_3;
            }
            case 4: {
                return TEXTURE_4;
            }
            case 5: {
                return TEXTURE_5;
            }
            case 6: {
                return TEXTURE_6;
            }
            case 7: {
                return TEXTURE_7;
            }
            case 8: {
                return TEXTURE_8;
            }
            case 9: {
                return TEXTURE_9;
            }
            case 10: {
                return TEXTURE_10;
            }
        }
        return TEXTURE_0;
    }
}

