/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.RadgillEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class RadgillModel
extends AdvancedEntityModel<RadgillEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox dorsal2;
    private final AdvancedModelBox tailfin;
    private final AdvancedModelBox dorsal;
    private final AdvancedModelBox bottom_fin;
    private final AdvancedModelBox lfin;
    private final AdvancedModelBox rfin;
    private final AdvancedModelBox jaw;

    public RadgillModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 19.0f, 0.0f);
        this.body.setTextureOffset(0, 0).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 9.0f, 11.0f, 0.0f, false);
        this.body.setTextureOffset(38, 40).addBox(-1.5f, -6.0f, -5.0f, 3.0f, 3.0f, 3.0f, 0.0f, false);
        this.body.setTextureOffset(26, 40).addBox(1.75f, -5.0f, -5.99f, 3.0f, 3.0f, 3.0f, 0.0f, false);
        this.body.setTextureOffset(34, 17).addBox(-4.75f, -5.0f, -5.99f, 3.0f, 3.0f, 3.0f, 0.0f, false);
        this.body.setTextureOffset(23, 0).addBox(-3.0f, -4.0f, -11.0f, 6.0f, 4.0f, 5.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, -1.0f, 4.5f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(18, 20).addBox(-2.0f, -3.0f, 0.5f, 4.0f, 6.0f, 8.0f, 0.0f, false);
        this.dorsal2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dorsal2.setRotationPoint(0.0f, -3.0f, 3.0f);
        this.tail.addChild((BasicModelPart)this.dorsal2);
        this.dorsal2.setTextureOffset(20, 28).addBox(0.0f, -6.0f, -0.5f, 0.0f, 6.0f, 6.0f, 0.0f, false);
        this.tailfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tailfin.setRotationPoint(0.0f, 0.0f, 8.5f);
        this.tail.addChild((BasicModelPart)this.tailfin);
        this.tailfin.setTextureOffset(5, 34).addBox(0.0f, -4.0f, -4.0f, 0.0f, 10.0f, 14.0f, 0.0f, false);
        this.dorsal = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dorsal.setRotationPoint(0.0f, -4.0f, -0.5f);
        this.body.addChild((BasicModelPart)this.dorsal);
        this.dorsal.setTextureOffset(32, 28).addBox(0.0f, -6.0f, -0.5f, 0.0f, 6.0f, 6.0f, 0.0f, false);
        this.bottom_fin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bottom_fin.setRotationPoint(0.0f, 4.0f, 3.0f);
        this.body.addChild((BasicModelPart)this.bottom_fin);
        this.bottom_fin.setTextureOffset(0, 22).addBox(0.0f, -1.0f, -1.0f, 0.0f, 6.0f, 6.0f, 0.0f, false);
        this.lfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lfin.setRotationPoint(3.0f, 2.5f, -1.0f);
        this.body.addChild((BasicModelPart)this.lfin);
        this.setRotateAngle(this.lfin, 0.0f, -0.7854f, 0.0f);
        this.lfin.setTextureOffset(34, 9).addBox(0.0f, -2.5f, 0.0f, 6.0f, 8.0f, 0.0f, 0.0f, false);
        this.rfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rfin.setRotationPoint(-3.0f, 2.5f, -1.0f);
        this.body.addChild((BasicModelPart)this.rfin);
        this.setRotateAngle(this.rfin, 0.0f, 0.7854f, 0.0f);
        this.rfin.setTextureOffset(34, 9).addBox(-6.0f, -2.5f, 0.0f, 6.0f, 8.0f, 0.0f, 0.0f, true);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, 5.0f, -6.0f);
        this.body.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(0, 34).addBox(-3.5f, -6.0f, -5.0f, 7.0f, 6.0f, 6.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.dorsal, (Object)this.dorsal2, (Object)this.tailfin, (Object)this.jaw, (Object)this.bottom_fin, (Object)this.rfin, (Object)this.lfin);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(RadgillEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float swimSpeed = 0.5f;
        float swimDegree = 0.5f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float landProgress = entity.getLandProgress(partialTick);
        float pitchAmount = entity.getFishPitch(partialTick) / 57.295776f;
        this.progressRotationPrev(this.body, landProgress, 0.0f, 0.0f, (float)Math.toRadians(-90.0), 1.0f);
        this.walk(this.jaw, 0.1f, 0.2f, false, 1.0f, -0.2f, ageInTicks, 1.0f);
        this.walk(this.body, 0.1f, 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.lfin, 0.1f, 0.2f, false, -1.0f, -0.2f, ageInTicks, 1.0f);
        this.swing(this.rfin, 0.1f, 0.2f, true, -1.0f, -0.2f, ageInTicks, 1.0f);
        this.bob(this.body, 0.1f, 1.0f, false, ageInTicks, 1.0f);
        this.swing(this.body, swimSpeed, swimDegree * 0.2f, false, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tail, swimSpeed, swimDegree, false, 2.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tailfin, swimSpeed, swimDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.rfin, swimSpeed, swimDegree * 0.9f, true, 0.0f, 0.2f, limbSwing, limbSwingAmount);
        this.swing(this.lfin, swimSpeed, swimDegree * 0.9f, false, 0.0f, 0.2f, limbSwing, limbSwingAmount);
        this.body.rotateAngleX += pitchAmount;
    }
}

