/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import javax.annotation.Nonnull;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Orientation;
import mcjty.lostcities.worldgen.lost.Transform;

public enum Direction {
    XMIN,
    XMAX,
    ZMIN,
    ZMAX;

    public static final Direction[] VALUES;

    public Orientation getOrientation() {
        return this == XMIN || this == XMAX ? Orientation.X : Orientation.Z;
    }

    public Transform getRotation() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case XMIN -> Transform.ROTATE_NONE;
            case XMAX -> Transform.ROTATE_180;
            case ZMIN -> Transform.ROTATE_90;
            case ZMAX -> Transform.ROTATE_270;
        };
    }

    public Direction getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case XMIN -> XMAX;
            case XMAX -> XMIN;
            case ZMIN -> ZMAX;
            case ZMAX -> ZMIN;
        };
    }

    @Nonnull
    public BuildingInfo get(BuildingInfo info) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case XMIN -> info.getXmin();
            case XMAX -> info.getXmax();
            case ZMIN -> info.getZmin();
            case ZMAX -> info.getZmax();
        };
    }

    public boolean atSide(int x, int z) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case XMIN -> {
                if (x == 0) {
                    yield true;
                }
                yield false;
            }
            case XMAX -> {
                if (x == 15) {
                    yield true;
                }
                yield false;
            }
            case ZMIN -> {
                if (z == 0) {
                    yield true;
                }
                yield false;
            }
            case ZMAX -> z == 15;
        };
    }

    static {
        VALUES = new Direction[]{XMIN, XMAX, ZMIN, ZMAX};
    }
}

