/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lostcities.LostCitiesImp;
import mcjty.lostcities.LostCitiesPreImp;
import mcjty.lostcities.setup.ClientSetup;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.CustomRegistries;
import mcjty.lostcities.setup.ModSetup;
import mcjty.lostcities.setup.Registration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lostcities")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LostCities {
    public static final String MODID = "lostcities";
    public static final Logger LOGGER = LogManager.getLogger((String)"lostcities");
    public static final ModSetup setup = new ModSetup();
    public static LostCities instance;
    public static final LostCitiesImp lostCitiesImp;

    public LostCities() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Dist dist = FMLEnvironment.dist;
        instance = this;
        Registration.init(bus);
        CustomRegistries.init(bus);
        Path configPath = FMLPaths.CONFIGDIR.get();
        File dir = new File(configPath + File.separator + MODID);
        dir.mkdirs();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG, "lostcities/client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG, "lostcities/common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        bus.addListener(setup::init);
        bus.addListener(this::processIMC);
        bus.addListener(this::onConstructModEvent);
        bus.addListener(CustomRegistries::onDataPackRegistry);
        if (dist.isClient()) {
            bus.addListener(ClientSetup::init);
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private void onConstructModEvent(FMLConstructModEvent event) {
        event.enqueueWork(() -> event.getIMCStream("getLostCitiesPre"::equals).forEach(message -> {
            Supplier supplier = message.getMessageSupplier();
            ((Function)supplier.get()).apply(new LostCitiesPreImp());
        }));
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream("getLostCities"::equals).forEach(message -> {
            Supplier supplier = message.getMessageSupplier();
            ((Function)supplier.get()).apply(lostCitiesImp);
        });
    }

    static {
        lostCitiesImp = new LostCitiesImp();
    }
}

