/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.mixin;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.util.ModTags;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Raid.class})
public abstract class RaidMixin {
    @Final
    @Shadow
    private static Component f_37665_;
    @Final
    @Shadow
    private Map<Integer, Set<Raider>> f_37671_;
    @Final
    @Shadow
    private ServerBossEvent f_37682_;
    @Shadow
    private float f_37678_;
    @Unique
    private static final String BOSSES_REMAINING = "event.illageandspillage.raid.bosses_remaining";
    @Unique
    private boolean onlyBosses = false;
    @Unique
    private float previousTotalHealth = 0.0f;
    @Unique
    private Set<UUID> oldNonBossUUIDs = new HashSet<UUID>();

    @Shadow
    public abstract int m_37778_();

    @Shadow
    public abstract boolean m_37762_();

    @Shadow
    public abstract boolean m_37706_();

    @Shadow
    public abstract void m_37776_();

    @Unique
    private List<Raider> getBossesInRaid() {
        return this.f_37671_.values().stream().flatMap(Collection::stream).filter(r -> r.m_6095_().m_204039_(ModTags.EntityTypes.ILLAGER_BOSSES)).collect(Collectors.toList());
    }

    @Unique
    private List<Raider> getNonBossesInRaid() {
        return this.f_37671_.values().stream().flatMap(Collection::stream).filter(r -> !r.m_6095_().m_204039_(ModTags.EntityTypes.ILLAGER_BOSSES)).collect(Collectors.toList());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if ((Integer)Config.CommonConfig.bossbar_type.get() != 3 || this.m_37762_() || this.m_37706_()) {
            return;
        }
        List<Raider> bosses = this.getBossesInRaid();
        List<Raider> nonBosses = this.getNonBossesInRaid();
        if (!bosses.isEmpty() && bosses.size() == this.m_37778_()) {
            if (!this.onlyBosses) {
                this.onlyBosses = true;
                this.previousTotalHealth = this.f_37678_;
                this.oldNonBossUUIDs = nonBosses.stream().map(Entity::m_20148_).collect(Collectors.toSet());
                this.f_37682_.m_7003_(((Boolean)Config.CommonConfig.bosses_darken_sky.get()).booleanValue());
            }
            this.f_37678_ = this.getBossesMaxHealth(bosses);
            if (bosses.size() > 2) {
                this.f_37682_.m_6456_((Component)f_37665_.m_6881_().m_130946_(" - ").m_7220_((Component)Component.m_237110_((String)BOSSES_REMAINING, (Object[])new Object[]{bosses.size()})));
            } else if (bosses.size() == 2) {
                this.f_37682_.m_6456_((Component)f_37665_.m_6881_().m_130946_(" - ").m_7220_(bosses.get(0).m_5446_()).m_130946_(" & ").m_7220_(bosses.get(1).m_5446_()));
            } else if (bosses.size() == 1) {
                this.f_37682_.m_6456_((Component)f_37665_.m_6881_().m_130946_(" - ").m_7220_(bosses.get(0).m_5446_()));
            }
            this.m_37776_();
        } else if (this.onlyBosses) {
            this.onlyBosses = false;
            float newRaiderHP = 0.0f;
            Set newlyAdded = nonBosses.stream().map(Entity::m_20148_).collect(Collectors.toSet());
            newlyAdded.removeAll(this.oldNonBossUUIDs);
            for (Raider newNonBoss : nonBosses) {
                if (!newlyAdded.contains(newNonBoss.m_20148_())) continue;
                newRaiderHP += newNonBoss.m_21233_();
            }
            this.f_37678_ = this.previousTotalHealth + newRaiderHP;
            this.f_37682_.m_7003_(false);
        }
    }

    @Unique
    private float getBossesMaxHealth(List<Raider> bosses) {
        float sum = 0.0f;
        for (Raider boss : bosses) {
            sum += boss.m_21233_();
        }
        return sum;
    }
}

