/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities.projectile;

import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WebNetEntity
extends PathfinderMob
implements IllagerAttack {
    private static final EntityDataAccessor<Float> ATTACH_POINT_X = SynchedEntityData.m_135353_(WebNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ATTACH_POINT_Y = SynchedEntityData.m_135353_(WebNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ATTACH_POINT_Z = SynchedEntityData.m_135353_(WebNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> CAUGHT = SynchedEntityData.m_135353_(WebNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    public LivingEntity shooter = null;
    private boolean shouldReturn = false;
    private LivingEntity pullingEntity;
    private int pullPower;

    public WebNetEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.f_19811_ = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACH_POINT_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACH_POINT_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACH_POINT_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CAUGHT, (Object)false);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource bullcrap) {
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    public boolean isCaught() {
        return (Boolean)this.f_19804_.m_135370_(CAUGHT);
    }

    public void setCaught(boolean caught) {
        this.f_19804_.m_135381_(CAUGHT, (Object)caught);
    }

    public void m_8119_() {
        double motionZ;
        double motionY;
        double motionX;
        float power;
        double d;
        double z;
        this.m_20331_(true);
        this.m_20242_(true);
        this.f_19794_ = true;
        EntityUtil.makeWebParticles(this.m_9236_(), (Entity)this);
        WebNetEntity attacker = this.shooter != null ? this.shooter : this;
        List list = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 1.0, this.m_20186_() - 1.0, this.m_20189_() - 1.0, this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0), Entity::m_6084_);
        for (Entity entity : list) {
            if (this.shouldReturn || this.isCaught() || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            boolean canHurt = attacker instanceof Mob ? EntityUtil.canHurtThisMob((Entity)living, (Mob)attacker) : living != this.shooter;
            if (!canHurt || !entity.m_6084_() || entity.m_20147_() || entity.m_5833_()) continue;
            if (!this.m_9236_().f_46443_) {
                this.setCaught(true);
            }
            living.m_6469_(this.m_269291_().m_269390_((Entity)living, (Entity)attacker), 2.0f);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB_HIT.get(), 1.0f, this.m_6100_());
            this.pullingEntity = living;
        }
        if (!this.m_9236_().f_46443_ && this.shooter != null && this.shooter.m_6084_()) {
            float radius2 = -2.0f;
            double x2 = this.shooter.m_20185_() + (double)0.8f * Math.sin((double)(-this.shooter.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.shooter.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.shooter.m_146909_()) * Math.PI / 180.0);
            double z2 = this.shooter.m_20189_() + (double)0.8f * Math.cos((double)(-this.shooter.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.shooter.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.shooter.m_146909_()) * Math.PI / 180.0);
            this.setAttachPoint(x2, this.shooter.m_20186_() + 1.0, z2);
        }
        if (!this.isCaught()) {
            this.m_20334_(this.accelerationX, this.accelerationY, this.accelerationZ);
        } else if (this.pullingEntity != null && this.pullingEntity.m_6084_()) {
            this.m_146884_(this.pullingEntity.m_20191_().m_82399_());
        } else if (!this.m_9236_().f_46443_) {
            this.setCaught(false);
        }
        if (this.pullingEntity != null && this.m_20280_((Entity)this.pullingEntity) <= 4.0) {
            if (this.f_19797_ % 10 == 0) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB_HIT.get(), 1.0f, this.m_6100_());
            }
            this.pullPower += 2;
            double x = this.getAttachPoint().f_82479_ - this.pullingEntity.m_20185_();
            double y = this.getAttachPoint().f_82480_ - this.pullingEntity.m_20186_();
            z = this.getAttachPoint().f_82481_ - this.pullingEntity.m_20189_();
            d = Math.sqrt(x * x + y * y + z * z);
            power = (float)this.pullPower / 80.0f;
            motionX = this.pullingEntity.m_20184_().f_82479_ + x / d * (double)power * 0.2;
            motionY = this.pullingEntity.m_20184_().f_82480_ + y / d * (double)power * 0.2;
            motionZ = this.pullingEntity.m_20184_().f_82481_ + z / d * (double)power * 0.2;
            this.pullingEntity.f_19864_ = true;
            this.pullingEntity.m_20334_(motionX, motionY, motionZ);
            this.pullingEntity.m_6001_(motionX, motionY, motionZ);
        }
        if (this.f_19797_ > 20 || this.pullingEntity != null) {
            this.shouldReturn = true;
            if (this.shooter instanceof RagnoEntity) {
                ((RagnoEntity)this.shooter).setAnimationState(20);
            }
        }
        if (this.shouldReturn && this.shooter != null) {
            double x = this.m_20185_() - this.getAttachPoint().f_82479_;
            double y = this.m_20186_() - this.getAttachPoint().f_82480_;
            z = this.m_20189_() - this.getAttachPoint().f_82481_;
            d = Math.sqrt(x * x + y * y + z * z);
            power = 10.0f;
            motionX = -(x / d * (double)power * 0.2);
            motionY = -(y / d * (double)power * 0.2);
            motionZ = -(z / d * (double)power * 0.2);
            this.setAcceleration(motionX, motionY, motionZ);
            if (this.m_20280_((Entity)this.shooter) < 12.25) {
                LivingEntity livingEntity;
                if (this.pullingEntity != null) {
                    this.pullingEntity.m_20334_(0.0, 0.0, 0.0);
                    livingEntity = this.pullingEntity;
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(this.pullingEntity.m_19879_(), new Vec3(0.0, 0.0, 0.0)));
                    }
                }
                if ((livingEntity = this.shooter) instanceof RagnoEntity) {
                    RagnoEntity ragno = (RagnoEntity)livingEntity;
                    if (ragno.getAttackTicks() > 15 && ragno.waitingForWeb && this.pullingEntity != null && this.pullingEntity.m_6084_()) {
                        ragno.followupTicks = 1;
                    }
                    ragno.waitingForWeb = false;
                }
                if (!this.m_9236_().f_46443_) {
                    this.setCaught(false);
                    this.m_146870_();
                }
            }
        }
        if (this.f_19797_ >= 100 && !this.m_9236_().f_46443_) {
            if (this.shooter instanceof RagnoEntity) {
                ((RagnoEntity)this.shooter).waitingForWeb = false;
            }
            this.m_146870_();
        }
        if (this.shooter != null && !this.shooter.m_6084_()) {
            this.m_146870_();
        }
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
    }

    public void setAttachPoint(double x, double y, double z) {
        this.f_19804_.m_135381_(ATTACH_POINT_X, (Object)Float.valueOf((float)x));
        this.f_19804_.m_135381_(ATTACH_POINT_Y, (Object)Float.valueOf((float)y));
        this.f_19804_.m_135381_(ATTACH_POINT_Z, (Object)Float.valueOf((float)z));
    }

    public Vec3 getAttachPoint() {
        return new Vec3((double)((Float)this.f_19804_.m_135370_(ATTACH_POINT_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(ATTACH_POINT_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(ATTACH_POINT_Z)).floatValue());
    }

    public void setAcceleration(double x, double y, double z) {
        this.accelerationX = x;
        this.accelerationY = y;
        this.accelerationZ = z;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    public void m_7334_(Entity entityIn) {
    }
}

