/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.entities.EngineerMachine;
import com.yellowbrossproductions.illageandspillage.entities.FactoryMinion;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ChagrinSentryEntity
extends Raider
implements ICanBeAnimated,
EngineerMachine,
IllagerAttack {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(ChagrinSentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> PARTIAL_TICKS = SynchedEntityData.m_135353_(ChagrinSentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IN_MOTION = SynchedEntityData.m_135353_(ChagrinSentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOW_LOCKER = SynchedEntityData.m_135353_(ChagrinSentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> STUN_TICKS = SynchedEntityData.m_135353_(ChagrinSentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState shootingAnimationState = new AnimationState();
    public AnimationState stunAnimationState = new AnimationState();
    private int introTicks;
    private int attackTicks;
    private boolean isPlayingIntro;
    private boolean isShooting;
    private boolean isStunned;
    private int arrowsFired;
    private LivingEntity owner;

    public ChagrinSentryEntity(EntityType<? extends Raider> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StunGoal());
        this.f_21345_.m_25352_(1, (Goal)new RapidFireGoal());
        this.f_21345_.m_25352_(9, (Goal)new ChagrinSentryLookAtEntityGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new ChagrinSentryLookAtEntityGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof Raider || entity instanceof EngineerMachine || entity instanceof FactoryMinion) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public boolean m_37882_() {
        return false;
    }

    public boolean m_7492_() {
        return false;
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(IN_MOTION, (Object)false);
        this.f_19804_.m_135372_(SHOW_LOCKER, (Object)false);
        this.f_19804_.m_135372_(STUN_TICKS, (Object)0);
        this.f_19804_.m_135372_(PARTIAL_TICKS, (Object)Float.valueOf(0.0f));
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean isInMotion() {
        return (Boolean)this.f_19804_.m_135370_(IN_MOTION);
    }

    public void setInMotion(boolean motion) {
        this.f_19804_.m_135381_(IN_MOTION, (Object)motion);
    }

    public boolean shouldShowLocker() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_LOCKER);
    }

    public void setShowLocker(boolean showLocker) {
        this.f_19804_.m_135381_(SHOW_LOCKER, (Object)showLocker);
    }

    public int getStunTicks() {
        return (Integer)this.f_19804_.m_135370_(STUN_TICKS);
    }

    public void setStunTicks(int stunTicks) {
        this.f_19804_.m_135381_(STUN_TICKS, (Object)stunTicks);
    }

    public float getPartialTicks() {
        return ((Float)this.f_19804_.m_135370_(PARTIAL_TICKS)).floatValue();
    }

    public void setPartialTicks(float partialTicks) {
        this.f_19804_.m_135381_(PARTIAL_TICKS, (Object)Float.valueOf(partialTicks));
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isInMotion()) {
            this.introTicks = 1;
            this.isPlayingIntro = true;
            this.setAnimationState(1);
            this.setInMotion(false);
        }
        return false;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12600_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER_DESTROY.get();
    }

    @Override
    public AnimationState getAnimationState(String var1) {
        if (Objects.equals(var1, "intro")) {
            return this.introAnimationState;
        }
        if (Objects.equals(var1, "shooting")) {
            return this.shootingAnimationState;
        }
        if (Objects.equals(var1, "stun")) {
            return this.stunAnimationState;
        }
        return new AnimationState();
    }

    @Override
    public float getAnimationSpeed() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 2 ? 1.25f : 1.0f;
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.introAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.shootingAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.stunAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    private void stopAllAnimationStates() {
        this.introAnimationState.m_216973_();
        this.shootingAnimationState.m_216973_();
        this.stunAnimationState.m_216973_();
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public void m_8119_() {
        if (this.introTicks == 1) {
            this.m_216990_(SoundEvents.f_12600_);
            this.setShowLocker(true);
        }
        if (this.introTicks > 0) {
            ++this.introTicks;
        }
        if (this.introTicks == 25) {
            this.m_5496_(SoundEvents.f_12312_, 1.0f, 0.8f);
        }
        if (this.introTicks == 30) {
            this.m_5496_(SoundEvents.f_12312_, 1.0f, 0.8f);
        }
        if (this.introTicks == 57) {
            this.m_216990_(SoundEvents.f_12600_);
        }
        if (!(this.m_9236_().f_46443_ || this.introTicks >= 1 && this.introTicks <= 60)) {
            this.setShowLocker(this.isInMotion());
        }
        if (this.introTicks == 60) {
            this.setShowLocker(false);
            this.setAnimationState(0);
            this.isPlayingIntro = false;
        }
        if (this.isShooting) {
            ++this.attackTicks;
        }
        if (this.m_6084_()) {
            if (this.attackTicks == 6) {
                this.setAnimationState(2);
            }
            if (this.attackTicks >= 6 && this.attackTicks % 2 == 0) {
                this.fireArrow(this.m_5448_(), 1.0f, 5.0f);
                ++this.arrowsFired;
            }
        }
        if (!this.isShooting && this.arrowsFired > 0 && this.f_19797_ % 5 == 0) {
            --this.arrowsFired;
        }
        if (this.arrowsFired >= 45 && !this.isStunned && this.f_19796_.m_188503_(5) == 0) {
            this.makeOverheatParticles();
        }
        if (this.isStunned) {
            if (this.getStunTicks() < 190) {
                this.makeOverheatParticles();
            }
            this.setStunTicks(this.getStunTicks() + 1);
        }
        if (!this.isInMotion()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.m_20096_() && this.isInMotion()) {
            if (this.introTicks < 1) {
                this.introTicks = 1;
                this.isPlayingIntro = true;
                this.setAnimationState(1);
            }
            this.setInMotion(false);
        }
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
    }

    public void makeOverheatParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                packet.queueParticle((ParticleOptions)ParticleTypes.f_123762_, false, new Vec3(this.m_20208_(0.15) + (-0.5 + this.f_19796_.m_188500_()) * 2.5, this.m_20187_() + (-0.5 + this.f_19796_.m_188500_()) * 1.5, this.m_20262_(0.15) + (-0.5 + this.f_19796_.m_188500_()) * 2.5), new Vec3(0.0, 0.0, 0.0));
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void fireArrow(LivingEntity target, float p_82196_2_, float inaccuracy) {
        if (target == null) {
            return;
        }
        AbstractArrow abstractarrowentity = this.getArrow(Items.f_42411_.m_7968_(), p_82196_2_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        float f = this.f_20883_ * ((float)Math.PI / 180) * 0.25f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f);
        if (this.attackTicks % 4 == 0) {
            abstractarrowentity.m_6034_(this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 0.8, this.m_20189_() + (double)f2 * 0.6);
        } else {
            abstractarrowentity.m_6034_(this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 0.8, this.m_20189_() - (double)f2 * 0.6);
        }
        double d0 = target.m_20185_() - abstractarrowentity.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_() - (double)target.m_20206_() / 2.0;
        double d2 = target.m_20189_() - abstractarrowentity.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        float speed = this.m_20280_((Entity)target) > 22.5 ? 2.5f : (float)(this.m_20280_((Entity)target) / 9.0);
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, speed, inaccuracy);
        this.m_9236_().m_7967_((Entity)abstractarrowentity);
        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SHOOT.get(), 0.5f, this.m_6100_());
        this.m_5496_(SoundEvents.f_11687_, 1.0f, this.m_6100_());
    }

    protected AbstractArrow getArrow(ItemStack p_213624_1_, float p_213624_2_) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)p_213624_1_, (float)p_213624_2_);
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        return p_21016_.m_7639_() != this && super.m_6469_(p_21016_, p_21017_);
    }

    public SoundEvent m_7930_() {
        return null;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (this.m_9236_().f_46443_) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        this.f_20919_ = 19;
    }

    class StunGoal
    extends Goal {
        StunGoal() {
        }

        public boolean m_8036_() {
            return !ChagrinSentryEntity.this.isInMotion() && ChagrinSentryEntity.this.getStunTicks() < 1 && !ChagrinSentryEntity.this.isPlayingIntro && ChagrinSentryEntity.this.arrowsFired > 60;
        }

        public void m_8056_() {
            ChagrinSentryEntity.this.setAnimationState(3);
            ChagrinSentryEntity.this.isStunned = true;
            ChagrinSentryEntity.this.m_5496_(SoundEvents.f_11914_, 1.0f, 0.8f);
        }

        public boolean m_8045_() {
            return ChagrinSentryEntity.this.getStunTicks() <= 200;
        }

        public void m_8041_() {
            ChagrinSentryEntity.this.setAnimationState(0);
            ChagrinSentryEntity.this.isStunned = false;
            ChagrinSentryEntity.this.setStunTicks(0);
            ChagrinSentryEntity.this.arrowsFired = 0;
        }
    }

    class RapidFireGoal
    extends Goal {
        RapidFireGoal() {
        }

        public boolean m_8036_() {
            return !ChagrinSentryEntity.this.isInMotion() && ChagrinSentryEntity.this.getStunTicks() < 1 && !ChagrinSentryEntity.this.isPlayingIntro && ChagrinSentryEntity.this.m_5448_() != null && ChagrinSentryEntity.this.m_5448_().m_6084_() && ChagrinSentryEntity.this.m_142582_((Entity)ChagrinSentryEntity.this.m_5448_()) && ChagrinSentryEntity.this.arrowsFired <= 100;
        }

        public void m_8056_() {
            ChagrinSentryEntity.this.isShooting = true;
            ChagrinSentryEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_LOAD.get(), 2.0f, 1.0f);
        }

        public void m_8037_() {
            if (ChagrinSentryEntity.this.m_5448_() != null) {
                ChagrinSentryEntity.this.m_21563_().m_24960_((Entity)ChagrinSentryEntity.this.m_5448_(), 100.0f, 100.0f);
            }
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8041_() {
            if (!ChagrinSentryEntity.this.isStunned) {
                ChagrinSentryEntity.this.setAnimationState(0);
            }
            ChagrinSentryEntity.this.isShooting = false;
            ChagrinSentryEntity.this.attackTicks = 0;
        }
    }

    class ChagrinSentryLookAtEntityGoal
    extends LookAtPlayerGoal {
        public ChagrinSentryLookAtEntityGoal(Mob p_25524_, Class<? extends LivingEntity> p_25525_, float p_25526_, float p_25527_) {
            super(p_25524_, p_25525_, p_25526_, p_25527_);
        }

        public ChagrinSentryLookAtEntityGoal(Mob p_25524_, Class<? extends LivingEntity> p_25525_, float p_25526_) {
            super(p_25524_, p_25525_, p_25526_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !ChagrinSentryEntity.this.isShooting && !ChagrinSentryEntity.this.isStunned;
        }

        public boolean m_8045_() {
            return super.m_8045_() && !ChagrinSentryEntity.this.isShooting && !ChagrinSentryEntity.this.isStunned;
        }
    }
}

