/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.sound;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicSound;
import com.yellowbrossproductions.illageandspillage.entities.FreakagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.MagispellerEntity;
import com.yellowbrossproductions.illageandspillage.entities.OldFreakagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.OldRagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.SpiritcallerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="illageandspillage", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BossMusicPlayer {
    public static BossMusicSound bossMusic;

    public static void playBossMusic(Raider entity) {
        if (((Boolean)Config.CommonConfig.boss_music.get()).booleanValue()) {
            if (entity instanceof SpiritcallerEntity) {
                BossMusicPlayer.doSpiritcallerMusic((SpiritcallerEntity)entity);
            } else if (entity instanceof FreakagerEntity) {
                BossMusicPlayer.doFreakagerMusic((FreakagerEntity)entity);
            } else if (entity instanceof RagnoEntity) {
                BossMusicPlayer.doRagnoMusic((RagnoEntity)entity);
            } else if (entity instanceof OldFreakagerEntity) {
                BossMusicPlayer.doOldFreakagerMusic((OldFreakagerEntity)entity);
            } else if (entity instanceof OldRagnoEntity) {
                BossMusicPlayer.doOldRagnoMusic((OldRagnoEntity)entity);
            } else if (entity instanceof MagispellerEntity) {
                BossMusicPlayer.doMagispellerMusic((MagispellerEntity)entity);
            }
        }
    }

    public static void doRagnoMusic(RagnoEntity entity) {
        SoundEvent soundEvent = entity.getTransMusic();
        if (soundEvent != null && entity.m_6084_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (bossMusic != null) {
                float f2 = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS);
                if (f2 <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity && !entity.canPlayerHearMusic((Player)player)) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss(entity);
                }
            } else if (entity.canPlayerHearMusic((Player)player)) {
                bossMusic = new BossMusicSound(soundEvent, entity);
            }
            if (bossMusic != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)bossMusic)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossMusic);
            }
        }
    }

    public static void doOldRagnoMusic(OldRagnoEntity entity) {
        SoundEvent soundEvent = entity.getTransMusic();
        if (soundEvent != null && entity.m_6084_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (bossMusic != null) {
                float f2 = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS);
                if (f2 <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity && !entity.canPlayerHearMusic((Player)player)) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss(entity);
                }
            } else if (entity.canPlayerHearMusic((Player)player)) {
                bossMusic = new BossMusicSound(soundEvent, entity);
            }
            if (bossMusic != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)bossMusic)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossMusic);
            }
        }
    }

    private static void doSpiritcallerMusic(SpiritcallerEntity entity) {
        SoundEvent soundEvent = entity.getBossMusic();
        if (soundEvent != null && entity.m_6084_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (bossMusic != null) {
                float f2 = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS);
                if (f2 <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity && !entity.canPlayerHearMusic((Player)player)) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss((Raider)entity);
                }
            } else if (entity.canPlayerHearMusic((Player)player)) {
                bossMusic = new BossMusicSound(soundEvent, (Raider)entity);
            }
            if (bossMusic != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)bossMusic)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossMusic);
            }
        }
    }

    private static void doFreakagerMusic(FreakagerEntity entity) {
        SoundEvent soundEvent = entity.getBossMusic();
        if (soundEvent != null && entity.m_6084_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (bossMusic != null) {
                float f2 = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS);
                if (f2 <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity && !entity.canPlayerHearMusic((Player)player)) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss((Raider)entity);
                }
            } else if (entity.canPlayerHearMusic((Player)player)) {
                bossMusic = new BossMusicSound(soundEvent, (Raider)entity);
            }
            if (bossMusic != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)bossMusic)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossMusic);
            }
        }
    }

    private static void doOldFreakagerMusic(OldFreakagerEntity entity) {
        SoundEvent soundEvent = entity.getBossMusic();
        if (soundEvent != null && entity.m_6084_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (bossMusic != null) {
                float f2 = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS);
                if (f2 <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity && !entity.canPlayerHearMusic((Player)player)) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss((Raider)entity);
                }
            } else if (entity.canPlayerHearMusic((Player)player)) {
                bossMusic = new BossMusicSound(soundEvent, (Raider)entity);
            }
            if (bossMusic != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)bossMusic)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossMusic);
            }
        }
    }

    private static void doMagispellerMusic(MagispellerEntity entity) {
        SoundEvent soundEvent = entity.getBossMusic();
        if (soundEvent != null && entity.m_6084_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (bossMusic != null) {
                float f2 = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS);
                if (f2 <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity && !entity.canPlayerHearMusic((Player)player)) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss((Raider)entity);
                }
            } else if (entity.canPlayerHearMusic((Player)player)) {
                bossMusic = new BossMusicSound(soundEvent, (Raider)entity);
            }
            if (bossMusic != null && !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)bossMusic)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossMusic);
            }
        }
    }

    public static void stopBossMusic(Raider entity) {
        if (((Boolean)Config.CommonConfig.boss_music.get()).booleanValue() && bossMusic != null && bossMusic.getBoss() == entity) {
            bossMusic.setBoss(null);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (bossMusic != null && bossMusic.shouldChangeMusic()) {
            Raider boss = bossMusic.getBoss();
            if (boss instanceof RagnoEntity) {
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)bossMusic);
                bossMusic = null;
                BossMusicSound newMusic = new BossMusicSound(((RagnoEntity)boss).getBossMusic(), boss);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)newMusic);
                bossMusic = newMusic;
            } else if (boss instanceof OldRagnoEntity) {
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)bossMusic);
                bossMusic = null;
                BossMusicSound newMusic = new BossMusicSound(((OldRagnoEntity)boss).getBossMusic(), boss);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)newMusic);
                bossMusic = newMusic;
            }
            bossMusic.resetChangeMusic();
        }
    }
}

