/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render.layer.igniter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.IgniterModel;
import com.yellowbrossproductions.illageandspillage.entities.IgniterEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IgniterOverheatLayer<T extends LivingEntity>
extends RenderLayer<T, IgniterModel<T>> {
    private static final RenderType LAYER1 = RenderType.m_110488_((ResourceLocation)new ResourceLocation("illageandspillage", "textures/entity/igniter/heat_layer1.png"));
    private static final RenderType LAYER2 = RenderType.m_110488_((ResourceLocation)new ResourceLocation("illageandspillage", "textures/entity/igniter/heat_layer2.png"));
    private static final RenderType LAYER3 = RenderType.m_110488_((ResourceLocation)new ResourceLocation("illageandspillage", "textures/entity/igniter/heat_layer3.png"));
    private static final RenderType LAYER4 = RenderType.m_110488_((ResourceLocation)new ResourceLocation("illageandspillage", "textures/entity/igniter/heat_layer4.png"));
    private static final RenderType LAYER5 = RenderType.m_110488_((ResourceLocation)new ResourceLocation("illageandspillage", "textures/entity/igniter/heat_layer5.png"));

    public IgniterOverheatLayer(RenderLayerParent<T, IgniterModel<T>> p_i226039_1_) {
        super(p_i226039_1_);
    }

    public RenderType getLayer(float percent, IgniterEntity igniter) {
        if (igniter.isOverheated()) {
            if (percent <= 0.2f) {
                return LAYER1;
            }
            if (percent > 0.2f && percent <= 0.4f) {
                return LAYER2;
            }
            if (percent > 0.4f && percent <= 0.6f) {
                return LAYER3;
            }
            if (percent > 0.6f && percent <= 0.8f) {
                return LAYER4;
            }
            if (percent > 0.8f) {
                return LAYER5;
            }
        } else {
            if (percent > 0.2f && percent <= 0.4f) {
                return LAYER1;
            }
            if (percent > 0.4f && percent <= 0.6f) {
                return LAYER2;
            }
            if (percent > 0.6f && percent <= 0.8f) {
                return LAYER3;
            }
            if (percent > 0.8f) {
                return LAYER4;
            }
        }
        return LAYER1;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IgniterEntity igniter;
        if (entity instanceof IgniterEntity && !(igniter = (IgniterEntity)((Object)entity)).m_20145_()) {
            float percent;
            float f = percent = igniter.isOverheated() ? igniter.getCooldownTicks() / 300.0f : igniter.getFireballsShot() / 25.0f;
            if (percent > 0.2f || igniter.isOverheated()) {
                VertexConsumer vertexConsumer = bufferSource.m_6299_(this.getLayer(percent, igniter));
                ((IgniterModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

