/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yellowbrossproductions.illageandspillage.client.model.BeeperModel;
import com.yellowbrossproductions.illageandspillage.client.render.layer.engineer.BeeperBeepLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.engineer.BeeperGlowLayer;
import com.yellowbrossproductions.illageandspillage.entities.BeeperEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BeeperRenderer
extends MobRenderer<BeeperEntity, BeeperModel<BeeperEntity>> {
    private static final ResourceLocation BEEPER = new ResourceLocation("illageandspillage", "textures/entity/engineer/factory/beeper.png");
    private static final ResourceLocation BEEPING = new ResourceLocation("illageandspillage", "textures/entity/engineer/factory/beeping.png");

    public BeeperRenderer(EntityRendererProvider.Context context) {
        super(context, new BeeperModel(context.m_174023_(BeeperModel.LAYER_LOCATION)), 0.3f);
        this.m_115326_((RenderLayer)new BeeperGlowLayer(this));
        this.m_115326_((RenderLayer)new BeeperBeepLayer(this));
    }

    protected void scale(BeeperEntity entityLivingBaseIn, PoseStack matrixStackIn, float partialTickTime) {
        entityLivingBaseIn.setPartialTicks(partialTickTime);
        float creeperFlashIntensity = entityLivingBaseIn.getCreeperFlashIntensity(partialTickTime);
        float mathsThing = 1.0f + Mth.m_14031_((float)(creeperFlashIntensity * 100.0f)) * creeperFlashIntensity * 0.01f;
        creeperFlashIntensity = Mth.m_14036_((float)creeperFlashIntensity, (float)0.0f, (float)1.0f);
        creeperFlashIntensity *= creeperFlashIntensity;
        creeperFlashIntensity *= creeperFlashIntensity;
        float multipliedByMathsThing = (1.0f + creeperFlashIntensity * 0.4f) * mathsThing;
        float dividedByMathsThing = (1.0f + creeperFlashIntensity * 0.1f) / mathsThing;
        matrixStackIn.m_85841_(multipliedByMathsThing, dividedByMathsThing, multipliedByMathsThing);
    }

    protected float getWhiteOverlayProgress(BeeperEntity livingEntityIn, float partialTicks) {
        float flashIntensity = livingEntityIn.getCreeperFlashIntensity(partialTicks);
        return (int)(flashIntensity * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)flashIntensity, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(BeeperEntity entity) {
        return entity.getCreeperFlashIntensity(entity.getPartialTicks()) > 0.0f ? BEEPING : BEEPER;
    }
}

