/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.entities.SpiritcallerEntity;
import java.util.Calendar;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SpiritcallerModel<T extends Entity>
extends EntityModel<T>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "spiritcaller"), "main");
    private final ModelPart body;
    private final ModelPart book;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public SpiritcallerModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.book = root.m_171324_("book");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition birthday = head.m_171599_("birthday", CubeListBuilder.m_171558_().m_171514_(138, 120).m_171488_(-2.0f, -9.3333f, 6.0833f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(126, 120).m_171488_(-1.5f, -12.3333f, 6.5833f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(154, 117).m_171488_(0.0f, -15.3333f, 6.5833f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.6667f, (float)-8.0833f));
        birthday.m_171599_("thingy", CubeListBuilder.m_171558_().m_171514_(154, 120).m_171488_(-1.5f, -15.3333f, 8.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition halohead = body.m_171599_("halohead", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        halohead.m_171599_("halo", CubeListBuilder.m_171558_().m_171514_(80, 115).m_171488_(-6.0f, -1.0f, -6.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(56, 44).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.7854f));
        right_arm.m_171599_("magic1", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)0.0f));
        PartDefinition hand1 = right_arm.m_171599_("hand1", CubeListBuilder.m_171558_().m_171514_(100, 51).m_171488_(-11.0f, -3.0f, -4.0f, 22.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)12.0f, (float)0.0f));
        PartDefinition finger1 = hand1.m_171599_("finger1", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller1 = finger1.m_171599_("fingersmaller1", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller1.m_171599_("fingersmallest1", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger5 = hand1.m_171599_("finger5", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-11.0f, (float)10.0f, (float)-4.0f, (float)-1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition fingersmaller5 = finger5.m_171599_("fingersmaller5", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller5.m_171599_("fingersmallest5", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger2 = hand1.m_171599_("finger2", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller2 = finger2.m_171599_("fingersmaller2", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller2.m_171599_("fingersmallest2", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger3 = hand1.m_171599_("finger3", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller3 = finger3.m_171599_("fingersmaller3", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller3.m_171599_("fingersmallest3", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger4 = hand1.m_171599_("finger4", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller4 = finger4.m_171599_("fingersmaller4", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller4.m_171599_("fingersmallest4", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 44).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)-0.7854f));
        left_arm.m_171599_("magic2", CubeListBuilder.m_171558_().m_171514_(80, 16).m_171488_(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)16.0f, (float)0.0f));
        PartDefinition hand2 = left_arm.m_171599_("hand2", CubeListBuilder.m_171558_().m_171514_(100, 83).m_171488_(-11.0f, -3.0f, -4.0f, 22.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)12.0f, (float)0.0f));
        PartDefinition finger6 = hand2.m_171599_("finger6", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller6 = finger6.m_171599_("fingersmaller6", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller6.m_171599_("fingersmallest6", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger7 = hand2.m_171599_("finger7", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)11.0f, (float)10.0f, (float)-4.0f, (float)-1.5708f, (float)0.0f, (float)-1.5708f));
        PartDefinition fingersmaller7 = finger7.m_171599_("fingersmaller7", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller7.m_171599_("fingersmallest7", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger8 = hand2.m_171599_("finger8", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller8 = finger8.m_171599_("fingersmaller8", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller8.m_171599_("fingersmallest8", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger9 = hand2.m_171599_("finger9", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller9 = finger9.m_171599_("fingersmaller9", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller9.m_171599_("fingersmallest9", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition finger10 = hand2.m_171599_("finger10", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)21.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition fingersmaller10 = finger10.m_171599_("fingersmaller10", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        fingersmaller10.m_171599_("fingersmallest10", CubeListBuilder.m_171558_().m_171514_(132, 32).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition wing1 = body.m_171599_("wing1", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171488_(0.0f, -24.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)3.0f));
        PartDefinition wing_small1 = wing1.m_171599_("wing_small1", CubeListBuilder.m_171558_().m_171514_(20, 96).m_171488_(0.0f, -20.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)-4.0f, (float)0.0f));
        PartDefinition wing_smaller1 = wing_small1.m_171599_("wing_smaller1", CubeListBuilder.m_171558_().m_171514_(40, 96).m_171488_(0.0f, -20.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)0.0f, (float)0.0f));
        wing_smaller1.m_171599_("wing_smallest1", CubeListBuilder.m_171558_().m_171514_(60, 96).m_171488_(0.0f, -20.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)0.0f, (float)0.0f));
        PartDefinition wing2 = body.m_171599_("wing2", CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(0.0f, -24.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)3.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition wing_small2 = wing2.m_171599_("wing_small2", CubeListBuilder.m_171558_().m_171514_(20, 64).m_171488_(0.0f, -20.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)-4.0f, (float)0.0f));
        PartDefinition wing_smaller2 = wing_small2.m_171599_("wing_smaller2", CubeListBuilder.m_171558_().m_171514_(40, 64).m_171488_(0.0f, -20.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)0.0f, (float)0.0f));
        wing_smaller2.m_171599_("wing_smallest2", CubeListBuilder.m_171558_().m_171514_(60, 64).m_171488_(0.0f, -20.0f, 0.0f, 10.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)0.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)0.3f));
        PartDefinition arms_rotation = arms.m_171599_("arms_rotation", CubeListBuilder.m_171558_().m_171514_(56, 20).m_171488_(-8.0f, 0.0f, -2.05f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 36).m_171480_().m_171488_(-4.0f, 8.0f, -2.05f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.05f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        arms_rotation.m_171599_("arms_flipped", CubeListBuilder.m_171558_().m_171514_(40, 20).m_171488_(4.0f, 0.0f, -2.05f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_leg2", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        body.m_171599_("right_leg2", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition book = partdefinition.m_171599_("book", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-12.0f, (float)-2.618f, (float)0.0f, (float)0.0f));
        PartDefinition cover_left = book.m_171599_("cover_left", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        cover_left.m_171599_("cover_left_rotation", CubeListBuilder.m_171558_().m_171514_(110, 32).m_171488_(-3.0f, -5.0f, 0.0f, 6.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition cover_right = book.m_171599_("cover_right", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        cover_right.m_171599_("cover_right_rotation", CubeListBuilder.m_171558_().m_171514_(94, 32).m_171488_(-3.0f, -5.0f, 0.0f, 6.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition book_spine = book.m_171599_("book_spine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        book_spine.m_171599_("spine_rotation", CubeListBuilder.m_171558_().m_171514_(106, 32).m_171488_(-1.0f, -5.0f, 0.0f, 2.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition pages_left = book.m_171599_("pages_left", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.075f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        pages_left.m_171599_("page_left_rotation", CubeListBuilder.m_171558_().m_171514_(106, 42).m_171488_(-2.5f, -4.0f, -0.5f, 5.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)0.475f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition pages_right = book.m_171599_("pages_right", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.125f, (float)0.0f, (float)0.2618f, (float)0.0f));
        pages_right.m_171599_("page_right_rotation", CubeListBuilder.m_171558_().m_171514_(94, 42).m_171488_(-2.5f, -4.0f, -0.5f, 5.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)-0.475f, (float)0.0f, (float)3.1416f, (float)-3.1416f));
        PartDefinition flipping_page_left = book.m_171599_("flipping_page_left", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.075f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        flipping_page_left.m_171599_("flip_left_rotation", CubeListBuilder.m_171558_().m_171514_(118, 42).m_171488_(-2.5f, -4.0f, 0.0f, 5.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)-0.025f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition flipping_page_right = book.m_171599_("flipping_page_right", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.125f, (float)0.0f, (float)0.2618f, (float)0.0f));
        flipping_page_right.m_171599_("flip_right_rotation", CubeListBuilder.m_171558_().m_171514_(118, 42).m_171488_(-2.5f, -4.0f, 0.0f, 5.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)0.025f, (float)0.0f, (float)3.1416f, (float)-3.1416f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)8.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)160, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f3 = ageInTicks / 60.0f;
        ModelPart wing1 = this.body.m_171324_("wing1");
        ModelPart wing_small1 = this.body.m_171324_("wing1").m_171324_("wing_small1");
        ModelPart wing_smaller1 = this.body.m_171324_("wing1").m_171324_("wing_small1").m_171324_("wing_smaller1");
        ModelPart wing_smallest1 = this.body.m_171324_("wing1").m_171324_("wing_small1").m_171324_("wing_smaller1").m_171324_("wing_smallest1");
        ModelPart wing2 = this.body.m_171324_("wing2");
        ModelPart wing_small2 = this.body.m_171324_("wing2").m_171324_("wing_small2");
        ModelPart wing_smaller2 = this.body.m_171324_("wing2").m_171324_("wing_small2").m_171324_("wing_smaller2");
        ModelPart wing_smallest2 = this.body.m_171324_("wing2").m_171324_("wing_small2").m_171324_("wing_smaller2").m_171324_("wing_smallest2");
        this.book.f_104201_ = Mth.m_14031_((float)(f3 * 5.0f)) * 0.5f;
        if (entity instanceof SpiritcallerEntity) {
            SpiritcallerEntity spiritcaller = (SpiritcallerEntity)((Object)entity);
            Calendar calendar = Calendar.getInstance();
            this.body.m_171324_((String)"head").m_171324_((String)"birthday").f_104207_ = calendar.get(2) == 1 && calendar.get(5) < 8;
            this.body.m_171324_((String)"head").f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.body.m_171324_((String)"head").f_104203_ = -0.0873f + headPitch * ((float)Math.PI / 180);
            this.body.m_171324_((String)"halohead").f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.body.m_171324_((String)"halohead").f_104203_ = -0.0873f + headPitch * ((float)Math.PI / 180);
            this.body.m_171324_((String)"halohead").m_171324_((String)"halo").f_104204_ = ageInTicks * 10.0f * ((float)Math.PI / 180);
            this.body.m_171324_((String)"right_arm").m_171324_((String)"magic1").f_104204_ = ageInTicks * 15.0f * ((float)Math.PI / 180);
            this.body.m_171324_((String)"left_arm").m_171324_((String)"magic2").f_104204_ = ageInTicks * -15.0f * ((float)Math.PI / 180);
            if (this.f_102609_) {
                this.right_leg.f_104203_ = -1.4137167f;
                this.right_leg.f_104204_ = 0.31415927f;
                this.right_leg.f_104205_ = 0.07853982f;
                this.left_leg.f_104203_ = -1.4137167f;
                this.left_leg.f_104204_ = -0.31415927f;
                this.left_leg.f_104205_ = -0.07853982f;
            } else {
                if (spiritcaller.isActive()) {
                    this.right_leg.f_104203_ = 0.0f;
                    this.left_leg.f_104203_ = 0.0f;
                } else {
                    this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
                    this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
                }
                this.right_leg.f_104204_ = 0.0f;
                this.right_leg.f_104205_ = 0.0f;
                this.left_leg.f_104204_ = 0.0f;
                this.left_leg.f_104205_ = 0.0f;
            }
            this.body.f_104201_ = -4.0f;
            this.body.f_104200_ = 0.0f;
            this.right_leg.f_104201_ = 8.0f;
            this.left_leg.f_104201_ = 8.0f;
            this.left_leg.f_104202_ = 0.0f;
            wing1.f_104203_ = 0.0f;
            wing2.f_104203_ = 0.0f;
            wing1.f_104205_ = 0.0f;
            wing2.f_104205_ = 0.0f;
            wing_small1.f_104204_ = 0.0f;
            wing_smaller1.f_104204_ = 0.0f;
            wing_smallest1.f_104204_ = 0.0f;
            wing_small2.f_104204_ = 0.0f;
            wing_smaller2.f_104204_ = 0.0f;
            wing_smallest2.f_104204_ = 0.0f;
            float f = ageInTicks - (float)spiritcaller.f_19797_;
            float f1 = spiritcaller.getWingsAnimationScale(f);
            f1 *= f1;
            float f4 = -Mth.m_14031_((float)(f1 / 5.0f / 4.0f)) * 2.0f;
            float f5 = Math.min(f4, 0.0f);
            this.book.f_104207_ = spiritcaller.isRitual();
            if (spiritcaller.isRitual()) {
                this.body.f_104201_ = -4.0f + Mth.m_14089_((float)(f3 * 20.0f)) * 2.0f;
                this.body.f_104200_ = Mth.m_14031_((float)(f3 * 20.0f)) * 0.6f;
                this.body.m_171324_((String)"right_arm").f_104205_ = 0.7854f + Mth.m_14031_((float)(f3 * 14.0f)) * 0.3f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -0.7854f + Mth.m_14031_((float)(f3 * 14.0f)) * -0.3f;
            }
            this.body.m_171324_((String)"right_leg2").f_104207_ = false;
            this.body.m_171324_((String)"left_leg2").f_104207_ = false;
            this.body.m_171324_((String)"right_arm").m_171324_((String)"hand1").f_104207_ = false;
            this.body.m_171324_((String)"left_arm").m_171324_((String)"hand2").f_104207_ = false;
            if (spiritcaller.isActive()) {
                this.body.m_171324_((String)"halohead").f_104207_ = true;
                this.body.m_171324_((String)"right_arm").m_171324_((String)"magic1").f_104207_ = true;
                this.body.m_171324_((String)"left_arm").m_171324_((String)"magic2").f_104207_ = true;
                this.body.m_171324_((String)"wing1").f_104207_ = true;
                this.body.m_171324_((String)"wing2").f_104207_ = true;
                int frame = spiritcaller.getWingsFrames();
                this.body.m_171324_((String)"right_arm").f_104205_ = 0.7854f + Mth.m_14031_((float)(f3 * 7.0f)) * 0.1f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -0.7854f + Mth.m_14031_((float)(f3 * 7.0f)) * -0.1f;
                if (!spiritcaller.m_21224_()) {
                    if (spiritcaller.getWingsFrames() <= 5) {
                        this.body.f_104201_ = -4.0f - f5;
                        this.right_leg.f_104201_ = 8.0f - f5;
                        this.left_leg.f_104201_ = 5.0f - f5;
                        this.left_leg.f_104202_ = -4.0f;
                        wing1.f_104203_ = 0.31415927f * (float)frame;
                        wing2.f_104203_ = -0.31415927f * (float)frame;
                        wing1.f_104205_ = -0.15707964f * (float)frame;
                        wing2.f_104205_ = 0.15707964f * (float)frame;
                        wing_small1.f_104204_ = -0.08726646f * (float)frame;
                        wing_smaller1.f_104204_ = -0.08726646f * (float)frame;
                        wing_smallest1.f_104204_ = -0.08726646f * (float)frame;
                        wing_small2.f_104204_ = 0.08726646f * (float)frame;
                        wing_smaller2.f_104204_ = 0.08726646f * (float)frame;
                        wing_smallest2.f_104204_ = 0.08726646f * (float)frame;
                    } else if (spiritcaller.getWingsFrames() <= 10) {
                        this.body.f_104201_ = -4.0f - f5;
                        this.right_leg.f_104201_ = 8.0f - f5;
                        this.left_leg.f_104201_ = 5.0f - f5;
                        this.left_leg.f_104202_ = -4.0f;
                        wing1.f_104203_ = 1.5707964f;
                        wing2.f_104203_ = -1.5707964f;
                        wing1.f_104205_ = -0.7853982f;
                        wing2.f_104205_ = 0.7853982f;
                        wing_small1.f_104204_ = -0.43633232f;
                        wing_smaller1.f_104204_ = -0.43633232f;
                        wing_smallest1.f_104204_ = -0.43633232f;
                        wing_small2.f_104204_ = 0.43633232f;
                        wing_smaller2.f_104204_ = 0.43633232f;
                        wing_smallest2.f_104204_ = 0.43633232f;
                    } else if (spiritcaller.getWingsFrames() <= 12) {
                        this.body.f_104201_ = -4.0f - f5;
                        this.right_leg.f_104201_ = 8.0f - f5;
                        this.left_leg.f_104201_ = 5.0f - f5;
                        this.left_leg.f_104202_ = -4.0f;
                        wing1.f_104203_ = 1.5707964f;
                        wing2.f_104203_ = -1.5707964f;
                        wing1.f_104205_ = -0.7853982f - -0.61086524f * (float)(frame - 10);
                        wing2.f_104205_ = 0.7853982f - 0.61086524f * (float)(frame - 10);
                        wing_small1.f_104204_ = -0.43633232f;
                        wing_smaller1.f_104204_ = -0.43633232f;
                        wing_smallest1.f_104204_ = -0.43633232f;
                        wing_small2.f_104204_ = 0.43633232f;
                        wing_smaller2.f_104204_ = 0.43633232f;
                        wing_smallest2.f_104204_ = 0.43633232f;
                    } else if (spiritcaller.getWingsFrames() <= 15) {
                        this.body.f_104201_ = -4.0f - f5;
                        this.right_leg.f_104201_ = 8.0f - f5;
                        this.left_leg.f_104201_ = 5.0f - f5;
                        this.left_leg.f_104202_ = -4.0f;
                        wing1.f_104203_ = 1.5707964f;
                        wing2.f_104203_ = -1.5707964f;
                        wing1.f_104205_ = 0.43633232f - -0.05817764f * (float)(frame - 12);
                        wing2.f_104205_ = -0.43633232f - 0.05817764f * (float)(frame - 12);
                        wing_small1.f_104204_ = -0.43633232f - -0.29088822f * (float)(frame - 12);
                        wing_smaller1.f_104204_ = -0.43633232f - -0.29088822f * (float)(frame - 12);
                        wing_smallest1.f_104204_ = -0.43633232f - -0.29088822f * (float)(frame - 12);
                        wing_small2.f_104204_ = 0.43633232f - 0.29088822f * (float)(frame - 12);
                        wing_smaller2.f_104204_ = 0.43633232f - 0.29088822f * (float)(frame - 12);
                        wing_smallest2.f_104204_ = 0.43633232f - 0.29088822f * (float)(frame - 12);
                    } else if (spiritcaller.getWingsFrames() <= 20) {
                        this.body.f_104201_ = -4.0f - f5;
                        this.right_leg.f_104201_ = 8.0f - f5;
                        this.left_leg.f_104201_ = 5.0f - f5;
                        this.left_leg.f_104202_ = -4.0f;
                        wing1.f_104203_ = 1.5707964f;
                        wing2.f_104203_ = -1.5707964f;
                        wing1.f_104205_ = 0.61086524f;
                        wing2.f_104205_ = -0.61086524f;
                        wing_small1.f_104204_ = 0.43633232f;
                        wing_smaller1.f_104204_ = 0.43633232f;
                        wing_smallest1.f_104204_ = 0.43633232f;
                        wing_small2.f_104204_ = -0.43633232f;
                        wing_smaller2.f_104204_ = -0.43633232f;
                        wing_smallest2.f_104204_ = -0.43633232f;
                    } else if (spiritcaller.getWingsFrames() <= 25) {
                        this.body.f_104201_ = -4.0f - f5;
                        this.right_leg.f_104201_ = 8.0f - f5;
                        this.left_leg.f_104201_ = 5.0f - f5;
                        this.left_leg.f_104202_ = -4.0f;
                        wing1.f_104203_ = 1.5707964f - 0.31415927f * (float)(frame - 20);
                        wing2.f_104203_ = -1.5707964f - -0.31415927f * (float)(frame - 20);
                        wing1.f_104205_ = 0.61086524f - 0.12217305f * (float)(frame - 20);
                        wing2.f_104205_ = -0.61086524f - -0.12217305f * (float)(frame - 20);
                        wing_small1.f_104204_ = 0.43633232f - 0.08726646f * (float)(frame - 20);
                        wing_smaller1.f_104204_ = 0.43633232f - 0.08726646f * (float)(frame - 20);
                        wing_smallest1.f_104204_ = 0.43633232f - 0.08726646f * (float)(frame - 20);
                        wing_small2.f_104204_ = -0.43633232f - -0.08726646f * (float)(frame - 20);
                        wing_smaller2.f_104204_ = -0.43633232f - -0.08726646f * (float)(frame - 20);
                        wing_smallest2.f_104204_ = -0.43633232f - -0.08726646f * (float)(frame - 20);
                    }
                } else {
                    wing1.f_104203_ = -0.7854f;
                    wing1.f_104205_ = 0.7854f;
                    wing2.f_104203_ = 0.7854f;
                    wing2.f_104205_ = -0.7854f;
                }
            } else {
                this.body.m_171324_((String)"halohead").f_104207_ = false;
                this.body.m_171324_((String)"right_arm").m_171324_((String)"magic1").f_104207_ = false;
                this.body.m_171324_((String)"left_arm").m_171324_((String)"magic2").f_104207_ = false;
                this.body.m_171324_((String)"wing1").f_104207_ = false;
                this.body.m_171324_((String)"wing2").f_104207_ = false;
            }
            if (spiritcaller.isArmsUpward()) {
                this.body.m_171324_((String)"right_arm").f_104205_ = 1.9198f + Mth.m_14031_((float)(f3 * 14.0f)) * 0.3f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -1.9198f + Mth.m_14031_((float)(f3 * 14.0f)) * -0.3f;
            }
            if (spiritcaller.isSpinning()) {
                this.body.m_171324_((String)"right_arm").f_104205_ = 1.5708f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -1.5708f;
            }
            if (spiritcaller.isCharging()) {
                this.body.m_171324_((String)"head").f_104203_ = -1.5708f;
                this.body.m_171324_((String)"halohead").f_104203_ = -1.5708f;
                this.body.m_171324_((String)"head").f_104204_ = 0.0f;
                this.body.m_171324_((String)"halohead").f_104204_ = 0.0f;
                this.body.f_104203_ = 1.5708f + headPitch * ((float)Math.PI / 180);
                this.right_leg.f_104207_ = false;
                this.left_leg.f_104207_ = false;
                this.body.m_171324_((String)"right_leg2").f_104207_ = true;
                this.body.m_171324_((String)"left_leg2").f_104207_ = true;
                this.body.m_171324_((String)"right_arm").f_104203_ = 3.1416f;
                this.body.m_171324_((String)"left_arm").f_104203_ = 3.1416f;
                this.body.m_171324_((String)"right_arm").f_104204_ = 0.0f;
                this.body.m_171324_((String)"left_arm").f_104204_ = 0.0f;
                this.body.m_171324_((String)"right_arm").f_104205_ = 0.0f;
                this.body.m_171324_((String)"left_arm").f_104205_ = 0.0f;
            } else {
                this.body.f_104203_ = 0.0f;
                this.right_leg.f_104207_ = true;
                this.left_leg.f_104207_ = true;
                this.body.m_171324_((String)"right_arm").f_104203_ = 0.0f;
                this.body.m_171324_((String)"left_arm").f_104203_ = 0.0f;
                this.body.m_171324_((String)"right_arm").f_104204_ = -0.4363f;
                this.body.m_171324_((String)"left_arm").f_104204_ = 0.4363f;
            }
            if (spiritcaller.isFaking() || spiritcaller.isClap() || spiritcaller.shouldShowSpiritHands() || spiritcaller.isShootingLaser()) {
                this.body.m_171324_((String)"right_arm").m_171324_((String)"magic1").f_104207_ = false;
                this.body.m_171324_((String)"left_arm").m_171324_((String)"magic2").f_104207_ = false;
            }
            if (!spiritcaller.isActive() && !spiritcaller.isRitual()) {
                this.body.m_171324_((String)"right_arm").f_104207_ = false;
                this.body.m_171324_((String)"left_arm").f_104207_ = false;
                this.body.m_171324_((String)"arms").f_104207_ = true;
            } else {
                this.body.m_171324_((String)"right_arm").f_104207_ = true;
                this.body.m_171324_((String)"left_arm").f_104207_ = true;
                this.body.m_171324_((String)"arms").f_104207_ = false;
            }
            if (spiritcaller.isClap()) {
                this.body.m_171324_((String)"right_arm").f_104203_ = -1.5707f;
                this.body.m_171324_((String)"left_arm").f_104203_ = -1.5707f;
            }
            if (spiritcaller.m_21224_() && spiritcaller.isActive()) {
                this.body.m_171324_((String)"right_arm").f_104205_ = 1.2217f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -1.2217f;
                this.right_leg.f_104203_ = -0.3491f;
                this.left_leg.f_104203_ = -0.3491f;
            }
            if (spiritcaller.isChargingLaser()) {
                this.body.m_171324_((String)"right_arm").f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.body.m_171324_((String)"right_arm").f_104204_ = 0.0f;
                this.body.m_171324_((String)"right_arm").f_104205_ = 2.3561945f;
            }
            if (spiritcaller.isShootingLaser()) {
                this.body.m_171324_((String)"right_arm").f_104203_ = -1.5707f;
                this.body.m_171324_((String)"left_arm").f_104203_ = -1.5707f;
            }
            this.body.m_171324_((String)"right_arm").m_171324_((String)"hand1").f_104207_ = spiritcaller.shouldShowSpiritHands();
            this.body.m_171324_((String)"left_arm").m_171324_((String)"hand2").f_104207_ = spiritcaller.shouldShowSpiritHands();
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.book.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.body.m_171324_("head");
    }
}

