/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.network;

import com.google.common.collect.Iterables;
import net.combatroll.CombatRoll;
import net.combatroll.api.event.Event;
import net.combatroll.api.event.ServerSideRollEvents;
import net.combatroll.network.Packets;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class ServerNetwork {
    private static PacketBuffer configSerialized = PacketByteBufs.create();

    public static void initializeHandlers() {
        configSerialized = Packets.ConfigSync.write(CombatRoll.config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> sender.sendPacket(Packets.ConfigSync.ID, configSerialized));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.RollPublish.ID, (server, player, handler, buf, responseSender) -> {
            ServerWorld world = (ServerWorld)Iterables.tryFind((Iterable)server.func_212370_w(), element -> element == player.field_70170_p).orNull();
            if (world == null || world.field_72995_K) {
                return;
            }
            Packets.RollPublish packet = Packets.RollPublish.read(buf);
            Vector3d velocity = packet.velocity();
            PacketBuffer forwardBuffer = new Packets.RollAnimation(player.func_145782_y(), packet.visuals(), packet.velocity()).write();
            PlayerLookup.tracking((Entity)player).forEach(serverPlayer -> {
                try {
                    if (serverPlayer.func_145782_y() != player.func_145782_y() && ServerPlayNetworking.canSend((ServerPlayerEntity)serverPlayer, (ResourceLocation)Packets.RollAnimation.ID)) {
                        ServerPlayNetworking.send((ServerPlayerEntity)serverPlayer, (ResourceLocation)Packets.RollAnimation.ID, (PacketBuffer)forwardBuffer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            world.func_73046_m().execute(() -> {
                player.func_71020_j(CombatRoll.config.exhaust_on_roll);
                Event.Proxy proxy = (Event.Proxy)ServerSideRollEvents.PLAYER_START_ROLLING;
                proxy.handlers.forEach(hander -> hander.onPlayerStartedRolling(player, velocity));
            });
        });
    }
}

