/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.network;

import com.google.gson.Gson;
import java.util.Objects;
import net.combatroll.client.RollEffect;
import net.combatroll.config.ServerConfig;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public class Packets {

    public static class ConfigSync {
        public static ResourceLocation ID = new ResourceLocation("combatroll", "config_sync");

        public static PacketBuffer write(ServerConfig config) {
            Gson gson = new Gson();
            String json = gson.toJson((Object)config);
            PacketBuffer buffer = PacketByteBufs.create();
            buffer.func_180714_a(json);
            return buffer;
        }

        public static ServerConfig read(PacketBuffer buffer) {
            Gson gson = new Gson();
            String json = buffer.func_218666_n();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public static final class RollAnimation {
        public static ResourceLocation ID = new ResourceLocation("combatroll", "animation");
        private final int playerId;
        private final RollEffect.Visuals visuals;
        private final Vector3d velocity;

        public RollAnimation(int playerId, RollEffect.Visuals visuals, Vector3d velocity) {
            this.playerId = playerId;
            this.visuals = visuals;
            this.velocity = velocity;
        }

        public PacketBuffer write() {
            PacketBuffer buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.func_180714_a(this.visuals.animationName());
            buffer.func_180714_a(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.field_72450_a);
            buffer.writeDouble(this.velocity.field_72448_b);
            buffer.writeDouble(this.velocity.field_72449_c);
            return buffer;
        }

        public static RollAnimation read(PacketBuffer buffer) {
            int playerId = buffer.readInt();
            RollEffect.Visuals visuals = new RollEffect.Visuals(buffer.func_218666_n(), RollEffect.Particles.valueOf(buffer.func_218666_n()));
            Vector3d velocity = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new RollAnimation(playerId, visuals, velocity);
        }

        public int playerId() {
            return this.playerId;
        }

        public RollEffect.Visuals visuals() {
            return this.visuals;
        }

        public Vector3d velocity() {
            return this.velocity;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RollAnimation that = (RollAnimation)obj;
            return this.playerId == that.playerId && Objects.equals(this.visuals, that.visuals) && Objects.equals(this.velocity, that.velocity);
        }

        public int hashCode() {
            return Objects.hash(this.playerId, this.visuals, this.velocity);
        }

        public String toString() {
            return "RollAnimation[playerId=" + this.playerId + ", visuals=" + this.visuals + ", velocity=" + this.velocity + ']';
        }
    }

    public static final class RollPublish {
        public static ResourceLocation ID = new ResourceLocation("combatroll", "publish");
        private final int playerId;
        private final RollEffect.Visuals visuals;
        private final Vector3d velocity;

        public RollPublish(int playerId, RollEffect.Visuals visuals, Vector3d velocity) {
            this.playerId = playerId;
            this.visuals = visuals;
            this.velocity = velocity;
        }

        public PacketBuffer write() {
            PacketBuffer buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.func_180714_a(this.visuals.animationName());
            buffer.func_180714_a(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.field_72450_a);
            buffer.writeDouble(this.velocity.field_72448_b);
            buffer.writeDouble(this.velocity.field_72449_c);
            return buffer;
        }

        public static RollPublish read(PacketBuffer buffer) {
            int playerId = buffer.readInt();
            RollEffect.Visuals visuals = new RollEffect.Visuals(buffer.func_218666_n(), RollEffect.Particles.valueOf(buffer.func_218666_n()));
            Vector3d velocity = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new RollPublish(playerId, visuals, velocity);
        }

        public int playerId() {
            return this.playerId;
        }

        public RollEffect.Visuals visuals() {
            return this.visuals;
        }

        public Vector3d velocity() {
            return this.velocity;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RollPublish that = (RollPublish)obj;
            return this.playerId == that.playerId && Objects.equals(this.visuals, that.visuals) && Objects.equals(this.velocity, that.velocity);
        }

        public int hashCode() {
            return Objects.hash(this.playerId, this.visuals, this.velocity);
        }

        public String toString() {
            return "RollPublish[playerId=" + this.playerId + ", visuals=" + this.visuals + ", velocity=" + this.velocity + ']';
        }
    }
}

