/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import net.combatroll.CombatRoll;
import net.combatroll.Platform;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.client.MinecraftClientExtension;
import net.combatroll.client.RollEffect;
import net.combatroll.client.RollKeybings;
import net.combatroll.client.RollManager;
import net.combatroll.compatibility.BetterCombatHelper;
import net.combatroll.network.Packets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=449)
public abstract class MinecraftClientMixin
implements MinecraftClientExtension {
    @Shadow
    private int field_71467_ac;
    @Shadow
    @Nullable
    public ClientPlayerEntity field_71439_g;
    private RollManager rollManager = new RollManager();

    @Override
    public RollManager getRollManager() {
        return this.rollManager;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(Screen screen, CallbackInfo ci) {
        this.rollManager.isEnabled = false;
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD(CallbackInfo info) {
        if (this.rollManager.isRolling()) {
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBlockBreaking_HEAD(boolean bl, CallbackInfo ci) {
        if (this.rollManager.isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD(CallbackInfo ci) {
        if (this.rollManager.isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL(CallbackInfo ci) {
        this.tryRolling();
    }

    private void tryRolling() {
        Minecraft client = (Minecraft)this;
        if (this.field_71439_g == null || client.func_147113_T()) {
            return;
        }
        this.rollManager.tick(this.field_71439_g);
        if (RollKeybings.roll.func_151470_d()) {
            float defaultSlipperiness;
            if (Platform.Forge && client.field_71462_r != null) {
                return;
            }
            if (!this.rollManager.isRollAvailable()) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_airborn && !this.field_71439_g.func_233570_aj_()) {
                return;
            }
            if (this.field_71439_g.func_203007_ba()) {
                return;
            }
            if (this.field_71439_g.func_184187_bx() != null) {
                return;
            }
            if (this.field_71439_g.func_184587_cr() || this.field_71439_g.func_184585_cz()) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_weapon_cooldown && (double)this.field_71439_g.func_184825_o(0.0f) < 0.95) {
                return;
            }
            if (BetterCombatHelper.isDoingUpswing()) {
                BetterCombatHelper.cancelUpswing();
            } else if (client.field_71474_y.field_74312_F.func_151470_d()) {
                return;
            }
            if (this.field_71467_ac > 0) {
                return;
            }
            float forward = this.field_71439_g.field_71158_b.field_192832_b;
            float sideways = this.field_71439_g.field_71158_b.field_78902_a;
            Vector3d direction = forward == 0.0f && sideways == 0.0f ? new Vector3d(0.0, 0.0, 1.0) : new Vector3d((double)sideways, 0.0, (double)forward).func_72432_b();
            direction = direction.func_178785_b((float)Math.toRadians(-1.0 * (double)this.field_71439_g.func_195046_g(1.0f)));
            double distance = 0.475 * (EntityAttributes_CombatRoll.getAttributeValue((PlayerEntity)this.field_71439_g, EntityAttributes_CombatRoll.Type.DISTANCE) + (double)CombatRoll.config.additional_roll_distance);
            direction = direction.func_186678_a(distance);
            Block block = this.field_71439_g.field_70170_p.func_180495_p(this.field_71439_g.func_233580_cy_().func_177977_b()).func_177230_c();
            float slipperiness = block.func_208618_m();
            if (slipperiness > (defaultSlipperiness = Blocks.field_150349_c.func_208618_m())) {
                float multiplier = defaultSlipperiness / slipperiness;
                direction = direction.func_186678_a((double)(multiplier * multiplier));
            }
            this.field_71439_g.func_70024_g(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
            this.rollManager.onRoll(this.field_71439_g);
            RollEffect.Visuals rollVisuals = new RollEffect.Visuals("combatroll:roll", RollEffect.Particles.PUFF);
            ClientPlayNetworking.send((ResourceLocation)Packets.RollPublish.ID, (PacketBuffer)new Packets.RollPublish(this.field_71439_g.func_145782_y(), rollVisuals, direction).write());
            RollEffect.playVisuals(rollVisuals, (PlayerEntity)this.field_71439_g, direction);
        }
    }
}

