/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import java.util.Optional;
import net.combatroll.client.animation.AdjustmentModifier;
import net.combatroll.client.animation.AnimatablePlayer;
import net.combatroll.client.animation.AnimationRegistry;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayerEntity.class})
public abstract class AbstractClientPlayerEntityMixin
extends PlayerEntity
implements AnimatablePlayer {
    private final ModifierLayer base = new ModifierLayer(null, new AbstractModifier[0]);
    private final SpeedModifier speedModifier = new SpeedModifier();
    private Vector3d lastRollDirection;

    public AbstractClientPlayerEntityMixin(World world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientWorld world, GameProfile profile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        this.base.addModifier((AbstractModifier)this.createAdjustmentModifier(), 0);
        this.base.addModifier((AbstractModifier)this.speedModifier, 0);
        this.speedModifier.speed = 1.2f;
        stack.addAnimLayer(1000, (IAnimation)this.base);
    }

    @Override
    public void playRollAnimation(String animationName, Vector3d direction) {
        try {
            PlayerEntity player = this;
            KeyframeAnimation animation = AnimationRegistry.animations.get(animationName);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.lastRollDirection = direction;
            int fadeIn = copy.beginTick;
            this.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(copy.build(), 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AdjustmentModifier createAdjustmentModifier() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if ("body".equals(partName)) {
                if (this.lastRollDirection == null) {
                    return Optional.empty();
                }
            } else {
                return Optional.empty();
            }
            Vector3d absoluteOrientation = new Vector3d(0.0, 0.0, 1.0).func_178785_b((float)Math.toRadians(-1.0 * (double)player.field_70761_aq));
            float angle = (float)this.angleWithSignBetween(absoluteOrientation, this.lastRollDirection, new Vector3d(0.0, 1.0, 0.0));
            rotationY = (float)Math.toRadians(angle);
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private double angleWithSignBetween(Vector3d a, Vector3d b, Vector3d planeNormal) {
        double cosineTheta = a.func_72430_b(b) / (a.func_72433_c() * b.func_72433_c());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        Vector3d cross = a.func_72431_c(b);
        if (Double.isNaN(angle *= Math.signum(cross.func_72430_b(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }
}

