/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;

public class AmplifierEnchantment
extends Enchantment {
    public Operation operation;
    public Properties properties;

    public double apply(double value, int level) {
        if (this.operation == Operation.ADD) {
            return value += (double)((float)level * this.properties.bonus_per_level);
        }
        if (this.operation == Operation.MULTIPLY) {
            return value *= (double)(1.0f + (float)level * this.properties.bonus_per_level);
        }
        return 0.0;
    }

    public AmplifierEnchantment(Enchantment.Rarity weight, Operation operation, Properties properties, EnchantmentType type, EquipmentSlotType[] slotTypes) {
        super(weight, type, slotTypes);
        this.operation = operation;
        this.properties = properties;
    }

    public int func_77325_b() {
        return this.properties.max_level;
    }

    public int func_77321_a(int level) {
        return this.properties.min_cost + (level - 1) * this.properties.step_cost;
    }

    public int func_223551_b(int level) {
        return super.func_77321_a(level) + 50;
    }

    public static enum Operation {
        ADD,
        MULTIPLY;

    }

    public static class Properties {
        public int max_level = 0;
        public int min_cost = 0;
        public int step_cost = 0;
        public float bonus_per_level = 0.0f;

        public Properties() {
        }

        public Properties(int max_level, int min_cost, int step_cost, float bonus_per_level) {
            this.max_level = max_level;
            this.min_cost = min_cost;
            this.step_cost = step_cost;
            this.bonus_per_level = bonus_per_level;
        }
    }
}

