/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.combatroll.client.CombatRollClient;
import net.combatroll.client.MinecraftClientExtension;
import net.combatroll.client.RollManager;
import net.combatroll.client.gui.HudElement;
import net.combatroll.config.ClientConfig;
import net.combatroll.config.HudConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;

public class HudRenderHelper {
    private static final ResourceLocation ARROW = new ResourceLocation("combatroll", "textures/hud/arrow.png");
    private static final ResourceLocation ARROW_BACKGROUND = new ResourceLocation("combatroll", "textures/hud/arrow_background.png");

    public static void render(MatrixStack matrixStack, float tickDelta) {
        ViewModel viewModel;
        ClientConfig config = CombatRollClient.config;
        Minecraft client = Minecraft.func_71410_x();
        ClientPlayerEntity player = client.field_71439_g;
        if (player == null) {
            viewModel = ViewModel.mock();
        } else {
            if (player.func_184812_l_() && !config.showHUDInCreative) {
                return;
            }
            if (player.func_175149_v()) {
                return;
            }
            RollManager.CooldownInfo cooldownInfo = ((MinecraftClientExtension)client).getRollManager().getCooldown();
            viewModel = ViewModel.create(cooldownInfo, tickDelta);
        }
        int screenWidth = client.func_228018_at_().func_198107_o();
        int screenHeight = client.func_228018_at_().func_198087_p();
        HudElement rollWidget = ((HudConfig)CombatRollClient.hudConfig.value).rollWidget;
        Vector2f originPoint = rollWidget.origin.getPoint(screenWidth, screenHeight);
        Vector2f drawOffset = rollWidget.offset;
        int horizontalSpacing = 8;
        int biggestTextureSize = 15;
        int widgetWidth = biggestTextureSize + horizontalSpacing * viewModel.elements.size();
        int widgetHeight = biggestTextureSize;
        int drawX = (int)(originPoint.field_189982_i + drawOffset.field_189982_i);
        int drawY = (int)(originPoint.field_189983_j + drawOffset.field_189983_j - (float)(widgetHeight / 2));
        RenderSystem.enableBlend();
        for (ViewModel.Element element : viewModel.elements()) {
            int x = 0;
            int y = 0;
            boolean u = false;
            int v = 0;
            int width = 0;
            int height = 0;
            int textureSize = 0;
            x = drawX;
            y = drawY;
            u = false;
            v = 0;
            textureSize = 15;
            height = 15;
            width = 15;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ARROW_BACKGROUND);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)config.hudBackgroundOpacity / 100.0f));
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)((float)u), (float)v, (int)width, (int)height, (int)textureSize, (int)textureSize);
            int color = element.color;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            int prevTextureSize = textureSize;
            textureSize = 13;
            int shift = (prevTextureSize - textureSize) / 2;
            width = textureSize;
            height = Math.round(element.full * (float)textureSize);
            x = drawX + shift;
            y = drawY + textureSize - height + shift;
            u = false;
            v = textureSize - height;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ARROW);
            RenderSystem.color4f((float)red, (float)green, (float)blue, (float)element.full);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)((float)u), (float)v, (int)width, (int)height, (int)textureSize, (int)textureSize);
            drawX += horizontalSpacing;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static final class ViewModel {
        private final List<Element> elements;

        private ViewModel(List<Element> elements) {
            this.elements = elements;
        }

        static ViewModel create(RollManager.CooldownInfo info, float tickDelta) {
            ClientConfig config = CombatRollClient.config;
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < info.maxRolls(); ++i) {
                int color = config.hudArrowColor;
                float full = 0.0f;
                if (i == info.availableRolls()) {
                    int sparkleTicks;
                    int missingTicks;
                    full = (float)info.elapsed() / (float)info.total();
                    full = Math.min(full, 1.0f);
                    if (config.playCooldownFlash && (missingTicks = info.total() - info.elapsed()) <= (sparkleTicks = 2)) {
                        float sparkle = (float)(sparkleTicks / 2) - ((float)(missingTicks - 1) + (1.0f - tickDelta)) / (float)sparkleTicks;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        int redBits = (int)(ViewModel.mixNumberFloat(red, 1.0f, sparkle) * 255.0f);
                        int greenBits = (int)(ViewModel.mixNumberFloat(green, 1.0f, sparkle) * 255.0f);
                        int blueBits = (int)(ViewModel.mixNumberFloat(blue, 1.0f, sparkle) * 255.0f);
                        color = redBits;
                        color = (color << 8) + greenBits;
                        color = (color << 8) + blueBits;
                    }
                }
                if (i < info.availableRolls()) {
                    full = 1.0f;
                }
                elements.add(new Element(color, full));
            }
            return new ViewModel(elements);
        }

        static ViewModel mock() {
            ClientConfig config = CombatRollClient.config;
            int color = config.hudArrowColor;
            return new ViewModel(Arrays.asList(new Element(color, 1.0f), new Element(color, 0.5f), new Element(color, 0.0f)));
        }

        private static float mixNumberFloat(float a, float b, float bias) {
            return a + (b - a) * bias;
        }

        public List<Element> elements() {
            return this.elements;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ViewModel that = (ViewModel)obj;
            return Objects.equals(this.elements, that.elements);
        }

        public int hashCode() {
            return Objects.hash(this.elements);
        }

        public String toString() {
            return "ViewModel[elements=" + this.elements + ']';
        }

        static final class Element {
            private final int color;
            private final float full;

            Element(int color, float full) {
                this.color = color;
                this.full = full;
            }

            public int color() {
                return this.color;
            }

            public float full() {
                return this.full;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Element that = (Element)obj;
                return this.color == that.color && Float.floatToIntBits(this.full) == Float.floatToIntBits(that.full);
            }

            public int hashCode() {
                return Objects.hash(this.color, Float.valueOf(this.full));
            }

            public String toString() {
                return "Element[color=" + this.color + ", full=" + this.full + ']';
            }
        }
    }
}

