/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.gui;

import net.minecraft.util.math.vector.Vector2f;

public class HudElement {
    public Origin origin;
    public Vector2f offset;

    public HudElement(Origin origin, Vector2f offset) {
        this.origin = origin;
        this.offset = offset;
    }

    public static enum Origin {
        TOP,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public Vector2f getPoint(int screenWidth, int screenHeight) {
            if (this == TOP) {
                return new Vector2f((float)screenWidth / 2.0f, 0.0f);
            }
            if (this == TOP_LEFT) {
                return new Vector2f(0.0f, 0.0f);
            }
            if (this == TOP_RIGHT) {
                return new Vector2f((float)screenWidth, 0.0f);
            }
            if (this == BOTTOM) {
                return new Vector2f((float)screenWidth / 2.0f, (float)screenHeight);
            }
            if (this == BOTTOM_LEFT) {
                return new Vector2f(0.0f, (float)screenHeight);
            }
            if (this == BOTTOM_RIGHT) {
                return new Vector2f((float)screenWidth, (float)screenHeight);
            }
            return new Vector2f((float)screenWidth / 2.0f, (float)screenHeight / 2.0f);
        }

        public Vector2f initialOffset() {
            int offset = 12;
            if (this == TOP) {
                return new Vector2f(0.0f, (float)offset);
            }
            if (this == TOP_LEFT) {
                return new Vector2f((float)offset, (float)offset);
            }
            if (this == TOP_RIGHT) {
                return new Vector2f((float)(-1 * offset), (float)offset);
            }
            if (this == BOTTOM) {
                return new Vector2f(0.0f, (float)(-1 * offset));
            }
            if (this == BOTTOM_LEFT) {
                return new Vector2f((float)offset, (float)(-1 * offset));
            }
            if (this == BOTTOM_RIGHT) {
                return new Vector2f((float)(-1 * offset), (float)(-1 * offset));
            }
            return new Vector2f(0.0f, 0.0f);
        }
    }
}

