/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.animation;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class AdjustmentModifier
extends AbstractModifier {
    public boolean enabled = true;
    private Function<String, Optional<PartModifier>> source;

    public AdjustmentModifier(Function<String, Optional<PartModifier>> source) {
        this.source = source;
    }

    private float getFadeIn(float delta) {
        float fadeIn = 1.0f;
        if (this.getAnim() instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer player = (KeyframeAnimationPlayer)this.getAnim();
            float currentTick = (float)player.getTick() + delta;
            fadeIn = currentTick / (float)player.getData().beginTick;
            fadeIn = Math.min(fadeIn, 1.0f);
        }
        return fadeIn;
    }

    private float getFadeOut(float delta) {
        float fadeOut = 1.0f;
        if (this.getAnim() instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer player = (KeyframeAnimationPlayer)this.getAnim();
            float currentTick = (float)player.getTick() + delta;
            float position = -1.0f * (currentTick - (float)player.getData().stopTick);
            float length = player.getData().stopTick - player.getData().endTick;
            if (length > 0.0f) {
                fadeOut = position / length;
                fadeOut = Math.min(fadeOut, 1.0f);
            }
        }
        return fadeOut;
    }

    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        if (!this.enabled) {
            return super.get3DTransform(modelName, type, tickDelta, value0);
        }
        Optional<PartModifier> partModifier = this.source.apply(modelName);
        Vec3f modifiedVector = value0;
        float fade = this.getFadeIn(tickDelta) * this.getFadeOut(tickDelta);
        if (partModifier.isPresent()) {
            modifiedVector = super.get3DTransform(modelName, type, tickDelta, modifiedVector);
            return this.transformVector(modifiedVector, type, partModifier.get(), fade);
        }
        return super.get3DTransform(modelName, type, tickDelta, value0);
    }

    private Vec3f transformVector(Vec3f vector, TransformType type, PartModifier partModifier, float fade) {
        if (type == TransformType.POSITION) {
            return vector.add(partModifier.offset);
        }
        if (type == TransformType.ROTATION) {
            return vector.add(partModifier.rotation.scale(fade));
        }
        if (type == TransformType.BEND) {
            // empty if block
        }
        return vector;
    }

    public static final class PartModifier {
        private final Vec3f rotation;
        private final Vec3f offset;

        public PartModifier(Vec3f rotation, Vec3f offset) {
            this.rotation = rotation;
            this.offset = offset;
        }

        public Vec3f rotation() {
            return this.rotation;
        }

        public Vec3f offset() {
            return this.offset;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PartModifier that = (PartModifier)obj;
            return Objects.equals(this.rotation, that.rotation) && Objects.equals(this.offset, that.offset);
        }

        public int hashCode() {
            return Objects.hash(this.rotation, this.offset);
        }

        public String toString() {
            return "PartModifier[rotation=" + this.rotation + ", offset=" + this.offset + ']';
        }
    }
}

