/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client;

import java.util.Objects;
import net.combatroll.CombatRoll;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.client.CombatRollClient;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;

public class RollManager {
    public boolean isEnabled = false;
    private int timeSinceLastRoll = 10;
    private int currentCooldownProgress = 0;
    private int currentCooldownLength = 0;
    private int maxRolls = 1;
    private int availableRolls = 0;

    public static int rollDuration() {
        return CombatRoll.config.roll_duration;
    }

    public CooldownInfo getCooldown() {
        return new CooldownInfo(this.currentCooldownProgress, this.currentCooldownLength, this.availableRolls, this.maxRolls);
    }

    public boolean isRollAvailable() {
        return this.isEnabled && !this.isRolling() && this.availableRolls > 0;
    }

    public boolean isRolling() {
        return this.timeSinceLastRoll <= RollManager.rollDuration();
    }

    public void onRoll(ClientPlayerEntity player) {
        --this.availableRolls;
        this.timeSinceLastRoll = 0;
        this.updateCooldownLength(player);
    }

    public void tick(ClientPlayerEntity player) {
        this.maxRolls = (int)EntityAttributes_CombatRoll.getAttributeValue((PlayerEntity)player, EntityAttributes_CombatRoll.Type.COUNT);
        ++this.timeSinceLastRoll;
        if (this.availableRolls < this.maxRolls) {
            ++this.currentCooldownProgress;
            if (this.currentCooldownProgress >= this.currentCooldownLength) {
                this.rechargeRoll(player);
            }
        }
        if (this.availableRolls == this.maxRolls) {
            this.currentCooldownProgress = 0;
        }
        if (this.availableRolls > this.maxRolls) {
            this.availableRolls = this.maxRolls;
        }
    }

    private void rechargeRoll(ClientPlayerEntity player) {
        SoundEvent cooldownReady;
        ++this.availableRolls;
        this.currentCooldownProgress = 0;
        this.updateCooldownLength(player);
        if (CombatRollClient.config.playCooldownSound && (cooldownReady = (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation("combatroll:roll_cooldown_ready"))) != null) {
            player.field_70170_p.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), cooldownReady, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    private void updateCooldownLength(ClientPlayerEntity player) {
        float duration = CombatRoll.config.roll_cooldown;
        this.currentCooldownLength = (int)Math.round((double)(duration * 20.0f) * (20.0 / EntityAttributes_CombatRoll.getAttributeValue((PlayerEntity)player, EntityAttributes_CombatRoll.Type.RECHARGE)));
    }

    public static final class CooldownInfo {
        private final int elapsed;
        private final int total;
        private final int availableRolls;
        private final int maxRolls;

        public CooldownInfo(int elapsed, int total, int availableRolls, int maxRolls) {
            this.elapsed = elapsed;
            this.total = total;
            this.availableRolls = availableRolls;
            this.maxRolls = maxRolls;
        }

        public int elapsed() {
            return this.elapsed;
        }

        public int total() {
            return this.total;
        }

        public int availableRolls() {
            return this.availableRolls;
        }

        public int maxRolls() {
            return this.maxRolls;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CooldownInfo that = (CooldownInfo)obj;
            return this.elapsed == that.elapsed && this.total == that.total && this.availableRolls == that.availableRolls && this.maxRolls == that.maxRolls;
        }

        public int hashCode() {
            return Objects.hash(this.elapsed, this.total, this.availableRolls, this.maxRolls);
        }

        public String toString() {
            return "CooldownInfo[elapsed=" + this.elapsed + ", total=" + this.total + ", availableRolls=" + this.availableRolls + ", maxRolls=" + this.maxRolls + ']';
        }
    }
}

