/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client;

import java.util.Objects;
import java.util.Random;
import net.combatroll.client.CombatRollClient;
import net.combatroll.client.animation.AnimatablePlayer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;

public final class RollEffect {
    private static Random random = new Random();
    private final Visuals visuals;
    private final String soundId;

    public RollEffect(Visuals visuals, String soundId) {
        this.visuals = visuals;
        this.soundId = soundId;
    }

    public static void playVisuals(Visuals visuals, PlayerEntity player, Vector3d direction) {
        SoundEvent sound;
        ((AnimatablePlayer)player).playRollAnimation(visuals.animationName(), direction);
        if (CombatRollClient.config.playRollSound && (sound = (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation("combatroll:roll"))) != null) {
            player.field_70170_p.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f, true);
        }
        if (visuals.particles() == Particles.PUFF) {
            for (int i = 0; i < 15; ++i) {
                double d = random.nextGaussian() * 0.02;
                double e = random.nextGaussian() * 0.02;
                double f = random.nextGaussian() * 0.02;
                player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, player.func_226282_d_(1.5), player.func_226283_e_(random.nextGaussian() * 0.3), player.func_226287_g_(1.5), d, e, f);
            }
        }
    }

    public Visuals visuals() {
        return this.visuals;
    }

    public String soundId() {
        return this.soundId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RollEffect that = (RollEffect)obj;
        return Objects.equals(this.visuals, that.visuals) && Objects.equals(this.soundId, that.soundId);
    }

    public int hashCode() {
        return Objects.hash(this.visuals, this.soundId);
    }

    public String toString() {
        return "RollEffect[visuals=" + this.visuals + ", soundId=" + this.soundId + ']';
    }

    public static final class Visuals {
        private final String animationName;
        private final Particles particles;

        public Visuals(String animationName, Particles particles) {
            this.animationName = animationName;
            this.particles = particles;
        }

        public String animationName() {
            return this.animationName;
        }

        public Particles particles() {
            return this.particles;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Visuals that = (Visuals)obj;
            return Objects.equals(this.animationName, that.animationName) && Objects.equals((Object)this.particles, (Object)that.particles);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.animationName, this.particles});
        }

        public String toString() {
            return "Visuals[animationName=" + this.animationName + ", particles=" + (Object)((Object)this.particles) + ']';
        }
    }

    public static enum Particles {
        PUFF;

    }
}

