/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.api;

import java.util.Arrays;
import java.util.List;
import net.combatroll.api.Enchantments_CombatRoll;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class EntityAttributes_CombatRoll {
    public static final String distanceName = "distance";
    public static final ResourceLocation distanceId = new ResourceLocation("combatroll:distance");
    public static final Attribute DISTANCE = new RangedAttribute("attribute.name.combat_roll.distance", 3.0, 1.0, 24.0).func_233753_a_(true);
    public static final String rechargeName = "recharge";
    public static final ResourceLocation rechargeId = new ResourceLocation("combatroll:recharge");
    public static final Attribute RECHARGE = new RangedAttribute("attribute.name.combat_roll.recharge", 20.0, 0.1, 200.0).func_233753_a_(true);
    public static final String countName = "count";
    public static final ResourceLocation countId = new ResourceLocation("combatroll:count");
    public static final Attribute COUNT = new RangedAttribute("attribute.name.combat_roll.count", 1.0, 1.0, 20.0).func_233753_a_(true);
    public static List<Attribute> all = Arrays.asList(DISTANCE, RECHARGE, COUNT);

    public static double getAttributeValue(PlayerEntity player, Type type) {
        if (type == Type.DISTANCE) {
            double value = player.func_233637_b_(DISTANCE);
            int level = EnchantmentHelper.func_185284_a((Enchantment)Enchantments_CombatRoll.DISTANCE, (LivingEntity)player);
            value = Enchantments_CombatRoll.DISTANCE.apply(value, level);
            return value;
        }
        if (type == Type.RECHARGE) {
            double value = player.func_233637_b_(RECHARGE);
            int chestLevel = EnchantmentHelper.func_185284_a((Enchantment)Enchantments_CombatRoll.RECHARGE_CHEST, (LivingEntity)player);
            value = Enchantments_CombatRoll.RECHARGE_CHEST.apply(value, chestLevel);
            int legsLevel = EnchantmentHelper.func_185284_a((Enchantment)Enchantments_CombatRoll.RECHARGE_LEGS, (LivingEntity)player);
            value = Enchantments_CombatRoll.RECHARGE_LEGS.apply(value, legsLevel);
            return value;
        }
        if (type == Type.COUNT) {
            double value = player.func_233637_b_(COUNT);
            int level = EnchantmentHelper.func_185284_a((Enchantment)Enchantments_CombatRoll.COUNT, (LivingEntity)player);
            value = Enchantments_CombatRoll.COUNT.apply(value, level);
            return value;
        }
        return 1.0;
    }

    public static enum Type {
        DISTANCE,
        RECHARGE,
        COUNT;

    }
}

