import crafttweaker.api.item.IItemStack;
import crafttweaker.api.data.MapData;

craftingTable.removeByName("apotheosis:potion_charm");

var potionEffectList = [
	"minecraft:night_vision",
	"minecraft:long_night_vision",
	"minecraft:invisibility",
	"minecraft:long_invisibility",
	"minecraft:leaping",
	"minecraft:long_leaping",
	"minecraft:strong_leaping",
	"minecraft:fire_resistance",
	"minecraft:long_fire_resistance",
	"minecraft:swiftness",
	"minecraft:long_swiftness",
	"minecraft:strong_swiftness",
	"minecraft:slowness",
	"minecraft:long_slowness",
	"minecraft:strong_slowness",
	"minecraft:water_breathing",
	"minecraft:long_water_breathing",
	"minecraft:poison",
	"minecraft:long_poison",
	"minecraft:strong_poison",
	"minecraft:regeneration",
	"minecraft:long_regeneration",
	"minecraft:strong_regeneration",
	"minecraft:strength",
	"minecraft:long_strength",
	"minecraft:strong_strength",
	"minecraft:weakness",
	"minecraft:long_weakness",
	"minecraft:luck",
	"minecraft:slow_falling",
	"minecraft:long_slow_falling",
	"infernalexp:infection",
	"infernalexp:long_infection",
	"infernalexp:strong_infection",
	"infernalexp:luminous",
	"infernalexp:long_luminous",
	"infernalexp:strong_luminous",
	"stalwart_dungeons:spore",
	"stalwart_dungeons:burning",
	"apotheosis:resistance",
	"apotheosis:long_resistance",
	"apotheosis:strong_resistance",
	"apotheosis:haste",
	"apotheosis:long_haste",
	"apotheosis:strong_haste",
	"apotheosis:fatigue",
	"apotheosis:long_fatigue",
	"apotheosis:strong_fatigue",
	"apotheosis:wither",
	"apotheosis:long_wither",
	"apotheosis:strong_wither",
	"apotheosis:sundering",
	"apotheosis:long_sundering",
	"apotheosis:strong_sundering",
	"apotheosis:knowledge",
	"apotheosis:long_knowledge",
	"apotheosis:strong_knowledge",
	"betterendforge:end_veil",
	"betterendforge:end_veil_long",
	"carrots:placeholder",
	"tombstone:earthly_garden",
	"tombstone:bait",
	"tombstone:discretion",
	"tombstone:restoration",
	"dungeons_gear:short_strength",
	"dungeons_gear:short_speed",
	"dungeons_gear:shadow_brew",
	"dungeons_gear:oakwood_brew",
	"mowziesmobs:poison_resist",
	"mowziesmobs:long_poison_resist",
	"goblintraders:extended_night_vision",
	"goblintraders:extended_invisibility",
	"goblintraders:powerful_jump_boost",
	"goblintraders:extended_fire_resistance",
	"goblintraders:powerful_speed",
	"goblintraders:extended_water_breathing",
	"goblintraders:powerful_regeneration",
	"goblintraders:extended_slow_falling",
	"goblintraders:powerful_strength",
	"goblintraders:haste",
	"goblintraders:absorption",
	"goblintraders:levitation",
	"goblintraders:luck",
	"goblintraders:dolphins_grace",
	"mysticalworld:serendipity",
	"greekfantasy:mirror",
	"greekfantasy:long_mirror",
	"greekfantasy:pig",
	"greekfantasy:long_pig",
	"eidolon:chilled",
	"eidolon:long_chilled",
	"eidolon:anchored",
	"eidolon:long_anchored",
	"alexsmobs:knockback_resistance",
	"alexsmobs:long_knockback_resistance",
	"alexsmobs:strong_knockback_resistance",
	"alexsmobs:lava_vision",
	"alexsmobs:long_lava_vision",
	"alexsmobs:speed_iii",
	"alexsmobs:poison_resistance",
	"alexsmobs:long_poison_resistance",
	"alexsmobs:bug_pheromones",
	"alexsmobs:long_bug_pheromones",
	"alexsmobs:soulsteal",
	"alexsmobs:long_soulsteal",
	"alexsmobs:strong_soulsteal",
	"alexsmobs:clinging",
	"alexsmobs:long_clinging",
	"buddycards:grading_luck",
	"buddycards:grading_luck_strong",
	"buddycards:grading_luck_long",
	"elenaidodge2:feathers",
	"elenaidodge2:long_feathers",
	"elenaidodge2:strong_feathers",
	"elenaidodge2:weight",
	"elenaidodge2:long_weight",
	"elenaidodge2:endurance",
	"elenaidodge2:long_endurance",
	"elenaidodge2:strong_endurance",
	"elenaidodge2:forceful",
	"elenaidodge2:long_forceful",
	"elenaidodge2:strong_forceful",
	"elenaidodge2:feeble",
	"elenaidodge2:long_feeble",
	"elenaidodge2:strong_feeble",
	"elenaidodge2:replenishment",
	"elenaidodge2:long_replenishment",
	"elenaidodge2:strong_replenishment",
	"ars_nouveau:mana_regen_potion",
	"ars_nouveau:mana_regen_potion_long",
	"ars_nouveau:mana_regen_potion_strong",
	"ars_nouveau:spell_damage",
	"ars_nouveau:spell_damage_long",
	"ars_nouveau:spell_damage_strong",
	"undergarden:brittleness",
	"undergarden:long_brittleness",
	"undergarden:strong_brittleness",
	"undergarden:featherweight",
	"undergarden:long_featherweight",
	"undergarden:strong_featherweight",
	"undergarden:virulent_resistance",
	"undergarden:long_virulent_resistance",
	"undergarden:glowing",
	"undergarden:long_glowing",
	"upgrade_aquatic:repellence",
	"upgrade_aquatic:repellence_strong",
	"upgrade_aquatic:repellence_long",
	"upgrade_aquatic:vibing",
	"upgrade_aquatic:vibing_strong",
	"upgrade_aquatic:vibing_long",
	"buzzier_bees:long_luck",
	"buzzier_bees:strong_luck",
	"buzzier_bees:unluck",
	"buzzier_bees:long_unluck",
	"buzzier_bees:strong_unluck",
	"abundance:succumbing",
	"abundance:succumbing_long",
	"abundance:succumbing_strong",
	"abundance:supportive",
	"abundance:supportive_long",
	"abundance:supportive_strong",
	"quark:resistance",
	"quark:long_resistance",
	"quark:strong_resistance",
	"quark:resilience",
	"quark:long_resilience",
	"quark:strong_resilience",
	"quark:danger_sight",
	"quark:long_danger_sight"
] as string[];

for i, effect in potionEffectList {
	var recipeName = "custom_potion_charm_recipie_" + i as string;
	craftingTable.addShaped(recipeName, <item:apotheosis:potion_charm>.withTag({Potion: effect}), [ 
		[<item:minecraft:blaze_powder>, <item:minecraft:blaze_powder>, <item:minecraft:blaze_powder>],
		[<item:minecraft:potion>.withTag({Potion: effect}), <item:minecraft:potion>.withTag({Potion: effect}), <item:minecraft:potion>.withTag({Potion: effect})],
		[<item:minecraft:blaze_powder>, <item:minecraft:blaze_powder>, <item:minecraft:blaze_powder>]
	]);
}
