/*
 * Decompiled with CFR 0.152.
 */
package io.github.barteks2x.chunkgenlimiter.coremod;

import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ChunkGenLimitTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"ChunkGenLimitTransformer");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!"net.minecraft.server.management.PlayerChunkMap".equals(transformedName)) {
            return basicClass;
        }
        LOGGER.info("Transforming net.minecraft.server.management.PlayerChunkMap");
        ClassReader reader = new ClassReader(basicClass);
        ClassWriter writer = new ClassWriter(327680);
        final String targetMethod = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/server/management/PlayerChunkMap", "func_72693_b", "()V");
        LOGGER.info(" > Finding method " + targetMethod);
        ClassVisitor visitor = new ClassVisitor(327680, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals(targetMethod)) {
                    LOGGER.info(" > Transforming PlayerChunkMap.tick()");
                    return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                        public void visitIntInsn(int opcode, int operand) {
                            if (opcode == 16 && operand == 49) {
                                LOGGER.info(" >>> Replacing constant 49 with getChunkLimit");
                                super.visitMethodInsn(184, "io/github/barteks2x/chunkgenlimiter/coremod/Hooks", "getChunkLimit", "()I", false);
                            } else {
                                super.visitIntInsn(opcode, operand);
                            }
                        }

                        public void visitLdcInsn(Object cst) {
                            if (cst instanceof Long && (Long)cst == 50000000L) {
                                LOGGER.info(" >>> Replacing constant 50000000L with getTimeLimit");
                                super.visitMethodInsn(184, "io/github/barteks2x/chunkgenlimiter/coremod/Hooks", "getTimeLimit", "()J", false);
                            } else {
                                super.visitLdcInsn(cst);
                            }
                        }
                    };
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        reader.accept(visitor, 0);
        return writer.toByteArray();
    }
}

