/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.GalacticraftJEI;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class IngotCompressorRecipeCategory
implements IRecipeCategory {
    private static final ResourceLocation compressorTex = new ResourceLocation("galacticraftcore", "textures/gui/ingot_compressor.png");
    private static final ResourceLocation compressorTexBlank = new ResourceLocation("galacticraftcore", "textures/gui/ingot_compressor_blank.png");
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawable backgroundBlank;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final IDrawableAnimated progressBar;
    private boolean drawNothing = false;

    public IngotCompressorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(compressorTex, 18, 17, 137, 78);
        this.backgroundBlank = guiHelper.createDrawable(compressorTexBlank, 18, 17, 137, 78);
        this.localizedName = GCCoreUtil.translate("tile.machine.3.name");
        IDrawableStatic progressBarDrawable = guiHelper.createDrawable(compressorTex, 176, 13, 52, 17);
        this.progressBar = guiHelper.createAnimatedDrawable(progressBarDrawable, 70, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return "galacticraft.ingotcompressor";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        if (this.drawNothing) {
            return this.backgroundBlank;
        }
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (!this.drawNothing) {
            this.progressBar.draw(minecraft, 59, 19);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List output;
        ItemStack stackOutput;
        this.drawNothing = GalacticraftJEI.hidden.contains(recipeWrapper);
        if (this.drawNothing) {
            return;
        }
        IGuiItemStackGroup itemstacks = recipeLayout.getItemStacks();
        for (int j = 0; j < 9; ++j) {
            itemstacks.init(j, true, j % 3 * 18, j / 3 * 18);
        }
        itemstacks.init(9, false, 119, 20);
        if (ConfigManagerCore.quickMode && (stackOutput = (ItemStack)(output = (List)ingredients.getOutputs(ItemStack.class).get(0)).get(0)).func_77973_b().func_77667_c(stackOutput).contains("compressed")) {
            ItemStack stackDoubled = stackOutput.func_77946_l();
            stackDoubled.func_190920_e(stackOutput.func_190916_E() * 2);
            output.set(0, stackDoubled);
        }
        itemstacks.set(ingredients);
    }

    public String getModName() {
        return "Galacticraft Core";
    }
}

