/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidTank
extends Block
implements IShiftDescription,
ISortableBlock,
ITileEntityProvider {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB((double)0.05f, 0.0, (double)0.05f, (double)0.95f, 1.0, (double)0.95f);

    public BlockFluidTank(String assetName) {
        super(Material.field_151592_s);
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149663_c(assetName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            tank.onBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(stateAbove.func_177230_c() == this)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(stateBelow.func_177230_c() == this));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFluidTank();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        ItemStack current = playerIn.field_71071_by.func_70448_g();
        int slot = playerIn.field_71071_by.field_70461_c;
        if (!current.func_190926_b() && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            FluidActionResult forgeResult = FluidUtil.interactWithFluidHandler(current, (IFluidHandler)tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null), playerIn);
            if (forgeResult.isSuccess()) {
                playerIn.field_71071_by.func_70299_a(slot, forgeResult.result);
                if (playerIn.field_71069_bz != null) {
                    playerIn.field_71069_bz.func_75142_b();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFluidTank) {
            TileEntityFluidTank tank = (TileEntityFluidTank)tile;
            return tank.fluidTank.getFluid() == null || tank.fluidTank.getFluid().amount == 0 ? 0 : tank.fluidTank.getFluid().getFluid().getLuminosity(tank.fluidTank.getFluid());
        }
        return 0;
    }
}

