/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.advancement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.util.Iterator;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.advancement.criterion.GenericTrigger;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class GCTriggers {
    public static final GenericTrigger LAUNCH_ROCKET = new GenericTrigger("launch_rocket"){

        public ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new GenericTrigger.Instance(this.func_192163_a()){

                @Override
                public boolean test(EntityPlayerMP player) {
                    if (player.func_184187_bx() instanceof EntitySpaceshipBase && ((EntitySpaceshipBase)player.func_184187_bx()).launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                        return player.func_184187_bx().func_184188_bt().size() >= 1 && player.func_184187_bx().func_184188_bt().get(0) instanceof EntityPlayerMP;
                    }
                    return false;
                }
            };
        }
    };
    public static final GenericTrigger FIND_MOON_BOSS = new GenericTrigger("boss_moon"){

        public ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new GenericTrigger.Instance(this.func_192163_a()){

                @Override
                public boolean test(EntityPlayerMP player) {
                    Iterator iterator = player.field_70170_p.field_72996_f.iterator();
                    if (iterator.hasNext()) {
                        Entity entity = (Entity)iterator.next();
                        return entity instanceof EntitySkeletonBoss && entity.func_70068_e((Entity)player) < 400.0;
                    }
                    return false;
                }
            };
        }
    };
    public static final GenericTrigger CREATE_SPACE_STATION = new GenericTrigger("create_space_station"){

        public ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new GenericTrigger.Instance(this.func_192163_a()){

                @Override
                public boolean test(EntityPlayerMP player) {
                    return !GCPlayerStats.get((Entity)player).getSpaceStationDimensionData().isEmpty();
                }
            };
        }
    };

    public static void registerTriggers() {
        Method register = null;
        try {
            Method[] mm;
            Class<CriteriaTriggers> clazz = CriteriaTriggers.class;
            for (Method m : mm = clazz.getDeclaredMethods()) {
                Class<?>[] params = m.getParameterTypes();
                if (params == null || params.length != 1 || params[0] != ICriterionTrigger.class) continue;
                register = m;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (register != null) {
            try {
                register.invoke(null, LAUNCH_ROCKET);
                register.invoke(null, FIND_MOON_BOSS);
                register.invoke(null, CREATE_SPACE_STATION);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

