#priority 999999

import crafttweaker.event.BlockHarvestDropsEvent;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import crafttweaker.item.IItemStack;
import crafttweaker.game.IGame;
import crafttweaker.oredict.IOreDictEntry;

<ore:oreIridium>.add(<super_solar_panels:iridium_ore>);
<ore:orePlatinum>.add(<super_solar_panels:platium_ore>);
<ore:oreDilithium>.add(<taiga:dilithium_ore>);
<ore:rawOreAluminium>.remove(<contenttweaker:material_part:7>);

val ores = itemUtils.getItemsByRegexRegistryName(".*_ore");
var ores1 as IItemStack[] = [];
for item in ores{
    if (item.definition.owner == "taiga"){
        ores1 += item;
    }
}
val blocks = itemUtils.getItemsByRegexRegistryName(".*_block");
var blocks1 as IItemStack[] = [];
for item in blocks{
    if (item.definition.owner == "taiga"){
        blocks1 += item;
    }
}

for ench in oreDict.entries{
    var oreName = ench.name;
    var enchGear = ench.firstItem;
    if (oreName.startsWith("rawOre")) {
        var rawOre = oreName.substring("rawOre".length);
        var ore = oreDict.get("ore" + rawOre);//矿石
        for item in ores1{
            val rex as string = ".*"+ camelToSnake(rawOre) +".*";
            if(item.definition.id.matches(rex)){
                ore.add(item);
            }
        }
        var ingot = oreDict.get("ingot" + rawOre);//锭
        var dust = oreDict.get("dust" + rawOre);//粉
        var nugget = oreDict.get("nugget" + rawOre);//粒
        var rawBlock = oreDict.get("rawBlock" + rawOre);//粗矿块
        recipes.addShapeless(rawBlock.firstItem * 1,[ench, ench, ench, ench, ench, ench, ench, ench, ench]);
        recipes.addShapeless(enchGear * 9,[rawBlock]);
        if (! dust.empty && ! nugget.empty && ! ore.empty) {
            //物品粉碎机
            RecipeBuilder.newBuilder("raw_ore_dust" + rawOre, "item_shredder",10,0)
                .addEnergyPerTickInput(10000)
                .addInput(ench * 3)
                .addOutput(dust * 4)
                .build();
            RecipeBuilder.newBuilder("raw_block_dust" + rawOre, "item_shredder",10,0)
                .addEnergyPerTickInput(10000)
                .addInput(rawBlock)
                .addOutput(dust * 12)
                .build();
            var shard = oreDict.get("shard" + rawOre);//碎片
            var clump = oreDict.get("clump" + rawOre);//碎块
            var crushed = oreDict.get("crushed" + rawOre);//粉碎矿石
            if(!shard.empty && !clump.empty){
                mods.mekanism.chemical.injection.addRecipe(enchGear * 3, <gas:unstabledimensional>, shard.firstItem * 8);
                mods.mekanism.purification.addRecipe(enchGear * 1, clump.firstItem * 2);
            }
            if(!crushed.empty){
                mods.ic2.Macerator.addRecipe(crushed.firstItem * 4, enchGear * 3);
                mods.ic2.Macerator.addRecipe(crushed.firstItem * 12, rawBlock);
            }
            if(!isNull(game.getLiquid(camelToSnake(rawOre)))){
                var liquid = game.getLiquid(camelToSnake(rawOre));
                mods.tconstruct.Melting.addRecipe(liquid * 192,enchGear, 800);
                mods.tconstruct.Melting.addRecipe(liquid * (192 * 9),rawBlock, 2300);
                mods.thermalexpansion.Crucible.addRecipe(liquid * 192,enchGear, 5000);
                mods.thermalexpansion.Crucible.addRecipe(liquid * (192 * 9),rawBlock.firstItem, 40000);
                mods.nuclearcraft.Melter.addRecipe(rawBlock,liquid * (192 * 9),10,1.5);
                mods.nuclearcraft.Melter.addRecipe(enchGear,liquid * 192,1.25,1.5);
            }
            if(ore.firstItem.definition.owner == "taiga"){
                var tliquid = game.getLiquid(camelToSnake(rawOre) + "_fluid");
                mods.tconstruct.Melting.addRecipe(tliquid * 192,enchGear, 800);
                mods.tconstruct.Melting.addRecipe(tliquid * (192 * 9),rawBlock, 2300);
                mods.thermalexpansion.Crucible.addRecipe(tliquid * 192,enchGear, 5000);
                mods.thermalexpansion.Crucible.addRecipe(tliquid * (192 * 9),rawBlock.firstItem, 40000);
                mods.nuclearcraft.Melter.addRecipe(ore,tliquid * 288,1.25,1.5);
                mods.nuclearcraft.Melter.addRecipe(rawBlock,tliquid * (192 * 9),10.0,1.5);
                mods.nuclearcraft.Melter.addRecipe(enchGear,tliquid * 192,1.25,1.5);
                mods.mekanism.enrichment.addRecipe(ore * 1, dust.firstItem * 2);
                furnace.addRecipe(ingot.firstItem * 1,ore * 1);
                if(!shard.empty && !clump.empty){
                    mods.mekanism.chemical.injection.addRecipe(ore * 1,<gas:unstabledimensional>, shard.firstItem * 4);
                    mods.mekanism.purification.addRecipe(ore * 1, clump.firstItem * 3);
                }
                if(!crushed.empty){
                    mods.ic2.Macerator.addRecipe(crushed.firstItem * 2,ore * 1);
                }
            }
            mods.mekanism.enrichment.addRecipe(enchGear * 3, dust.firstItem * 4);
            furnace.addRecipe(nugget.firstItem * 6,enchGear);
            //挖掘粗矿
            events.onBlockHarvestDrops(function(event as BlockHarvestDropsEvent) {
                if (!event.world.remote) {
                    if (event.drops.length > 0){
                        if (oreBool(ore,event,oreName)) {
                            if (event.silkTouch) {
                                event.drops = [ore.firstItem * 1];
                                return; 
                            }
                            val fortune = event.fortuneLevel;
                            val random = event.world.random.nextInt(0,(fortune + 1));
                            var sl = 0;

                            if (random > 1) {
                                sl += random;
                                event.drops = [enchGear * sl];
                                return; 
                            } else {
                                event.drops = [enchGear * 1];
                                return; 
                            }
                        }
                    }
                }
            });
            //矿物溶解机
            MachineModifier.setInternalParallelism("mineral_dissolver",32);
            RecipeBuilder.newBuilder("minecraft_ore" + rawOre,"mineral_dissolver",20)
                .addEnergyPerTickInput(256000)
                .addInput(<liquid:sulfuric_acid> * 800)
                .addInput(ore * 4)
                .addOutput(dust * 32)
                .build();
            RecipeBuilder.newBuilder("raw_ore" + rawOre,"mineral_dissolver",20)
                .addEnergyPerTickInput(256000)
                .addInput(<liquid:sulfuric_acid> * 800)
                .addInput(enchGear * 6)
                .addOutput(dust * 32)
                .build();
            
        }
    }
    if (oreName.startsWith("ingot")) {
        if(enchGear.definition.owner == "taiga"){
            var ingot = oreName.substring("ingot".length);
            var dusta = oreDict.get("dust" + ingot);//粉
            var nuggeta = oreDict.get("nugget" + ingot);//粒
            var blocka = oreDict.get("block" + ingot);//块
            var tliquid = game.getLiquid(camelToSnake(ingot) + "_fluid");
            for item in blocks1{
                val rex as string = ".*"+ camelToSnake(ingot) +".*";
                if(item.definition.id.matches(rex)){
                    blocka.add(item);
                }
            }
            if(!blocka.empty&&!nuggeta.empty){
                recipes.addShapeless(enchGear * 1,[nuggeta, nuggeta, nuggeta, nuggeta, nuggeta, nuggeta, nuggeta, nuggeta, nuggeta]);
                recipes.addShapeless(blocka.firstItem * 1,[ench, ench, ench, ench, ench, ench, ench, ench, ench]);
                mods.nuclearcraft.Melter.addRecipe(dusta,tliquid * 144,1.25,1.5);
                mods.nuclearcraft.Melter.addRecipe(enchGear,tliquid * 144,1.25,1.5);
                mods.nuclearcraft.Melter.addRecipe(blocka,tliquid * (144 * 9),10.0,1.5);
                furnace.addRecipe(enchGear * 1,dusta * 1);
            }
        }
    }
}
mods.mekanism.ambientaccumulator.addRecipe(5, <gas:unstabledimensional>, 0.2);
mods.mekanism.ambientaccumulator.addRecipe(43, <gas:unstabledimensional>, 0.2);
mods.mekanism.ambientaccumulator.addRecipe(100, <gas:brine>, 0.5);
mods.thermalexpansion.Crucible.removeRecipe(<minecraft:magma>);
mods.thermalexpansion.Crucible.addRecipe(<liquid:magma_fluid> * 288, <minecraft:magma>, 12213);
mods.thermalexpansion.Crucible.addRecipe(<liquid:lava> * 1000, <minecraft:magma>, 40000);

//快捷获取物品矿词
function od(item as IItemStack) as IOreDictEntry {
    return item.ores[0];
}
//名称处理器
function camelToSnake(camelStr as string) as string {
    var result = "";
    var index = 0;
    while (index < camelStr.length) {
        if (camelStr.matches(".*[A-Z].*")) {
            if (index != 0 && camelStr.substring(index,index + 1).matches(".*[A-Z].*")) {
                result += "_";
            }
            result += camelStr.substring(index, index + 1).toLowerCase();
        } else {
            result += camelStr.substring(index, index + 1);
        }
            index += 1;
        }
    return result;
}
//宝石晶体判定器
function oreBool(ore as IOreDictEntry,event as BlockHarvestDropsEvent,oreName as string) as bool {
    if (event.drops.length != 0){
        val item = event.drops[0].stack;
        var rawOre = oreName.substring("rawOre".length);
        val crystal = oreDict.get("crystal"+ rawOre);
        val gem = oreDict.get("gem"+ rawOre);
        if (ore in item||crystal in item||gem in item){
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}