import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;

import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.SimpleMachineUpgrade;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineEvent;
import mods.modularmachinery.MachineUpgradeHelper;
import mods.modularmachinery.MachineUpgradeBuilder;
import mods.modularmachinery.UpgradeEventHandlerWrapper;

#priority 150
#loader crafttweaker reloadable

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:industrial_circuit_v3>);
MachineUpgradeBuilder.newBuilder("auxiliary_processor", "§b模块化升级：辅助处理器", 1, 1)
    .addDescriptions(
        "机械能量消耗提高 §c10kRF§7，每完成一个配方，使机械的工作耗时 §a(1.00 - 0.01)x§7。",
        "最低不低于 §a0.75x§7，如果期间有其他种类的配方运行，则提升效果重置。",
        "§c升级不可堆叠。"
    )
    .setBusGUIDescriptionHandler(function(u as SimpleMachineUpgrade) {
        val upgrade = MachineUpgradeHelper.castToSimpleMachineUpgrade(u);

        val data = upgrade.customData;
        val dData = D(data);
        val duration = dData.getFloat("duration", 0);
        val desc as string[] = [
            "§6辅助处理器：耗时乘数：§a" + (((1.0F - duration) * 1000) as int) as float / 1000 + "x"
        ];

        return desc;
    })
    .addRecipeStartHandler(function(e as RecipeStartEvent, u as SimpleMachineUpgrade) {
        val event = MMEvents.castToRecipeStartEvent(e);
        val upgrade = MachineUpgradeHelper.castToSimpleMachineUpgrade(u);

        val data = upgrade.customData;
        val dData = D(data);
        val map = data.asMap();
        val activeRecipe = event.activeRecipe;
        val registryName = activeRecipe.registryName;
        val lastRegName = dData.getString("recipeRegistryName", "");
        var duration = dData.getFloat("duration", 0);
        if (!registryName.contains(lastRegName)) {
            duration = 0.0F;
            map["duration"] = duration;
        }
        map["recipeRegistryName"] = registryName;
        upgrade.customData = data;

        event.controller.addModifier("auxiliary_processor_energy", RecipeModifierBuilder.create("modularmachinery:energy", "input", 10000, 0, false).build());
        event.controller.addModifier("auxiliary_processor_duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 1.0F - duration, 1, false).build());
    })
    .addFactoryRecipeStartHandler(function(e as FactoryRecipeStartEvent, u as SimpleMachineUpgrade) {
        val event = MMEvents.castToFactoryRecipeStartEvent(e);
        val upgrade = MachineUpgradeHelper.castToSimpleMachineUpgrade(u);

        val data = upgrade.customData;
        val dData = D(data);
        val map = data.asMap();
        val activeRecipe = event.activeRecipe;
        val registryName = activeRecipe.registryName;
        val lastRegName = dData.getString("recipeRegistryName", "");
        var duration = dData.getFloat("duration", 0);
        if (!registryName.contains(lastRegName)) {
            duration = 0.0F;
            map["duration"] = duration;
        }
        map["recipeRegistryName"] = registryName;
        upgrade.customData = data;

        event.factoryRecipeThread.addModifier("auxiliary_processor_energy", RecipeModifierBuilder.create("modularmachinery:energy", "input", 10000, 0, false).build());
        event.factoryRecipeThread.addModifier("auxiliary_processor_duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 1.0F - duration, 1, false).build());
    })
    .addRecipeFinishHandler(function(e as RecipeFinishEvent, u as SimpleMachineUpgrade) {
        val upgrade = MachineUpgradeHelper.castToSimpleMachineUpgrade(u);

        val data = upgrade.customData;
        val dData = D(data);
        val map = data.asMap();
        var duration = dData.getFloat("duration", 0);
        if (duration < 0.25) {
            duration += 0.001;
            map["duration"] = duration;
            upgrade.customData = data;
        }
    })
    .addFactoryRecipeFinishHandler(function(e as FactoryRecipeFinishEvent, u as SimpleMachineUpgrade) {
        val upgrade = MachineUpgradeHelper.castToSimpleMachineUpgrade(u);

        val data = upgrade.customData;
        val map = data.asMap();
        val dData = D(data);
        var duration = dData.getFloat("duration", 0);
        if (duration < 0.25) {
            duration += 0.001;
            map["duration"] = duration;
            upgrade.customData = data;
        }
    })
    .buildAndRegister();

MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:industrial_circuit_v3>, "auxiliary_processor");
