//Recipes By Hikari_Nova & EringMantis831.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 100
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.IngredientArrayBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.MachineBuilder;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MultiblockModifierBuilder;
import mods.modularmachinery.BlockArrayBuilder;

import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.RecipeTickEvent;
import mods.modularmachinery.Sync;

import crafttweaker.world.IBlockPos;
import crafttweaker.world.IWorld;
import crafttweaker.item.IItemStack;
import crafttweaker.data.IData;
import crafttweaker.item.IIngredient;
import crafttweaker.oredict.IOreDictEntry;
import crafttweaker.liquid.ILiquidStack;
import mod.mekanism.gas.IGasStack;
import mods.astralsorcery.Altar;

import novaeng.hypernet.HyperNetHelper;


global programmingCircuits as IItemStack[] = [
    <contenttweaker:programming_circuit_a>,
    <contenttweaker:programming_circuit_b>,
    <contenttweaker:programming_circuit_c>,
    <contenttweaker:programming_circuit_d>,
    <contenttweaker:programming_circuit_e>,
    <contenttweaker:programming_circuit_f>,
];
var recipeCount = 0;

// val modifier = MultiblockModifierBuilder.newBuilder("modifier_name")
//     .setBlockArray(BlockArrayBuilder.newBuilder()
//         .addBlock(0, 0, 0, <avaritia:block_resource:1>)
//         .getBlockArray())
//     .setDescriptiveStack(<avaritia:block_resource:1>)
//     .build();
// MachineBuilder.getBuilder("machine_name")
//     .addMultiBlockModifier(modifier);

//初始并行数设置
MachineModifier.setInternalParallelism("high_temp_melting_factory", 32);
MachineModifier.setInternalParallelism("engineering_inscriber", 8);
MachineModifier.setInternalParallelism("covalent_overloader", 4);
MachineModifier.setInternalParallelism("phaselense", 8);
MachineModifier.setInternalParallelism("mineral_dissolver", 32);
MachineModifier.setInternalParallelism("neutron_activator", 8);
MachineModifier.setInternalParallelism("precision_assembler", 4);
MachineModifier.setInternalParallelism("dream_energy_core", 4);

//==============================纯晶合成仪==============================
HyperNetHelper.proxyMachineForHyperNet("pure_crystal_synthesis_instrument");

MachineModifier.setMaxParallelism("pure_crystal_synthesis_instrument", 16);

//盈能水晶-Lv1
RecipeBuilder.newBuilder("energycrystal_lv1", "Pure_crystal_synthesis_instrument", 800)
    .addEnergyPerTickInput(256000)
    .addInput(<enderio:item_material:15> * 16)
    .addOutput(<custommc:item929>)
    .requireResearch("plentiful_crystal")
    .build();

//盈能水晶-Lv2
RecipeBuilder.newBuilder("energycrystal_lv2", "Pure_crystal_synthesis_instrument", 3600)
    .addEnergyPerTickInput(150000000)
    .addInput(<custommc:item929> * 4)
    .addOutput(<custommc:item170>)
    .requireResearch("plentiful_crystal")
    .build();

//==============================发电机==============================//
//==============================星宿反应堆==============================
//星宿反应堆_控制器
RecipeBuilder.newBuilder("starburst_reactor_controller", "workshop", 60000)
    .addEnergyPerTickInput(7680000)
    .addInputs([
        <contenttweaker:industrial_circuit_v4> * 48,
        <contenttweaker:field_generator_v4> * 32,
        <contenttweaker:antimatter_core> * 6,
        <custommc:item170> * 64,
        <custommc:item170> * 64,
        <modularmachinery:alppm_controller>,
        <modularmachinery:energy_crystal_2_controller>,
    ])
    .addOutput(<modularmachinery:starburst_reactor_controller>)
    .requireComputationPoint(24000.0F)
    .requireResearch("starburst_reactor")
    .build();

//==============================空气燃烧循环器==============================
RecipeBuilder.newBuilder("gas_generator", "gas_generator", 20)
    .addFluidPerTickInput(<liquid:water> * 10000)
    .addFluidPerTickOutput(<liquid:steam> * 10000)
    .addEnergyPerTickOutput(40000)
    .build();

//==============================方舟辅助仓==============================
//方舟辅助仓_控制器
RecipeBuilder.newBuilder("ark_auxiliary_warehouse_controller", "workshop", 7200)
    .addEnergyPerTickInput(300000)
    .addInput(<contenttweaker:industrial_circuit_v4> * 6)
    .addInput(<contenttweaker:field_generator_v4> * 2)
    .addInput(<contenttweaker:antimatter_core>)
    .addInput(<custommc:item170> * 6)
    .addInput(<modularmachinery:blockcasing>)
    .addOutput(<modularmachinery:ark_auxiliary_warehouse_controller>)
    .requireComputationPoint(6000.0F)
    .requireResearch("starburst_reactor")
    .build();

//发电
RecipeBuilder.newBuilder("ark_auxiliary_warehouse_day", "ark_auxiliary_warehouse", 13000, 0, true)
    .setTime(10, 12999)
    .addEnergyPerTickOutput(2500000000)
    .build();

//发电
RecipeBuilder.newBuilder("ark_auxiliary_warehouse_night", "ark_auxiliary_warehouse", 13000, 0, true)
    .setTime(13000, 23992)
    .addEnergyPerTickOutput(2500000000)
    .build();

//==============================电磁发电机==============================
//电磁_0-33格
RecipeBuilder.newBuilder("dici_0", "di_ci", 24000)
    .setAltitude(0, 32)
    .addEnergyPerTickOutput(80000000)
    .build();

//电磁_33-96格
RecipeBuilder.newBuilder("dici_1", "di_ci", 24000)
    .setAltitude(33, 96)
    .addEnergyPerTickOutput(70000000)
    .build();

//电磁_97_186格
RecipeBuilder.newBuilder("dici_2", "di_ci", 24000)
    .setAltitude(97, 192)
    .addEnergyPerTickOutput(55000000)
    .build();

//电磁_193-256格
RecipeBuilder.newBuilder("dici_3", "di_ci", 24000)
    .setAltitude(193, 256)
    .addEnergyPerTickOutput(40000000)
    .build();

//电磁发电机-控制器
RecipeBuilder.newBuilder("di_ci_controller", "machine_arm", 3200)
    .addEnergyPerTickInput(768000)
    .addInput(<contenttweaker:industrial_circuit_v2> * 16)
    .addInput(<contenttweaker:field_generator_v1> * 32)
    .addInput(<mets:te:21> * 16)
    .addInput(<mets:geomagnetic_pedestal> * 64)
    .addInput(<contenttweaker:coil_v3> * 24)
    .addInput(<modularmachinery:blockcasing>)
    .addOutput(<modularmachinery:di_ci_controller>)
    .requireResearch("di_ci")
    .build();

//==============================太阳能光热电站/大型光热电站==============================
//太阳能光热电站-日间
RecipeBuilder.newBuilder("solar_panel_0_day", "solar_panel_0", 13000, 0, true)
    .setTime(10, 12999)
    .setWeather("sunny")
    .addEnergyPerTickOutput(7000000)
    .build();

//太阳能光热电站-夜间
RecipeBuilder.newBuilder("solar_panel_0_night", "solar_panel_0", 13000, 0, true)
    .setTime(13000, 23992)
    .setWeather("sunny")
    .addEnergyPerTickOutput(2000000)
    .build();

//太阳能光热电站-控制器
RecipeBuilder.newBuilder("solar_panel_0_controller", "mach_crafter", 1200)
    .addEnergyPerTickInput(3072)
    .addInputs([
        <contenttweaker:sensor_v1> * 4,
        <contenttweaker:industrial_circuit_v1> * 16,
        <ore:gemBoronArsenide> * 16,
        <super_solar_panels:crafting:17> * 16,
        <modularmachinery:blockcasing> * 1,
    ])
    .addOutput(<modularmachinery:solar_panel_0_controller>)
    .requireResearch("solar_panel_0")
    .build();

//大型光热电站-日间
RecipeBuilder.newBuilder("solar_panel_1_day", "solar_panel_1", 13000, 0, true)
    .setTime(10, 12999)
    .setWeather("sunny")
    .addEnergyPerTickOutput(24000000)
    .build();

//大型光热电站-夜间
RecipeBuilder.newBuilder("solar_panel_1_night", "solar_panel_1", 13000, 0, true)
    .setTime(13000, 23992)
    .setWeather("sunny")
    .addEnergyPerTickOutput(8000000)
    .build();

//大型光热电站-控制器
RecipeBuilder.newBuilder("solar_panel_1_controller", "machine_arm", 1600)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:sensor_v1> * 8,
        <contenttweaker:industrial_circuit_v1> * 32,
        <ore:gemBoronArsenide> * 48,
        <super_solar_panels:crafting:17> * 48,
        <modularmachinery:solar_panel_0_controller> * 1,
    ])
    .addOutput(<modularmachinery:solar_panel_1_controller>)
    .requireResearch("solar_panel_1")
    .build();

//============================== α 能量水晶 / β 能量水晶 ==============================
//α 水晶-控制器
RecipeBuilder.newBuilder("controller_energy_crystal", "workshop", 12000)
    .addEnergyPerTickInput(64000000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 24,
        <ore:blockCrystalMatrix> * 24,
        <ore:blockElectrumFlux> * 24,
        <contenttweaker:field_generator_v2> * 12,
        <contenttweaker:engineering_battery_v4> * 12,
        <extrabotany:blockorichalcos> * 6,
        <modularmachinery:blockcasing>,
    ])
    .addOutput(<modularmachinery:energy_crystal_controller>)
    .requireComputationPoint(1000.0F)
    .requireResearch("energy_crystal")
    .build();

//β 水晶-控制器
RecipeBuilder.newBuilder("controller_energy_crystal_2", "workshop", 48000)
    .addEnergyPerTickInput(256000000)
    .addInput(<contenttweaker:infinity_processor> * 24)
    .addInput(<contenttweaker:field_generator_v3> * 12)
    .addInput(<mekanism:antimatterpellet> * 8)
    .addInput(<custommc:item968>)
    .addInput(<modularmachinery:energy_crystal_controller>)
    .addOutput(<modularmachinery:energy_crystal_2_controller>)
    .requireComputationPoint(6000.0F)
    .requireResearch("energy_crystal_beta")
    .build();

//==============================混合燃料发电机==============================
MachineModifier.setMaxThreads("hybrid_generator", 4);

//废料盒
RecipeBuilder.newBuilder("scarpbox_gen", "Hybrid_generator", 120)
    .addInput(<ic2:crafting:24> * 24)
    .addEnergyPerTickOutput(160000)
    .setMaxThreads(1)
    .build();

//烈焰网
RecipeBuilder.newBuilder("blaze_gen", "Hybrid_generator", 80)
    .addInput(<botania:blazeblock>)
    .addInput(<liquid:pyrotheum> * 500)
    .addEnergyPerTickOutput(750000)
    .setMaxThreads(1)
    .build();

//煤炭块
RecipeBuilder.newBuilder("coalblock_gen", "Hybrid_generator", 100)
    .addInput(<ore:blockCoal> * 16)
    .addEnergyPerTickOutput(120000)
    .setMaxThreads(1)
    .build();

//烧开水(?
RecipeBuilder.newBuilder("water_gen", "Hybrid_generator", 40)
    .addInput(<liquid:water> * 30000)
    .addInput(<thermalfoundation:material:1024> * 6)
    .addOutput(<liquid:high_pressure_steam> * 120000)
    .addEnergyPerTickOutput(20000)
    .setMaxThreads(1)
    .build();

//IC2 热冷却液
RecipeBuilder.newBuilder("ic2hot_coolant_gen", "Hybrid_generator", 1)
    .addInput(<liquid:ic2hot_coolant> * 2000)
    .addOutput(<liquid:ic2coolant> * 2000)
    .addEnergyPerTickOutput(80000)
    .setMaxThreads(1)
    .build();

//乙烯
RecipeBuilder.newBuilder("ethene_gen", "Hybrid_generator", 80)
    .addGasInput(<gas:ethene> * 2000)
    .addEnergyPerTickOutput(300000)
    .setMaxThreads(1)
    .build();

//荧石
RecipeBuilder.newBuilder("glowstone_dust_gen", "Hybrid_generator", 600)
    .addInput(<ore:dustGlowstone> * 48)
    .addEnergyPerTickOutput(72000)
    .setMaxThreads(1)
    .build();

//蒸汽
RecipeBuilder.newBuilder("steam_gen", "Hybrid_generator", 1)
    .addInput(<liquid:steam> * 10000)
    .addOutput(<liquid:water> * 10000)
    .addEnergyPerTickOutput(80000)
    .setMaxThreads(1)
    .build();

//钻石
RecipeBuilder.newBuilder("diamond_gen", "Hybrid_generator", 600)
    .addInput(<ore:gemDiamond> * 12)
    .addEnergyPerTickOutput(160000)
    .setMaxThreads(1)
    .build();

//充能燃料单元
RecipeBuilder.newBuilder("energized_fuel_v1_hybrid_gen", "Hybrid_generator", 1600)
    .addInput(<contenttweaker:energized_fuel_v1> * 1)
    .addEnergyPerTickOutput(15000000)
    .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
        val ctrl = event.controller;
        val ticksExisted = ctrl.ticksExisted;
        if (ticksExisted % 5 == 0) {
            val activeRecipeList = ctrl.activeRecipeList;
            ctrl.addModifier("energizedFuelIncrease", RecipeModifierBuilder.create("modularmachinery:energy", "output", activeRecipeList.length as float * 4.0F, 1, false).build());
        }
    })
    .addRecipeTooltip([
        "运行时，使机械总发电量 §ax(运行的配方种类数量 * 4)§f。",
        "最高不超过 §a16x§f。",
    ])
    .addOutput(<contenttweaker:energized_fuel_depleted_v1> * 1)
    .setMaxThreads(1)
    .build();

//==============================生物质发电机(下北泽发电厂)==============================
MachineModifier.setInternalParallelism("biogas_generator", 16);

//藿香碱
RecipeBuilder.newBuilder("refined_biofuel_1", "biogas_generator", 800)
    .addInput(<liquid:refined_biofuel> * 400)
    .addEnergyPerTickOutput(80000)
    .build();

//基片
RecipeBuilder.newBuilder("substrate", "biogas_generator", 800)
    .addInput(<mekanism:substrate> * 24)
    .addEnergyPerTickOutput(25000)
    .build();

//沼气（
RecipeBuilder.newBuilder("biogas", "biogas_generator", 200)
    .addInput(<liquid:ic2biogas> * 35000)
    .addEnergyPerTickOutput(114514)
    .build();

//==============================宇宙射线接收器==============================
//铁锭
RecipeBuilder.newBuilder("crr_Iron", "cosmic_ray_receiver", 1200)
    .addInput(<ore:ingotIron> * 24)
    .addEnergyPerTickOutput(8000)
    .build();

//末影钢锭
RecipeBuilder.newBuilder("crr_Enderium", "cosmic_ray_receiver", 1800)
    .addInput(<ore:ingotEndSteel> * 8)
    .addEnergyPerTickOutput(64000)
    .build();

//末影锭
RecipeBuilder.newBuilder("crr_Enderium_1", "cosmic_ray_receiver", 1800)
    .addInput(<ore:ingotEnderium> * 12)
    .addEnergyPerTickOutput(128000)
    .build();

//铱锭
RecipeBuilder.newBuilder("crr_Iridium", "cosmic_ray_receiver", 2400)
    .addInput(<ore:ingotIridium> * 12)
    .addEnergyPerTickOutput(256000)
    .build();

//恒星合金锭
RecipeBuilder.newBuilder("crr_alloy_endergy_ingot_3", "cosmic_ray_receiver", 4800)
    .addInput(<enderio:item_alloy_endergy_ingot:3> * 8)
    .addEnergyPerTickOutput(512000)
    .build();

//觉醒龙锭
RecipeBuilder.newBuilder("crr_draconic_ingot", "cosmic_ray_receiver", 9600)
    .addInput(<draconicevolution:draconic_ingot> * 8)
    .addEnergyPerTickOutput(2048000)
    .build();

//奥利哈刚
RecipeBuilder.newBuilder("crr_eb_material", "cosmic_ray_receiver", 25600)
    .addInput(<extrabotany:material:1>)
    .addEnergyPerTickOutput(2048000)
    .build();

//水晶矩阵锭
RecipeBuilder.newBuilder("crr_ava_resource_1", "cosmic_ray_receiver", 12800)
    .addInput(<avaritia:resource:1> * 6)
    .addEnergyPerTickOutput(6144000)
    .build();

//中子素
RecipeBuilder.newBuilder("crr_ava_resource_4", "cosmic_ray_receiver", 25600)
    .addInput(<avaritia:resource:4> * 8)
    .addEnergyPerTickOutput(6144000)
    .build();

//==============================光质子注能器==============================
//炽焰
RecipeBuilder.newBuilder("na_pyrotheum", "neutron_activator", 10)
    .addEnergyPerTickInput(128000)
    .addInput(<liquid:lava> * 10000)
    .addOutput(<liquid:pyrotheum> * 1000)
    .build();

//凛冰
RecipeBuilder.newBuilder("na_cyrotheum", "neutron_activator", 10)
    .addEnergyPerTickInput(128000)
    .addInput(<liquid:water> * 10000)
    .addOutput(<liquid:cryotheum> * 1000)
    .build();

//氚
RecipeBuilder.newBuilder("na_tritium", "neutron_activator", 100)
    .addEnergyPerTickInput(128000)
    .addGasInput(<gas:lithium> * 150000)
    .addGasOutput(<gas:tritium> * 150000)
    .build();

//光质子注能器-控制器
RecipeBuilder.newBuilder("controller_neutron_activator", "machine_arm", 2400)
    .addEnergyPerTickInput(256000)
    .addInput(<contenttweaker:industrial_circuit_v1> * 24)
    .addInput(<contenttweaker:sensor_v1> * 16)
    .addInput(<mekanism:polyethene:2> * 32)
    .addInput(<ore:blockCopper> * 32)
    .addInput(<modularmachinery:blockcasing>)
    .addOutput(<modularmachinery:neutron_activator_controller>)
    .requireResearch("neutron_activator")
    .build();

//==============================核融起爆机==============================
//核心黏贴剂
// RecipeBuilder.newBuilder("hexinniantieji_1", "nuclear_melt_detonator", 1)
//     .addEnergyPerTickInput(2147483647)
//     .addInput(<liquid:hydrogen> * 128000)
//     .addInput(<liquid:knightslime> * 24000)
//     .addInput(<minecraft:clay> * 32)
//     .addInput(<minecraft:slime> * 12)
//     .addInput(<tconstruct:ingots:3> * 2)
//     .addOutput(<custommc:item169>)
//     .build();

// //机械合金
// RecipeBuilder.newBuilder("jixiehexin_1", "nuclear_melt_detonator", 1)
//     .addEnergyPerTickInput(2147483647)
//     .addInput(<liquid:hydrogen> * 128000)
//     .addInput(<ore:itemSilicon> * 6)
//     .addInput(<thermalfoundation:material:295> * 6)
//     .addInput(<enderio:item_material:12> * 6)
//     .addInput(<tconevo:metal:39> * 6)
//     .addInput(<thermalfoundation:material:263> * 6)
//     .addInput(<thermalfoundation:material:293> * 6)
//     .addInput(<tconevo:metal:44>)
//     .addInput(<ore:ingotAlloyT2> * 8)
//     .addOutput(<ore:ingotMachalloy>)
//     .build();

//未完成-进阶核心

//未完成-农业核心

//未完成-全能核心

//未完成-珠宝核心

//==============================物品粉碎机==============================
# 最大并行数 512
MachineModifier.setMaxParallelism("item_shredder", 512);

RecipeAdapterBuilder.create("item_shredder", "novaeng_core:shredder")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.05,  1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 1000, 1, false).build())
    .build();

# 粉碎 - 圆石
RecipeBuilder.newBuilder("item_shredder_cobblestone", "item_shredder", 20)
    .addEnergyPerTickInput(12800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0).setParallelizeUnaffected(true)
    .addItemInputs([
        <minecraft:cobblestone> * 6,
        <minecraft:cobblestone> * 6,
        <minecraft:cobblestone> * 6,
    ])
    .addOutput(<ic2:crafting:23> * 6)
    .addOutput(<ic2:crafting:23> * 1).setChance(0.75)
    .addOutput(<ic2:crafting:23> * 1).setChance(0.5)
    .addOutput(<ic2:crafting:23> * 1).setChance(0.25)
    .build();

# 粉碎 - 沙子 + 海蓝宝石
RecipeBuilder.newBuilder("item_shredder_aquamarine", "item_shredder", 20)
    .addEnergyPerTickInput(25600)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<liquid:astralsorcery.liquidstarlight> * 16000).setChance(0)
    .addInput(<liquid:lava> * 16000).setChance(0)
    .addOutput(<minecraft:sand> * 64)
    .addOutput(<astralsorcery:itemcraftingcomponent> * 2).setChance(0.75)
    .addOutput(<astralsorcery:itemcraftingcomponent> * 2).setChance(0.5)
    .addOutput(<astralsorcery:itemcraftingcomponent> * 1).setChance(0.25)
    .addRecipeTooltip([
        "星能液数量和熔岩数量§c受并行影响§f，但是§a不消耗§f。",
    ])
    .build();

# 粉碎 - 沙子 + 海蓝宝石
RecipeBuilder.newBuilder("item_shredder_aquamarine_nosand", "item_shredder", 20)
    .addEnergyPerTickInput(51200)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<liquid:astralsorcery.liquidstarlight> * 16000).setChance(0)
    .addInput(<liquid:lava> * 16000).setChance(0)
    .addOutput(<astralsorcery:itemcraftingcomponent> * 2).setChance(0.75)
    .addOutput(<astralsorcery:itemcraftingcomponent> * 2).setChance(0.5)
    .addOutput(<astralsorcery:itemcraftingcomponent> * 1).setChance(0.25)
    .addRecipeTooltip([
        "星能液数量和熔岩数量§c受并行影响§f，但是§a不消耗§f。",
    ])
    .build();

//==============================霍金恒星坍缩机==============================
//霍金恒星坍缩机-控制器
RecipeBuilder.newBuilder("controller_star_collapser", "workshop", 9600)
    .addEnergyPerTickInput(204800000)
    .addItemInputs([
        <contenttweaker:infinity_processor> * 16,
        <contenttweaker:field_generator_v3> * 24,
        <draconicevolution:reactor_component> * 4,
        <draconicevolution:particle_generator> * 32,
        <enderio:block_alloy_endergy:3> * 16,
        <draconicevolution:draconic_block> * 16,
        <extrabotany:blockorichalcos> * 4,
        <ore:gemCrystalRGP> * 1,
    ])
    .addOutput(<modularmachinery:star_collapser_controller>)
    .requireComputationPoint(8500.0F)
    .requireResearch("star_collapser")
    .build();

//超光速物质加速器
RecipeBuilder.newBuilder("controller_lightspeed_material_accelerator", "workshop", 32000)
    .addEnergyPerTickInput(65536000000)
    .addInputs([
        <contenttweaker:industrial_circuit_v4> * 64,
        <contenttweaker:industrial_circuit_v4> * 64,
        <contenttweaker:sensor_v5> * 64,
        <contenttweaker:antimatter_core> * 48,
        <ore:ingotAlloyT3> * 12,
        <custommc:item132> * 1,
    ])
    .addOutput(<modularmachinery:light-speed_material_accelerator_controller>)
    .requireComputationPoint(120000.0F)
    .requireResearch("breakthrough_world")
    .build();

HyperNetHelper.proxyMachineForHyperNet("star_collapser");
MachineModifier.setInternalParallelism("star_collapser", 64);

//混沌核心
RecipeBuilder.newBuilder("star_collapser_ChaoticCore", "star_collapser", 200)
    .addEnergyPerTickInput(10000000)
    .addItemInputs([
        <draconicevolution:draconic_ingot> * 4,
        <draconicevolution:chaos_shard>,
        <draconicevolution:awakened_core>
    ])
    .addOutput(<draconicevolution:chaotic_core>)
    .requireComputationPoint(1000.0F)
    .build();

//混沌能量核心
RecipeBuilder.newBuilder("star_collapser_ChaoticEnergyCore", "star_collapser", 200)
    .addEnergyPerTickInput(50000000)
    .addInput(<ore:blockRedstone> * 4)
    .addItemInputs([
        <draconicevolution:chaos_shard:1> * 3,
        <draconicevolution:draconic_energy_core>
    ])
    .addOutput(<draconicadditions:chaotic_energy_core>)
    .build();

//觉醒核心
RecipeBuilder.newBuilder("star_collapser_AwakenedCore", "star_collapser", 200)
    .addEnergyPerTickInput(125000)
    .addInput(<draconicevolution:draconic_ingot> * 4)
    .addInput(<draconicevolution:wyvern_core> * 4)
    .addOutput(<draconicevolution:awakened_core>)
    .build();

//龙蛋
RecipeBuilder.newBuilder("star_collapser_DragonEgg", "star_collapser", 1200)
    .addEnergyPerTickInput(75000000)
    .addInput(<draconicevolution:chaos_shard:1> * 2)
    .addInput(<draconicevolution:mob_soul>)
    .addOutput(<minecraft:dragon_egg>)
    .build();

//无尽之锭
RecipeBuilder.newBuilder("star_collapser_InfIngot", "star_collapser", 1200)
    .addEnergyPerTickInput(128000000)
    .addInput(<avaritia:resource:4> * 20)
    .addInput(<avaritia:resource:1> * 8)
    .addInput(<avaritia:resource:5> * 8)
    .addOutput(<avaritia:resource:6>)
    .addOutput(<avaritia:resource:5>).setChance(0.1)
    .build();

RecipeBuilder.newBuilder("star_collapser_antimatter_core", "star_collapser", 1200)
    .addEnergyPerTickInput(128000000)
    .addInputs([
        <liquid:steady_ultra_dense_atomic_matter> * 1000,
        <mekanism:antimatterpellet> * 10,
        <draconicadditions:chaotic_energy_core> * 2,
        <contenttweaker:field_generator_v4> * 1,
        <ore:gemCrystalRGP> * 1,
    ])
    .addOutput(<contenttweaker:antimatter_core>)
    .build();

//==============================机械外壳成型机==============================
//钢框架
RecipeBuilder.newBuilder("nuclearcraft_part_12_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(64)
    .addInput(<ore:ingotSteel> * 6)
    .addInput(<nuclearcraft:alloy:1> * 6)
    .addInput(<ore:ingotBronze> * 2)
    .addOutput(<nuclearcraft:part:12> * 2)
    .build();

//机器框架_NC
RecipeBuilder.newBuilder("nuclearcraft_part_10_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(64)
    .addInput(<ore:ingotLead> * 6)
    .addInput(<ore:ingotSteel> * 6)
    .addInput(<nuclearcraft:alloy:1> * 2)
    .addOutput(<nuclearcraft:part:10> * 2)
    .build();

//钢质机壳
RecipeBuilder.newBuilder("mekanism_basicblock_8_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(64)
    .addInput(<ore:ingotSteel> * 6)
    .addInput(<ore:blockGlass> * 6)
    .addInput(<ore:ingotOsmium> * 2)
    .addOutput(<mekanism:basicblock:8> * 2)
    .build();

//基础机械外壳
RecipeBuilder.newBuilder("ic2_resource_12_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(24)
    .addInput(<ore:plateIron> * 12)
    .addOutput(<ic2:resource:12> * 2)
    .build();

//高级机械外壳
RecipeBuilder.newBuilder("ic2_resource_13_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(128)
    .addInput(<ore:plateSteel> * 6)
    .addInput(<ic2:crafting:3> * 3)
    .addInput(<ore:plateCarbon> * 3)
    .addOutput(<ic2:resource:13> * 2)
    .build();

//机器框架_TE
RecipeBuilder.newBuilder("thermalfoundation_material_257_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(24)
    .addInput(<ore:ingotIron> * 6)
    .addInput(<ore:blockGlass> * 6)
    .addInput(<ore:gearTin> * 2)
    .addOutput(<thermalexpansion:frame> * 2)
    .build();

//设备框架
RecipeBuilder.newBuilder("thermalfoundation_material_64_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(16)
    .addInput(<ore:ingotTin> * 6)
    .addInput(<ore:blockGlass> * 6)
    .addInput(<ore:gearCopper> * 2)
    .addOutput(<thermalexpansion:frame:64> * 2)
    .build();

//简易机器框架
RecipeBuilder.newBuilder("enderio_item_material_1", "mechanical_housing_molding_machine", 200)
    .addEnergyPerTickInput(24)
    .addInput(<minecraft:iron_bars> * 6)
    .addInput(<ore:ingotIron> * 6)
    .addInput(<enderio:item_material:20>)
    .addOutput(<enderio:item_material> * 2)
    .build();

//==============================物质熵变机==============================
//最大并行数 32
MachineModifier.setMaxParallelism("material_entropy_converter", 64);

//龙之心_混沌碎片
RecipeBuilder.newBuilder("Dragon_heart", "Material_entropy_converter", 6400)
    .addEnergyPerTickInput(128000)
    .addInput(<draconicadditions:chaos_heart>)
    .addOutput(<draconicevolution:dragon_heart>)
    .addOutput(<draconicevolution:chaos_shard> * 10)
    .build();

//==============================零素转换机==============================
//零素转换机_控制器
RecipeBuilder.newBuilder("zero_factor_converter_controller", "workshop", 12000)
    .addEnergyPerTickInput(1280000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 20,
        <contenttweaker:exponential_level_processor> * 12,
        <contenttweaker:field_generator_v1> * 10,
        <contenttweaker:sensor_v3> * 4,
        <mets:nano_living_metal> * 40,
        <thermalfoundation:material:359> * 20,
        <ore:ingotFallenStarAlloy> * 2,
    ])
    .addOutput(<modularmachinery:zero_factor_converter_controller>)
    .requireComputationPoint(450.0F)
    .requireResearch("eco_y7")
    .build();

//最大并行数 40
MachineModifier.setMaxParallelism("zero_factor_converter", 40);

//晶素 => UU 物质
RecipeBuilder.newBuilder("crystalloid_to_uu", "zero_factor_converter", 1)
    .addEnergyPerTickInput(25000000)
    .addInput(<liquid:crystalloid> * 1)
    .addOutput(<liquid:ic2uu_matter> * 10000)
    .build();

//UU物质 => 晶素
RecipeBuilder.newBuilder("uu_to_crystalloid", "zero_factor_converter", 1)
    .addEnergyPerTickInput(50000000)
    .addInput(<liquid:ic2uu_matter> * 10000)
    .addOutput(<liquid:crystalloid> * 1)
    .build();

//==============================先进液体转换装置==============================
MachineModifier.setMaxParallelism("advanced_liquid_conversion_machine", 256);

//先进液体转换装置_控制器
RecipeBuilder.newBuilder("ALCM_controller", "machine_arm", 3200)
    .addEnergyPerTickInput(768000)
    .addInput(<contenttweaker:industrial_circuit_v2> * 48)
    .addInput(<contenttweaker:electric_motor_v3> * 32)
    .addInput(<contenttweaker:field_generator_v1> * 16)
    .addInput(<enderio:block_solar_panel:6> * 10)
    .addInput(<mekanism:basicblock:8> * 32)
    .addOutput(<modularmachinery:advanced_liquid_conversion_machine_controller>)
    .requireResearch("advanced_liquid_conversion_machine")
    .build();

//氘氚燃料
RecipeBuilder.newBuilder("ALCM_dt", "advanced_liquid_conversion_machine", 20)
    .addEnergyPerTickInput(400000)
    .addInput(<liquid:heavywater> * 1200)
    .addInput(<liquid:liquidlithium> * 1200)
    .addOutput(<liquid:liquidfusionfuel> * 2400)
    .build();

//炽焰
RecipeBuilder.newBuilder("ALCM_pyrotheum", "advanced_liquid_conversion_machine", 10)
    .addEnergyPerTickInput(512000)
    .addInput(<liquid:lava> * 10000)
    .addOutput(<liquid:pyrotheum> * 1000)
    .build();

//凛冰
RecipeBuilder.newBuilder("ALCM_cyrotheum", "advanced_liquid_conversion_machine", 10)
    .addEnergyPerTickInput(512000)
    .addInput(<liquid:water> * 10000)
    .addOutput(<liquid:cryotheum> * 1000)
    .build();

//中子晶流体
RecipeBuilder.newBuilder("ALCM_CryN", "advanced_liquid_conversion_machine", 5)
    .addEnergyPerTickInput(2560000)
    .addInput(<liquid:crystal_matrix> * 18)
    .addInput(<liquid:neutronium> * 18)
    .addInput(<liquid:crystalloid> * 2)
    .addOutput(<liquid:crystalloidneutron> * 36)
    .build();

//稳态超密原子物质
RecipeBuilder.newBuilder("ALCM_SUDAM_0", "advanced_liquid_conversion_machine", 200)
    .addEnergyPerTickInput(40960000)
    .addInput(<liquid:unsteady_plasma> * 8000)
    .addInput(<liquid:crystalloidneutron> * 144)
    .addInput(<liquid:water> * 1)
    .addOutput(<liquid:steady_ultra_dense_atomic_matter> * 440)
    .build();

//稳态超密原子物质
RecipeBuilder.newBuilder("ALCM_SUDAM_1", "advanced_liquid_conversion_machine", 200)
    .addEnergyPerTickInput(163840000)
    .addInput(<liquid:unsteady_plasma> * 8000)
    .addInput(<liquid:crystalloidneutron> * 144)
    .addInput(<liquid:infinity_metal> * 2)
    .addOutput(<liquid:steady_ultra_dense_atomic_matter> * 4400)
    .build();

//==============================物质异变器==============================
//最大并行数 512
MachineModifier.setMaxParallelism("material_isomers", 512);

//物质异变器_控制器
RecipeBuilder.newBuilder("material_isomers_controller", "machine_arm", 3600)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 24,
        <contenttweaker:coil_v3> * 12,
        <ore:ingotBlueAlloy> * 6,
        <super_solar_panels:crafting:34>,
        <modularmachinery:material_entropy_converter_controller>,
    ])
    .addOutput(<modularmachinery:material_isomers_controller>)
    .requireResearch("material_isomers")
    .build();

//异变光子核心
RecipeBuilder.newBuilder("phocore_2", "material_isomers", 4800)
    .addInput(<super_solar_panels:crafting:34> * 8)
    .addInput(<liquid:crystalloidneutron> * 4320)
    .addOutput(<additions:novaextended-phocore_2>)
    .addEnergyPerTickOutput(1000000)
    .build();
/* 
//==============================超微缩恒星戴森球==============================
//超微缩恒星戴森球_控制器
RecipeBuilder.newBuilder("super_star_dyson_ball_controller", "machine_arm", 1200)
    .addEnergyPerTickInput(96000)
    .addInput(<contenttweaker:industrial_circuit_v1> * 36)
    .addInput(<minecraft:glowstone> * 64)
    .addInput(<super_solar_panels:crafting:1> * 24)
    .addInput(<thermalfoundation:glass_alloy:6> * 24)
    .addInput(<modularmachinery:blockcasing> * 1)
    .addOutput(<modularmachinery:super_star_dyson_ball_controller>)
    .requireResearch("super_star_dyson_ball")
    .build();

//煤炭块
RecipeBuilder.newBuilder("coalblock", "super_star_dyson_ball", 4800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<minecraft:coal_block> * 64)
    .addEnergyPerTickOutput(300000)
    .build();

//红石块
RecipeBuilder.newBuilder("redstoneblock", "super_star_dyson_ball", 4800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<minecraft:redstone_block> * 64)
    .addEnergyPerTickOutput(600000)
    .build();

//钻石块
RecipeBuilder.newBuilder("diamondblock", "super_star_dyson_ball", 6400)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<minecraft:diamond_block> * 64)
    .addEnergyPerTickOutput(1500000)
    .build();

//黑曜石
RecipeBuilder.newBuilder("obdisan", "super_star_dyson_ball", 6400)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<minecraft:obsidian> * 64)
    .addEnergyPerTickOutput(1500000)
    .build();

//下界之星
RecipeBuilder.newBuilder("netherstar", "super_star_dyson_ball", 36000)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<minecraft:nether_star> * 64)
    .addEnergyPerTickOutput(10000000)
    .build();

//中子素锭
RecipeBuilder.newBuilder("ava_resource_4", "super_star_dyson_ball", 36000)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<avaritia:resource:4> * 64)
    .addEnergyPerTickOutput(30000000)
    .build();

//中子素块
RecipeBuilder.newBuilder("ava_block_resource_1", "super_star_dyson_ball", 36000)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<avaritia:block_resource> * 64).setChance(0.2)
    .addEnergyPerTickOutput(90000000)
    .build();

//无尽催化剂
RecipeBuilder.newBuilder("ava_resource_5", "super_star_dyson_ball", 18000)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<avaritia:resource:5> * 11).setChance(0)
    .addEnergyPerTickOutput(100000000)
    .build();

//无尽块
RecipeBuilder.newBuilder("ava_blockresource_1", "super_star_dyson_ball", 18000)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<avaritia:block_resource:1>).setChance(0.05)
    .addEnergyPerTickOutput(200000000)
    .build();

//奥利哈刚x64
RecipeBuilder.newBuilder("orich_x64", "super_star_dyson_ball", 36000)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<extrabotany:material:1> * 64).setChance(0.25)
    .addEnergyPerTickOutput(200000000)
    .build();

//奥利哈刚
RecipeBuilder.newBuilder("orich_x1", "super_star_dyson_ball", 18000)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<extrabotany:material:1>)
    .addEnergyPerTickOutput(20000000)
    .build();

//奥利哈刚块
RecipeBuilder.newBuilder("orichblock_x1", "super_star_dyson_ball", 36000)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<extrabotany:blockorichalcos>).setChance(0.75)
    .addEnergyPerTickOutput(50000000)
    .build();

//盖亚魂锭
RecipeBuilder.newBuilder("gaiaingot", "super_star_dyson_ball", 12000)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<botania:manaresource:14> * 16)
    .addEnergyPerTickOutput(20000000)
    .build();

//DT燃料
RecipeBuilder.newBuilder("dtfuel", "super_star_dyson_ball", 6000)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0)
    .addGasInput(<gas:fusionfuel> * 1000000)
    .addEnergyPerTickOutput(30000000)
    .build();
*/
//==============================大型筛矿机==============================
//大型筛矿机_控制器
RecipeBuilder.newBuilder("large_sieving_machine_controller", "mach_crafter", 600)
    .addEnergyPerTickInput(400)
    .addInput(<contenttweaker:industrial_circuit_v1> * 4)
    .addInput(<minecraft:piston> * 4)
    .addInput(<minecraft:hopper> * 2)
    .addInput(<minecraft:flint> * 8)
    .addInput(<modularmachinery:blockcasing>)
    .addOutput(<modularmachinery:large_sieving_machine_factory_controller>)
    .requireResearch("large_sieving_machine")
    .build();

MachineModifier.setMaxThreads("large_sieving_machine", 4);

//筛矿-沙砾-1
RecipeBuilder.newBuilder("large_sieving_machine_gravel_1", "large_sieving_machine", 160)
    .addEnergyPerTickInput(1000)
    .addCatalystInput(<ore:dustPetrotheum>,
        ["地岩粉可以提高筛矿机产出的矿物质量。", "工作时间 §ax0.5§f，所有矿物产出概率 §a+15%§f。"],
        [
            RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.5F, 1, false).build(),
            RecipeModifierBuilder.create("modularmachinery:item", "output", 0.15F, 1, true).build(),
        ]
    ).setChance(0.1F)
    .addInput(<minecraft:gravel> * 8)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<thermalfoundation:material>).setChance(0.15)
    .addOutput(<thermalfoundation:material:64>).setChance(0.15)
    .addOutput(<thermalfoundation:material:65>).setChance(0.15)
    .addOutput(<nuclearcraft:dust:4>).setChance(0.15)
    .addOutput(<nuclearcraft:dust:5>).setChance(0.15)
    .addOutput(<nuclearcraft:dust:6>).setChance(0.15)
    .addOutput(<nuclearcraft:dust:7>).setChance(0.15)
    .addOutput(<mets:titanium_dust>).setChance(0.15)
    .addOutput(<minecraft:dye:4> * 2).setChance(0.15)
    .setMaxThreads(1)
    .build();

//筛矿-沙砾-2
RecipeBuilder.newBuilder("large_sieving_machine_gravel_2", "large_sieving_machine", 160)
    .addEnergyPerTickInput(2000)
    .addCatalystInput(<ore:dustPetrotheum>,
        ["地岩粉可以提高筛矿机产出的矿物质量。", "工作时间 §ax0.5§f，所有矿物产出概率 §a+10%§f。"],
        [
            RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.5F, 1, false).build(),
            RecipeModifierBuilder.create("modularmachinery:item", "output", 0.1F, 1, true).build(),
        ]
    ).setChance(0.1F)
    .addInput(<minecraft:gravel> * 8)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<thermalfoundation:material:768> * 2).setChance(0.15)
    .addOutput(<minecraft:redstone> * 2).setChance(0.15)
    .addOutput(<thermalfoundation:material:1>).setChance(0.12)
    .addOutput(<minecraft:diamond>).setChance(0.09)
    .addOutput(<thermalfoundation:material:69>).setChance(0.09)
    .addOutput(<minecraft:emerald>).setChance(0.06)
    .addOutput(<thermalfoundation:material:70>).setChance(0.05)
    .addOutput(<thermalfoundation:material:71>).setChance(0.05)
    .addOutput(<mets:niobium_dust>).setChance(0.05)
    .setMaxThreads(1)
    .build();

//筛矿-圆石-1
RecipeBuilder.newBuilder("large_sieving_machine_cobblestone_1", "large_sieving_machine", 320)
    .addEnergyPerTickInput(3000)
    .addCatalystInput(<ore:dustPetrotheum>,
        ["地岩粉可以提高筛矿机产出的矿物质量。", "工作时间 §ax0.5§f，所有矿物产出概率 §a+20%§f。"],
        [
            RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.5F, 1, false).build(),
            RecipeModifierBuilder.create("modularmachinery:item", "output", 0.2F, 1, true).build(),
        ]
    ).setChance(0.1F)
    .addInput(<minecraft:cobblestone> * 8)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<thermalfoundation:material>).setChance(0.09)
    .addOutput(<thermalfoundation:material:64>).setChance(0.09)
    .addOutput(<thermalfoundation:material:65>).setChance(0.09)
    .addOutput(<nuclearcraft:dust:4>).setChance(0.09)
    .addOutput(<nuclearcraft:dust:5>).setChance(0.09)
    .addOutput(<nuclearcraft:dust:6>).setChance(0.09)
    .addOutput(<nuclearcraft:dust:7>).setChance(0.09)
    .addOutput(<mets:titanium_dust>).setChance(0.09)
    .addOutput(<minecraft:dye:4> * 2).setChance(0.09)
    .setMaxThreads(1)
    .build();

//筛矿-圆石-2
RecipeBuilder.newBuilder("large_sieving_machine_cobblestone_2", "large_sieving_machine", 320)
    .addEnergyPerTickInput(6000)
    .addCatalystInput(<ore:dustPetrotheum>,
        ["地岩粉可以提高筛矿机产出的矿物质量。", "工作时间 §ax0.5§f，所有矿物产出概率 §a+15%§f。"],
        [
            RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.5F, 1, false).build(),
            RecipeModifierBuilder.create("modularmachinery:item", "output", 0.15F, 1, true).build(),
        ]
    ).setChance(0.1F)
    .addInput(<minecraft:cobblestone> * 8)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<thermalfoundation:material:768> * 2).setChance(0.09)
    .addOutput(<minecraft:redstone> * 2).setChance(0.09)
    .addOutput(<thermalfoundation:material:1>).setChance(0.15)
    .addOutput(<minecraft:diamond>).setChance(0.12)
    .addOutput(<thermalfoundation:material:69>).setChance(0.12)
    .addOutput(<minecraft:emerald>).setChance(0.09)
    .addOutput(<thermalfoundation:material:70>).setChance(0.07)
    .addOutput(<thermalfoundation:material:71>).setChance(0.07)
    .addOutput(<mets:niobium_dust>).setChance(0.07)
    .setMaxThreads(1)
    .build();

//==============================异变光粒子聚合机==============================
//异变光粒子聚合机_控制器
RecipeBuilder.newBuilder("alppm_controller", "workshop", 12000)
    .addEnergyPerTickInput(750000)
    .addInputs([
        <contenttweaker:field_generator_v3> * 32,
        <contenttweaker:industrial_circuit_v3> * 24,
        <additions:novaextended-phocore_2> * 2,
        <super_solar_panels:machines:5> * 2,
        <modularmachinery:material_isomers_controller> * 1,
    ])
    .addOutput(<modularmachinery:alppm_controller>)
    .requireComputationPoint(6000.0F)
    .requireResearch("alppm")
    .build();

//==============================ECO-T7收集器==============================
//阿斯加德蒲公英
RecipeBuilder.newBuilder("asgard_t7", "eco-t7", 1200)
    .addInput(<botania:specialflower>.withTag({type: "asgardandelion"})).setChance(0)
    .addManaPerTickOutput(32000)
    .build();

//==============================ECO-NE7β物质生成机==============================
//ECO-NE7β物质生成机-控制器
RecipeBuilder.newBuilder("npc_controller", "workshop", 14400)
    .addEnergyPerTickInput(64000000)
    .addInput(<liquid:crystalloidneutron> * 2880)
    .addInput(<contenttweaker:industrial_circuit_v3> * 24)
    .addInput(<contenttweaker:field_generator_v2> * 24)
    .addInput(<super_solar_panels:crafting:29> * 24)
    .addInput(<super_solar_panels:machines:10> * 24)
    .addOutput(<modularmachinery:neutron_particle_crystal_controller>)
    .requireComputationPoint(1200.0F)
    .requireResearch("neutron_particle_crystal")
    .build();

//流体中子
RecipeBuilder.newBuilder("neutron_1", "neutron_particle_crystal", 20)
    .addEnergyPerTickInput(20000000)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<liquid:neutron> * 20)
    .build();

//流体中子-1
RecipeBuilder.newBuilder("neutron_2", "neutron_particle_crystal", 20)
    .addEnergyPerTickInput(80000000)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<liquid:neutron> * 80)
    .build();

//流体中子-2
RecipeBuilder.newBuilder("neutron_3", "neutron_particle_crystal", 20)
    .addEnergyPerTickInput(320000000)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0)
    .addOutput(<liquid:neutron> * 320)
    .build();

//流体中子-3
RecipeBuilder.newBuilder("neutron_4", "neutron_particle_crystal", 20)
    .addEnergyPerTickInput(640000000)
    .addInput(<contenttweaker:programming_circuit_d>).setChance(0)
    .addOutput(<liquid:neutron> * 640)
    .build();

//==============================中子态素模式扫描机==============================
HyperNetHelper.proxyMachineForHyperNet("nsemc");
//最大线程数
MachineModifier.setMaxThreads("nsemc", 6);

//中子态素模式扫描机-控制器
RecipeBuilder.newBuilder("nsemc_controller", "workshop", 7200)
    .addEnergyPerTickInput(51200000)
    .addInput(<liquid:crystalloidneutron> * 28800)
    .addInput(<contenttweaker:industrial_circuit_v3> * 12)
    .addInput(<contenttweaker:sensor_v3> * 8)
    .addInput(<contenttweaker:field_generator_v2> * 6)
    .addInput(<super_solar_panels:crafting:29> * 16)
    .addInput(<ic2:te:64> * 6)
    .addOutput(<modularmachinery:nsemc_factory_controller>)
    .requireComputationPoint(6000.0F)
    .requireResearch("cnrc")
    .build();

//铜-数据卡
RecipeBuilder.newBuilder("card_copper", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockCopper> * 64)
    .addOutput(<contenttweaker:data_model_copper>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//红石水晶-数据卡
RecipeBuilder.newBuilder("card_crystal_flux", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockCrystalFlux> * 64)
    .addOutput(<contenttweaker:data_model_crystal_flux>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//钻石-数据卡
RecipeBuilder.newBuilder("card_diamond", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockDiamond> * 64)
    .addOutput(<contenttweaker:data_model_diamond>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//红石琥珀金-数据卡
RecipeBuilder.newBuilder("card_electrum_flux", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockElectrumFlux> * 64)
    .addOutput(<contenttweaker:data_model_electrum_flux>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//绿宝石-数据卡
RecipeBuilder.newBuilder("crad_emerald", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockEmerald> * 64)
    .addOutput(<contenttweaker:data_model_emerald>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//极寒末影-数据卡
RecipeBuilder.newBuilder("card_gelid_enderium", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockGelidEnderium> * 64)
    .addOutput(<contenttweaker:data_model_gelid_enderium>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//极寒水晶-数据卡
RecipeBuilder.newBuilder("card_gelid_gem", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockGelidCrystal> * 64)
    .addOutput(<contenttweaker:data_model_gelid_gem>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//金-数据卡
RecipeBuilder.newBuilder("card_gold", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockGold> * 64)
    .addOutput(<contenttweaker:data_model_gold>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//铱-数据卡
RecipeBuilder.newBuilder("card_iridium", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockIridium> * 64)
    .addOutput(<contenttweaker:data_model_iridium>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//铁-数据卡
RecipeBuilder.newBuilder("card_iron", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockIron> * 64)
    .addOutput(<contenttweaker:data_model_iron>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//青金石-数据卡
RecipeBuilder.newBuilder("card_lapis", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockLapis> * 64)
    .addOutput(<contenttweaker:data_model_lapis>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//铅-数据卡
RecipeBuilder.newBuilder("card_lead", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockLead> * 64)
    .addOutput(<contenttweaker:data_model_lead>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//镍-数据卡
RecipeBuilder.newBuilder("card_nickel", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockNickel> * 64)
    .addOutput(<contenttweaker:data_model_nickel>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//铂-数据卡
RecipeBuilder.newBuilder("card_platinum", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockPlatinum> * 64)
    .addOutput(<contenttweaker:data_model_platinum>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//石英-数据卡
RecipeBuilder.newBuilder("card_quartz", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockQuartz> * 64)
    .addOutput(<contenttweaker:data_model_quartz>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//红石-数据卡
RecipeBuilder.newBuilder("card_redstone", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockRedstone> * 64)
    .addOutput(<contenttweaker:data_model_redstone>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//银-数据卡
RecipeBuilder.newBuilder("card_silver", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockSilver> * 64)
    .addOutput(<contenttweaker:data_model_silver>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

//锡-数据卡
RecipeBuilder.newBuilder("card_tin", "nsemc", 6000)
    .addEnergyPerTickInput(51200000)
    .addInput(<contenttweaker:data_model_card>)
    .addInput(<ore:blockTin> * 64)
    .addOutput(<contenttweaker:data_model_tin>).setChance(0.1)
    .requireComputationPoint(500.0F)
    .build();

// //奥利哈刚-数据卡
// RecipeBuilder.newBuilder("card_orichalcos", "nsemc", 6000)
//     .addEnergyPerTickInput(51200000)
//     .addInput(<contenttweaker:data_model_card>)
//     .addInput(<extrabotany:blockorichalcos>)
//     .addOutput(<contenttweaker:data_model_orichalcos>).setChance(0.1)
//     .build();

//==============================超临界物质移相器==============================
//超临界物质移相器_控制器
RecipeBuilder.newBuilder("Supercritical_phase_shifter_controller", "workshop", 24000)
    .addEnergyPerTickInput(5120000)
    .addInputs([
        <contenttweaker:antimatter_core> * 10,
        <contenttweaker:industrial_circuit_v4> * 16,
        <contenttweaker:field_generator_v4> * 16,
        <contenttweaker:coil_v5> * 24,
        <custommc:item170> * 48,
        <avaritiaio:infinitecapacitor> * 6,
        <modularmachinery:energy_crystal_2_controller> * 1,
        <liquid:liquid_energy> * 100000,
    ])
    .addOutput(<modularmachinery:supercritical_phase_shifter_controller>)
    .requireComputationPoint(26000.0F)
    .requireResearch("supercritical_shifting")
    .build();

//==============================生命萃取祭坛==============================
//生命萃取祭坛_控制器
RecipeBuilder.newBuilder("life_extracts_altar_controller", "machine_arm", 2400)
    .addEnergyPerTickInput(512000)
    .addInput(<contenttweaker:lifesense_processor> * 16)
    .addInput(<bloodmagic:blood_rune:0> * 256)
    .addInput(<bloodmagic:activation_crystal>)
    .addInput(<minecraft:nether_star> * 4)
    .addInput(<bloodmagic:decorative_brick> * 64)
    .addInput(<avaritia:resource:1> * 4)
    .addInput(<bloodmagic:blood_tank:4>.withTag({Fluid: {FluidName: "lifeessence", Amount: 256000}}))
    .addOutput(<modularmachinery:life_extracts_altar_controller>)
    .requireResearch("life_extracts_altar")
    .build();

//生命萃取祭坛_生命源质
RecipeBuilder.newBuilder("extract_Lifeessence", "life_extracts_altar", 400)
    .addInput(<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:weak"})).setChance(0.90)
    .addOutput(<liquid:lifeessence> * 2000)
    .build();

RecipeBuilder.newBuilder("extract_Lifeessence_1", "life_extracts_altar", 400)
    .addInput(<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:apprentice"})).setChance(0.70)
    .addOutput(<liquid:lifeessence> * 3000)
    .build();

RecipeBuilder.newBuilder("extract_Lifeessence_2", "life_extracts_altar", 400)
    .addInput(<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:magician"})).setChance(0.50)
    .addOutput(<liquid:lifeessence> * 4500)
    .build();

RecipeBuilder.newBuilder("extract_Lifeessence_3", "life_extracts_altar", 300)
    .addInput(<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:master"})).setChance(0.20)
    .addOutput(<liquid:lifeessence> * 8000)
    .build();

RecipeBuilder.newBuilder("extract_Lifeessence_4", "life_extracts_altar", 200)
    .addInput(<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:archmage"})).setChance(0.10)
    .addOutput(<liquid:lifeessence> * 12000)
    .build();


//==============================聚星灵井==============================
//聚星灵井_控制器
RecipeBuilder.newBuilder("starlight_well_craft", "mach_crafter", 600)
    .addEnergyPerTickInput(768)
    .addInput(<astralsorcery:blockwell> * 6)
    .addInput(<astralsorcery:itemcraftingcomponent:4> * 16)
    .addInput(<astralsorcery:itemcraftingcomponent:1> * 8)
    .addInput(<astralsorcery:itemrockcrystalsimple>)
    .addInput(<modularmachinery:blockcasing>)
    .addOutput(<modularmachinery:starlight_well_controller>)
    .requireResearch("starlight_well")
    .build();

// 37.5、35

//聚星灵井_熔岩
RecipeBuilder.newBuilder("well_lava_netherrack", "starlight_well", 10)
    .addInput(<ore:netherrack>).setChance(0.9)
    .addFluidPerTickOutput(<liquid:lava> * 5)
    .build();

RecipeBuilder.newBuilder("well_lava_magma", "starlight_well", 150)
    .addInput(<ore:blockMagma>).setChance(0.5)
    .addFluidPerTickOutput(<liquid:lava> * 20)
    .build();

//聚星灵井_星能液
RecipeBuilder.newBuilder("well_aquamarine", "starlight_well", 150)
    .addInput(<ore:gemAquamarine>).setChance(0.15)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 15)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .build();

RecipeBuilder.newBuilder("well_resonating", "starlight_well", 150)
    .addInput(<astralsorcery:itemcraftingcomponent:4>).setChance(0.1)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 20)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .build();

RecipeBuilder.newBuilder("well_rock", "starlight_Well", 150)
    .addInput(<astralsorcery:itemrockcrystalsimple>).setChance(0.04)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 10)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .build();

RecipeBuilder.newBuilder("well_celestial", "starlight_Well", 150)
    .addInput(<astralsorcery:itemcelestialcrystal>).setChance(0.025)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 25)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .build();

RecipeBuilder.newBuilder("well_manadiamond", "starlight_well", 150)
    .addInput(<ore:manaDiamond>).setChance(0.05)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 25)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .build();


RecipeBuilder.newBuilder("well_hero", "starlight_Well", 150)
    .addInput(<extrabotany:material:3>).setChance(0.005)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 75)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .build();

RecipeBuilder.newBuilder("well_astral_diamond", "starlight_well", 150)
    .addInput(<ebwizardry:astral_diamond>).setChance(0.0025)
    .addFluidPerTickOutput(<liquid:astralsorcery.liquidstarlight> * 35)
    .addCatalystInput(<astralsorcery:itemcoloredlens:6>,
        ["注入了星能的彩色透镜拥有将星能汇聚的能力。", "使星能液的产量翻倍。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 2.0F, 1, false).build(),
        ]).setChance(0)
    .addCatalystInput(<ancientspellcraft:astral_diamond_charged>,
        ["充能后的星芒宝钻蕴含着众多遗灵强大的能量。", "使星能液的产量 §ax3§f。"],
        [
            RecipeModifierBuilder.create("modularmachinery:fluid", "output", 3.0F, 1, false).build(),
        ]).setChance(0)
    .build();

//==============================能量转化机==============================
RecipeBuilder.newBuilder("energy_converter", "machine_arm", 3200)
    .addEnergyPerTickInput(768000)
    .addInput(<contenttweaker:industrial_circuit_v2> * 16)
    .addInput(<contenttweaker:field_generator_v1> * 6)
    .addInput(<draconicevolution:draconic_energy_core> * 6)
    .addInput(<appliedenergistics2:material:44> * 32)
    .addInput(<ore:ingotEnergium> * 32)
    .addInput(<avaritia:block_resource:2>)
    .addOutput(<modularmachinery:energy_converter_controller>)
    .requireResearch("energy_converter")
    .build();

RecipeBuilder.newBuilder("tiny_energy_converter", "machine_arm", 1200)
    .addEnergyPerTickInput(768000)
    .addInput(<contenttweaker:industrial_circuit_v2> * 4)
    .addInput(<contenttweaker:field_generator_v1> * 2)
    .addInput(<draconicevolution:draconic_energy_core> * 2)
    .addInput(<appliedenergistics2:material:44> * 8)
    .addInput(<ore:ingotEnergium> * 8)
    .addInput(<ore:ingotCrystalMatrix> * 2)
    .addOutput(<modularmachinery:tiny_energy_converter_controller>)
    .requireResearch("energy_converter")
    .build();

RecipeBuilder.newBuilder("energy_liquefier", "machine_arm", 3200)
    .addEnergyPerTickInput(768000)
    .addInput(<contenttweaker:industrial_circuit_v2> * 16)
    .addInput(<contenttweaker:field_generator_v1> * 6)
    .addInput(<draconicevolution:draconic_energy_core> * 6)
    .addInput(<appliedenergistics2:material:43> * 32)
    .addInput(<ore:ingotEnergium> * 32)
    .addInput(<avaritia:block_resource:2>)
    .addOutput(<modularmachinery:energy_liquefier_controller>)
    .requireResearch("energy_converter")
    .build();

RecipeBuilder.newBuilder("energy_conversion_station_controller", "workshop", 7200)
    .addEnergyPerTickInput(6144000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 6,
        <contenttweaker:field_generator_v1> * 16,
        <draconicadditions:chaotic_energy_core> * 6,
        <ore:ingotEnergium> * 32,
        <avaritia:block_resource:2> * 2,
        <modularmachinery:tiny_energy_converter_controller> * 1,
    ])
    .addOutputs(<modularmachinery:energy_conversion_station_controller> * 1)
    .requireComputationPoint(125.0F)
    .requireResearch("energy_conversion_station")
    .build();

//==============================微型能量转换器==============================
RecipeBuilder.newBuilder("tiny_energy_converter_1", "tiny_energy_converter", 2000)
    .addInput(<liquid:liquid_energy>)
    .addEnergyPerTickOutput(2500000)
    .build();

//==============================复合型中子复制压缩机==============================
HyperNetHelper.proxyMachineForHyperNet("cnrc");
//复合型中子复制压缩机_控制器
RecipeBuilder.newBuilder("cnrc_controller", "workshop", 12000)
    .addEnergyPerTickInput(204800000)
    .addInput(<liquid:crystalloidneutron> * 28800)
    .addInput(<contenttweaker:industrial_circuit_v4> * 32)
    .addInput(<contenttweaker:infinity_processor> * 12)
    .addInput(<contenttweaker:antimatter_core> * 2)
    .addInput(<extendedcrafting:compressor> * 8)
    .addInput(<ic2:te:63> * 32)
    .addOutput(<modularmachinery:cnrc_factory_controller>)
    .requireComputationPoint(8500.0F)
    .requireResearch("cnrc")
    .build();

val models as IItemStack[] = [
    <contenttweaker:data_model_tin>,
    <contenttweaker:data_model_iron>,
    <contenttweaker:data_model_copper>,
    <contenttweaker:data_model_lapis>,
    <contenttweaker:data_model_redstone>,
    <contenttweaker:data_model_gold>,
    <contenttweaker:data_model_lead>,
    <contenttweaker:data_model_nickel>,
    <contenttweaker:data_model_quartz>,
    <contenttweaker:data_model_silver>,
    <contenttweaker:data_model_electrum_flux>,
    <contenttweaker:data_model_crystal_flux>,
    <contenttweaker:data_model_diamond>,
    <contenttweaker:data_model_iridium>,
    <contenttweaker:data_model_platinum>,
    // <contenttweaker:data_model_emerald>,
    <contenttweaker:data_model_gelid_enderium>,
    <contenttweaker:data_model_gelid_gem>,
    // <contenttweaker:data_model_orichalcos>
];

val modelOutputs as IItemStack[] = [
    <avaritia:singularity:6> * 6,# 1 锡
    <avaritia:singularity:0> * 6,# 2 铁
    <avaritia:singularity:5> * 6,# 3 铜
    <avaritia:singularity:2> * 4,# 4 青金石
    <avaritia:singularity:3> * 4,# 5 红石
    <avaritia:singularity:1> * 7,# 6 金
    <avaritia:singularity:7> * 7,# 7 铅
    <avaritia:singularity:9> * 4,# 8 镍
    <avaritia:singularity:4> * 4,# 9 石英
    <avaritia:singularity:8> * 4,# 10 银
    <avaritia:singularity:12> * 4,# 11 红石琥珀金
    <redstonearsenal:storage:1> * 64,# 12 红石水晶
    <avaritia:singularity:10> * 1,# 13 钻石
    <avaritia:singularity:14> * 1,# 14 铱
    <avaritia:singularity:13> * 1,# 15 铂
    // <avaritia:singularity:11> * 1,# 16 绿宝石
    <redstonerepository:storage:0> * 64,# 17 极寒末影
    <redstonerepository:storage:1> * 64,# 18 极寒水晶
    // <extrabotany:material:1># 19 奥利哈刚
];

val modelUseSUDAMs as int[] = [
    1,#1
    1,#2
    1,#3
    1,#4
    1,#5
    2,#6
    2,#7
    1,#8
    1,#9
    1,#10
    1,#11
    3,#12
    175,#13
    215,#14
    95,#15
    // 275,#16
    45,#17
    35,#18
    // 300#19
];

//设置线程数
MachineModifier.setMaxThreads("cnrc", models.length);

for i, model in models {
    val modelOutput = modelOutputs[i];
    val modelUseSUDAM = modelUseSUDAMs[i];

    RecipeBuilder.newBuilder("cnrc_copy_sudam_" + i, "cnrc", 400)
    .addInput(model).setChance(0)
    .addInput(<liquid:steady_ultra_dense_atomic_matter> * modelUseSUDAM)
    .addEnergyPerTickInput(6000000 as long * modelUseSUDAM)
    .addOutput(modelOutput)
    .setMaxThreads(1)
    .requireComputationPoint(modelUseSUDAM * 50)
    .build();

    RecipeBuilder.newBuilder("cnrc_copy_crystalloid_" + i, "cnrc", 800)
        .addInput(model).setChance(0)
        .addInput(<liquid:crystalloid> * (modelUseSUDAM * 6))
        .addEnergyPerTickInput(2000000 * modelUseSUDAM)
        .addOutput(modelOutput)
        .requireComputationPoint(modelUseSUDAM * 100)
        .setMaxThreads(1)
        .build();
}

/*
//==============================终焉反应堆==============================
//终焉反应堆_控制器
RecipeBuilder.newBuilder("terminal_reactor_controller", "workshop", 16000)
    .addInput(<avaritia:resource:5> * 4)
    .addInput(<ore:circuitExtreme> * 24)
    .addInput(<matteroverdrive:fusion_reactor_controller>)
    .addInput(<modularmachinery:tokmak_reactor_controller>)
    .addInput(<modularmachinery:energy_liquefier_controller>)
    .addInput(<liquid:plasma> * 16000)
    .addInput(<liquid:matter_plasma> * 48000)
    .addEnergyPerTickInput(7680000)
    .addOutput(<modularmachinery:terminal_reactor_controller>)
    .build();

//终焉反应堆_发电
RecipeBuilder.newBuilder("terminal_reactor_energy_0", "terminal_reactor", 1600)
    .addInput(<contenttweaker:programming_circuit_0>).setChance(0)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<liquid:plasma> * 8000)
    .addInput(<liquid:matter_plasma> * 24000)
    .addOutput(<liquid:unsteady_plasma> * 4000)
    .addOutput(<liquid:liquid_energy> * 256)
    .build();

//终焉反应堆_发电
RecipeBuilder.newBuilder("terminal_reactor_energy_1", "terminal_reactor", 1600)
    .addInput(<contenttweaker:programming_circuit_0>).setChance(0)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<liquid:plasma> * 16000)
    .addInput(<liquid:matter_plasma> * 48000)
    .addInput(<liquid:chaotic_metal> * 1)
    .addOutput(<liquid:unsteady_plasma> * 8000)
    .addOutput(<liquid:liquid_energy> * 512)
    .build();

//终焉反应堆_生产
RecipeBuilder.newBuilder("terminal_reactor_gen_0", "terminal_reactor", 800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<liquid:plasma> * 4000)
    .addInput(<liquid:matter_plasma> * 24000)
    .addOutput(<liquid:unsteady_plasma> * 4000)
    .addOutput(<liquid:liquid_energy> * 64)
    .build();

//终焉反应堆_生产
RecipeBuilder.newBuilder("terminal_reactor_gen_1", "terminal_reactor", 800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<liquid:plasma> * 8000)
    .addInput(<liquid:matter_plasma> * 8000)
    .addOutput(<liquid:unsteady_plasma> * 8000)
    .addOutput(<liquid:liquid_energy> * 128)
    .build();

//终焉反应堆_生产
RecipeBuilder.newBuilder("terminal_reactor_gen_2", "terminal_reactor", 800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addInput(<liquid:plasma> * 8000)
    .addInput(<liquid:matter_plasma> * 48000)
    .addInput(<liquid:crystalloidneutron> * 8)
    .addOutput(<liquid:unsteady_plasma> * 32000)
    .build();

//终焉反应堆_生产
RecipeBuilder.newBuilder("terminal_reactor_gen_3", "terminal_reactor", 800)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0)
    .addInput(<ore:gemCrystalGreen>).setChance(0.01)
    .addInput(<liquid:plasma> * 8000)
    .addInput(<liquid:matter_plasma> * 96000)
    .addOutput(<liquid:unsteady_plasma> * 32000)
    .addOutput(<liquid:liquid_energy> * 256)
    .build();
*/

//==============================工程压印器==============================
//工程压印器_控制器
RecipeBuilder.newBuilder("engineering_inscriber_controller", "mach_crafter", 1200)
    .addEnergyPerTickInput(1536)
    .addItemInputs([
        <contenttweaker:robot_arm_v2> * 16,
        <contenttweaker:industrial_circuit_v1> * 12,
        <contenttweaker:electric_motor_v2> * 8,
        <threng:material:4> * 16,
        <appliedenergistics2:inscriber> * 8,
        <modularmachinery:blockcasing>,
    ])
    .addOutput(<modularmachinery:engineering_inscriber_controller>)
    .requireResearch("engineering_inscriber")
    .build();

MachineModifier.setMaxParallelism("engineering_inscriber", 256);
HyperNetHelper.proxyMachineForHyperNet("engineering_inscriber");

val inscriberModels as IItemStack[] = [
    <appliedenergistics2:material:13>,
    <appliedenergistics2:material:14>,
    <appliedenergistics2:material:15>,
    <appliedenergistics2:material:19>,
];

val circultConsumables as IOreDictEntry[] = [
    <ore:crystalPureCertusQuartz>,
    <ore:gemDiamond>,
    <ore:ingotGold>,
    <ore:itemSilicon>,
];

val circults as IItemStack[] = [
    <appliedenergistics2:material:16>,
    <appliedenergistics2:material:17>,
    <appliedenergistics2:material:18>,
    <appliedenergistics2:material:20>,
];

val processors as IItemStack[] = [
    <appliedenergistics2:material:23>,
    <appliedenergistics2:material:24>,
    <appliedenergistics2:material:22>,
];

val energyUsage = 1000;
val workTime = 30;
recipeCount = 0;

//推测处理器
RecipeBuilder.newBuilder("engineering_inscriber_speculation_processor", "engineering_inscriber", workTime, recipeCount += 1, false)
    .addEnergyPerTickInput(energyUsage * 2)
    .addInput(<threng:material:13>)
    .addInput(<ore:itemSilicon>)
    .addInput(<ore:dustRedstone> * 1)
    .addOutput(<threng:material:14>)
    .requireComputationPoint(0.1F)
    .build();

for i, processor in processors {
    RecipeBuilder.newBuilder("engineering_inscriber_circult_to_processor_" + i, "engineering_inscriber", workTime, recipeCount += 1, false)
        .addEnergyPerTickInput(energyUsage)
        .addInput(circults[i])
        .addInput(<appliedenergistics2:material:20>)
        .addInput(<ore:dustRedstone>)
        .addOutput(processor)
        .requireComputationPoint(0.1F)
        .build();
}

for i, processor in processors {
    RecipeBuilder.newBuilder("engineering_inscriber_processor_" + i, "engineering_inscriber", workTime, recipeCount += 1, false)
        .addEnergyPerTickInput(energyUsage * 2)
        .addInput(circultConsumables[i])
        .addInput(<ore:itemSilicon>)
        .addInput(<ore:dustRedstone>)
        .addOutput(processor)
        .requireComputationPoint(0.1F)
        .build();
}

//大规模并行处理器
RecipeBuilder.newBuilder("engineering_inscriber_parallel_processor", "engineering_inscriber", workTime, recipeCount += 1, false)
    .addEnergyPerTickInput(energyUsage * 2)
    .addInput(<threng:material:5>)
    .addInput(<ore:itemSilicon>)
    .addInput(<ore:dustRedstone>)
    .addOutput(<threng:material:6>)
    .requireComputationPoint(0.1F)
    .build();

for i, circult in circults {
    RecipeBuilder.newBuilder("engineering_inscriber_circult_" + i, "engineering_inscriber", workTime, recipeCount += 1, false)
        .addEnergyPerTickInput(energyUsage)
        .addInput(inscriberModels[i]).setChance(0).setParallelizeUnaffected(true)
        .addInput(circultConsumables[i])
        .addOutput(circult)
        .requireComputationPoint(0.1F)
        .build();
}

//==============================魔力聚合机==============================
MachineModifier.setMaxThreads("bot_crafter", 3);

//==============================异世界矿物采掘机==============================
MachineModifier.setMaxThreads("different_world", 6);

//==============================虚空采掘机==============================
MachineModifier.setMaxThreads("void_miner", 10);
