//Machine logic By Hikari_Nova.
//在未经过原作者的允许下，***禁止***应用于任何服务器，以及任何更改。

#priority 50
#loader crafttweaker reloadable

import crafttweaker.data.IData;
import crafttweaker.item.IIngredient;

import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.FactoryRecipeThread;

import mods.modularmachinery.MachineUpgradeHelper;
import mods.modularmachinery.MachineUpgradeBuilder;

MachineUpgradeHelper.registerSupportedItem(<extrabotany:buddhistrelics>);
MachineUpgradeHelper.registerSupportedItem(<extrabotany:silenteternity>);

MachineUpgradeBuilder.newBuilder("dream_void", "§6模块化特化：源初造物丨梦幻虚空", 1, 1)
    .addDescriptions(
        "§c仅对梦之能量核心生效。",
        "当内部能量存储大于 §a100TRF§7 时，梦之能量核心可以运行§2精灵门§7的所有配方且不消耗 Mana。",
        "当内部能量存储大于 §a1PTRF§7 时，梦之能量核心可以合成§2盈能水晶§7。",
        "当内部能量存储大于 §a50PRF§7 时，梦之能量核心可以合成§a盈能水晶块§7。",
        "当内部能量存储大于 §a250PRF§7 且拥有升级§6 “永恒之梦” §7时，梦之能量核心可以合成§b注能魔力水晶§7且不消耗 Mana。",
        "当内部能量存储大于 §a500PRF§7 时，梦之能量核心合成§2盈能水晶§7和§a盈能水晶块§7和§b注能魔力水晶§7的工作耗时 §ax0.25§7。",
        "§c升级不可堆叠。"
    )
    .addCompatibleMachines("dream_energy_core")
    .buildAndRegister();

MachineUpgradeBuilder.newBuilder("eternal_dream", "§6模块化特化：永恒之梦", 1, 1)
    .addDescriptions(
        "看起来似乎没有任何作用。",
        "§c升级不可堆叠。"
    )
    .buildAndRegister();

MachineUpgradeHelper.addFixedUpgrade(<extrabotany:buddhistrelics>, "dream_void");
MachineUpgradeHelper.addFixedUpgrade(<extrabotany:silenteternity>, "eternal_dream");

//最小传输速度，按倍计。
val minSpeed = 0.01 as float;
//最大传输速度，按倍计。
val maxSpeed = 20000;
//基础输入输出速度。能量输入输出速度计算方法为：defaultTransferAmount * speed，其中 speed 可由玩家控制。
val defaultTransferAmount = 100000000;
//能量核心内部最大储存能量值，为 long 最大值。
//long 最大值：9223372036854775807L = 0x7fffffffffffffff
val maxStoreSize = 0x7fffffffffffffff as long;

# 控制器
RecipeBuilder.newBuilder("dream_energy_core_controller", "workshop", 7200)
    .addEnergyPerTickInput(4096000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 8,
        <contenttweaker:field_generator_v1> * 16,
        <ore:ingotElvenElementium> * 48,
        <ore:elvenPixieDust> * 48,
        <ore:elvenDragonstone> * 32,
        <extrabotany:buddhistrelics> * 1,
        <modularmachinery:alfheim_portal_controller> * 1,
    ])
    .addOutputs(<modularmachinery:dream_energy_core_factory_controller>)
    .requireComputationPoint(240.0F)
    .requireResearch("dream_energy_core")
    .build();

# 智能数据接口数据类型定义
MachineModifier.addSmartInterfaceType("dream_energy_core",
    SmartInterfaceType.create("speed", 1)
        .setHeaderInfo("能量输入输出速度设置")
        .setValueInfo("速度：§a%.2f 倍")
        .setFooterInfo(
            "例：0.1 倍即为 " + formatNumber(defaultTransferAmount as float * 0.1 as float) + "RF，10 倍即为 " + formatNumber(defaultTransferAmount * 10) + "RF"
        )
        .setJeiTooltip("速度范围：最低 §a%.2f 倍§f，最高 §a%.0f 倍", 2)
        .setNotEqualMessage("输入输出速度过载或过低！")
);

# 能量核心不需要额外的线程。
MachineModifier.setMaxThreads("dream_energy_core", 0);

# 能量输入线程
val inputThreadName = "梦之收集者";
val inputThread = FactoryRecipeThread.createCoreThread(inputThreadName);
MachineModifier.addCoreThread("dream_energy_core", inputThread);

# 能量输出线程
val outputThreadName = "梦之释放者";
val outputThread = FactoryRecipeThread.createCoreThread(outputThreadName);
MachineModifier.addCoreThread("dream_energy_core", outputThread);

# 配方线程（精灵门）
val fairyCraftingThreadName = "梦之同步者";
val fairyCraftingThread = FactoryRecipeThread.createCoreThread(fairyCraftingThreadName);
MachineModifier.addCoreThread("dream_energy_core", fairyCraftingThread);

# 配方线程（魔力水晶，盈能水晶）
val manaCraftingThreadName = "梦之聚合者";
val manaCraftingThread = FactoryRecipeThread.createCoreThread(manaCraftingThreadName);
MachineModifier.addCoreThread("dream_energy_core", manaCraftingThread);

# 写入智能数据接口信息
MMEvents.onMachinePostTick("dream_energy_core", function(event as MachineTickEvent) {
    writeSmartInterfaceDataToCustomData(event, minSpeed, maxSpeed);
});

# 添加控制器 GUI 信息
MMEvents.onControllerGUIRender("dream_energy_core", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val map = data.asMap();
    val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();
    val energyStored = isNull(map["energyStored"]) ? 0 as long : map["energyStored"].asLong();

    val info as string[] = [
        "§b/////////// 梦之管理者 ///////////",
                                                                // 一个非常暴力的小数点去除方式。
        "§b能量储存：§a" + formatNumber(energyStored) + " RF §b(" + ((((energyStored as double / maxStoreSize as double) * 100000) as int) as double / 1000) as double + "%)",
        "§b输入输出速度：§a" + formatNumber(speed * defaultTransferAmount) + " RF/t",
        "§b///////////////////////////////////",
    ];

    event.extraInfo = info;
});

# 输出配方
RecipeBuilder.newBuilder("extract", "dream_energy_core", 1, 1, true)
    .addEnergyPerTickOutput(defaultTransferAmount)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val map = data.asMap();
        val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();
        if (!canExtract(map, speed, defaultTransferAmount)) {
            event.setFailed("内部能量储量不足！");
            return;
        }
        ctrl.addModifier("extract", RecipeModifierBuilder.create("modularmachinery:energy", "output", speed, 1, false).build());
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();
        extractEnergy(ctrl, data, map, speed, defaultTransferAmount);
    })
    .setParallelized(false)
    .addRecipeTooltip("由梦之收集者运行。", "在智能数据接口处修改速度。")
    .addSmartInterfaceDataInput("speed", minSpeed, maxSpeed)
    .setThreadName(outputThreadName)
    .build();

# 输入配方
RecipeBuilder.newBuilder("receive", "dream_energy_core", 1, 2, true)
    .addEnergyPerTickInput(defaultTransferAmount)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val map = data.asMap();
        val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();
        if (!canReceive(map, speed, maxStoreSize, defaultTransferAmount)) {
            event.setFailed("内部能量存储已达到极限范围！");
            return;
        }
        ctrl.addModifier("receive", RecipeModifierBuilder.create("modularmachinery:energy", "input", speed, 1, false).build());
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();
        receiveEnergy(ctrl, data, map, speed, defaultTransferAmount);
    })
    .setParallelized(false)
    .addRecipeTooltip("由梦之释放者运行。", "在智能数据接口处修改速度。")
    .addSmartInterfaceDataInput("speed", minSpeed, maxSpeed)
    .setThreadName(inputThreadName)
    .build();

val alfheimPortalIngredients as IIngredient[IIngredient]$orderly = {
    <botania:livingwood>        : <botania:dreamwood>,
    <botania:storage:0> * 2     : <botania:storage:2>,
    <botania:storage:3>         : <botania:storage:4>,
    <botania:manaresource> * 2  : <botania:manaresource:7>,
    <botania:manaresource:1>    : <botania:manaresource:8>,
    <botania:manaresource:2>    : <botania:manaresource:9>,
    <minecraft:quartz>          : <botania:quartz:5>,
    <botania:managlass>         : <botania:elfglass>,
};

val alfheimPortalIngredientEnergyCost as int[IIngredient] = {
    <botania:livingwood>        : 500  * 100000,
    <botania:storage:0> * 2     : 4500 * 100000,
    <botania:storage:3>         : 9000 * 100000,
    <botania:manaresource> * 2  : 500  * 100000,
    <botania:manaresource:1>    : 500  * 100000,
    <botania:manaresource:2>    : 1000 * 100000,
    <minecraft:quartz>          : 500  * 100000,
    <botania:managlass>         : 500  * 100000,
};

# 精灵门配方
var recipeCounter = 3;
for input, output in alfheimPortalIngredients {
    val energyCost = alfheimPortalIngredientEnergyCost[input];

    RecipeBuilder.newBuilder("alfheim_portal_" + recipeCounter, "dream_energy_core", 5, recipeCounter, false)
        .addInput(input)
        .addOutput(output)
        .addPreCheckHandler(function(event as RecipeCheckEvent) {
            val ctrl = event.controller;

            if (!ctrl.hasMachineUpgrade("dream_void")) {
                event.setFailed("缺少升级： 模块化特化：源初造物丨梦幻虚空！");
                return;
            }

            val data = ctrl.customData;
            val dData = D(data);
            val energyStored = dData.getLong("energyStored", 0);

            //                               T      G      M      K
            if (energyStored < 1 as long * 100 * 1000 * 1000 * 1000 * 1000) {
                event.setFailed("内部能量储量不足！");
            }
        })
        .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
            val ctrl = event.controller;
            val thread = event.factoryRecipeThread;
            val data = ctrl.customData;
            val map = data.asMap();
            extractEnergy(ctrl, data, map, thread.activeRecipe.parallelism, energyCost);
        })
        .addRecipeTooltip("由梦之同步者运行。", "消耗 §a" + formatNumber(energyCost) + " RF §f内部能量存储。", "需要升级 §6源初造物丨梦幻虚空。")
        .setThreadName(fairyCraftingThreadName)
        .build();
    recipeCounter += 1;
}

# 盈能水晶
RecipeBuilder.newBuilder("energy_crystal_small", "dream_energy_core", 400, recipeCounter, false)
    .addInput(<ore:itemVibrantCrystal> * 16)
    .addOutput(<custommc:item929> * 1)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;

        if (!ctrl.hasMachineUpgrade("dream_void")) {
            event.setFailed("缺少升级： 模块化特化：源初造物丨梦幻虚空！");
            return;
        }
        val dData = D(ctrl.customData);
        val energyStored = dData.getLong("energyStored", 0);

        //                                T      G      M      K
        if (energyStored < 1 as long * 1000 * 1000 * 1000 * 1000 * 1000) {
            event.setFailed("内部能量储量不足！");
        }
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);
        //                                 P      T      G      M      K
        if (energyStored >= 1 as long * 500 * 1000 * 1000 * 1000 * 1000 * 1000) {
            thread.addModifier("duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.25, 1, false).build());
        }
        extractEnergy(ctrl, data, map, thread.activeRecipe.parallelism, 200 * 1000000);
    })
    .addRecipeTooltip("由梦之聚合者运行。", "消耗 §a" + formatNumber(200 * 1000000) + " RF §f内部能量存储。", "需要升级 §6源初造物丨梦幻虚空。")
    .setThreadName(manaCraftingThreadName)
    .build();
recipeCounter += 1;

# 盈能水晶块
RecipeBuilder.newBuilder("energy_crystal_large", "dream_energy_core", 1800, recipeCounter, false)
    .addInput(<custommc:item929> * 4)
    .addOutput(<custommc:item170> * 1)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;

        if (!ctrl.hasMachineUpgrade("dream_void")) {
            event.setFailed("缺少升级： 模块化特化：源初造物丨梦幻虚空！");
            return;
        }

        val data = ctrl.customData;
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);

        //                               P      T      G      M      K
        if (energyStored < 1 as long * 50 * 1000 * 1000 * 1000 * 1000 * 1000) {
            event.setFailed("内部能量储量不足！");
        }
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);
        //                                 P      T      G      M      K
        if (energyStored >= 1 as long * 500 * 1000 * 1000 * 1000 * 1000 * 1000) {
            thread.addModifier("duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.25, 1, false).build());
        }
        extractEnergy(ctrl, data, map, thread.activeRecipe.parallelism, 500 as long * 1000 * 1000 * 1000);
    })
    .addRecipeTooltip("由梦之聚合者运行。", "消耗 §a" + formatNumber(500 as long * 1000 * 1000 * 1000) + " RF §f内部能量存储。", "需要升级 §6源初造物丨梦幻虚空。")
    .setThreadName(manaCraftingThreadName)
    .build();
recipeCounter += 1;

# 注能魔力水晶（等级 1）
RecipeBuilder.newBuilder("energy_core_mana_crystal_v1", "dream_energy_core", 200, recipeCounter, false)
    .addInputs([
        <ebwizardry:magic_crystal> * 1,
    ])
    .addOutputs(<custommc:item794>)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;

        if (!ctrl.hasMachineUpgrade("dream_void")) {
            event.setFailed("缺少升级： 模块化特化：源初造物丨梦幻虚空！");
            return;
        }

        val data = ctrl.customData;
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);

        //                               P      T      G      M      K
        if (energyStored < 1 as long * 250 * 1000 * 1000 * 1000 * 1000 * 1000) {
            event.setFailed("内部能量储量不足！");
        }
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);
        //                                 P      T      G      M      K
        if (energyStored >= 1 as long * 500 * 1000 * 1000 * 1000 * 1000 * 1000) {
            thread.addModifier("duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.25, 1, false).build());
        }
        extractEnergy(ctrl, data, map, thread.activeRecipe.parallelism, 20 * 1000000);
    })
    .addRecipeTooltip("由梦之聚合者运行。", "消耗 §a" + formatNumber(20 * 1000000) + " RF §f内部能量存储。",  "需要升级 §6源初造物丨梦幻虚空。")
    .setThreadName(manaCraftingThreadName)
    .build();
recipeCounter += 1;

# 注能魔力水晶（等级 2）
RecipeBuilder.newBuilder("energy_core_mana_crystal_v2", "dream_energy_core", 400, recipeCounter, false)
    .addInputs([
        <custommc:item794> * 1,
        <ore:elvenDragonstone> * 1,
    ])
    .addOutputs(<custommc:item798>)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;

        if (!ctrl.hasMachineUpgrade("dream_void")) {
            event.setFailed("缺少升级： 模块化特化：源初造物丨梦幻虚空！");
            return;
        }

        val data = ctrl.customData;
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);

        //                               P      T      G      M      K
        if (energyStored < 1 as long * 250 * 1000 * 1000 * 1000 * 1000 * 1000) {
            event.setFailed("内部能量储量不足！");
        }
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);
        //                                 P      T      G      M      K
        if (energyStored >= 1 as long * 500 * 1000 * 1000 * 1000 * 1000 * 1000) {
            thread.addModifier("duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.25, 1, false).build());
        }
        extractEnergy(ctrl, data, map, thread.activeRecipe.parallelism, 200 * 1000000);
    })
    .addRecipeTooltip("由梦之聚合者运行。", "消耗 §a" + formatNumber(200 * 1000000) + " RF §f内部能量存储。",  "需要升级 §6源初造物丨梦幻虚空。")
    .setThreadName(manaCraftingThreadName)
    .build();
recipeCounter += 1;

# 注能魔力水晶（等级 3）
RecipeBuilder.newBuilder("energy_core_mana_crystal_v3", "dream_energy_core", 800, recipeCounter, false)
    .addInputs([
        <custommc:item798> * 1,
        <ore:eternalLifeEssence> * 1,
    ])
    .addOutputs(<custommc:item75>)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;

        if (!ctrl.hasMachineUpgrade("dream_void")) {
            event.setFailed("缺少升级： 模块化特化：源初造物丨梦幻虚空！");
            return;
        }

        val data = ctrl.customData;
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);

        //                               P      T      G      M      K
        if (energyStored < 1 as long * 250 * 1000 * 1000 * 1000 * 1000 * 1000) {
            event.setFailed("内部能量储量不足！");
        }
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val thread = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val energyStored = dData.getLong("energyStored", 0);
        //                                 P      T      G      M      K
        if (energyStored >= 1 as long * 500 * 1000 * 1000 * 1000 * 1000 * 1000) {
            thread.addModifier("duration", RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.25, 1, false).build());
        }
        extractEnergy(ctrl, data, map, thread.activeRecipe.parallelism, 1500 * 1000000);
    })
    .addRecipeTooltip("由梦之聚合者运行。", "消耗 §a" + formatNumber(1500 * 1000000) + " RF §f内部能量存储。",  "需要升级 §6源初造物丨梦幻虚空。")
    .setThreadName(manaCraftingThreadName)
    .build();
recipeCounter += 1;

/**
 * 向控制器添加或覆盖能量输入修改器。
 */
function addReceiveModifier(thread as FactoryRecipeThread, speed as float) {
    thread.addModifier("receive", RecipeModifierBuilder.create("modularmachinery:energy", "input", speed, 1, false).build());
}

/**
 * 向控制器添加或覆盖能量输出修改器。
 */
function addExtractModifier(thread as FactoryRecipeThread, speed as float) {
    thread.addModifier("extract", RecipeModifierBuilder.create("modularmachinery:energy", "output", speed, 1, false).build());
}

/**
 * 将智能数据接口的数据写入到 customData 中，方便客户端和配方读取。
 */
function writeSmartInterfaceDataToCustomData(event as MachineTickEvent, minSpeed as float, maxSpeed as float) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val map = data.asMap();
    val nullable = ctrl.getSmartInterfaceData("speed");
    var speed = isNull(nullable) ? 1 as float : nullable.value;

    //检查数据正确性
    if (speed < minSpeed || speed > maxSpeed) {
        nullable.value = 1;
    }

    map["speed"] = speed;
    ctrl.customData = data;
}

/**
 * 能否存储能量。
 */
function canReceive(map as IData[string], speed as float, maxStoreSize as long, defaultTransferAmount as long) as bool {
    val energyStored = isNull(map["energyStored"]) ? 0 as long : map["energyStored"].asLong();
    if (maxStoreSize - energyStored < speed * defaultTransferAmount) {
        return false;
    }
    return true;
}

/**
 * 能否提取能量。
 */
function canExtract(map as IData[string], speed as float, defaultTransferAmount as long) as bool {
    val energyStored = isNull(map["energyStored"]) ? 0 as long : map["energyStored"].asLong();
    if (energyStored < speed * defaultTransferAmount) {
        return false;
    }
    return true;
}

/**
 * 将能量存储进控制器内部。
 */
function receiveEnergy(ctrl as IMachineController, data as IData, map as IData[string], speed as float, defaultTransferAmount as long) {
    val energyStored = isNull(map["energyStored"]) ? 0 as long : map["energyStored"].asLong();

    map["energyStored"] = energyStored + (speed * defaultTransferAmount);
    ctrl.customData = data;
}

/**
 * 提取控制器内部能量至能量输出仓。
 */
function extractEnergy(ctrl as IMachineController, data as IData, map as IData[string], speed as float, defaultTransferAmount as long) {
    val energyStored  = isNull(map["energyStored"]) ? 0 as long : map["energyStored"].asLong();

    map["energyStored"] = energyStored - (speed * defaultTransferAmount);
    ctrl.customData = data;
}

/**
 * 格式化数值。
 * 例如 10000 = 10K, 100000000 = 100M。
 */
function formatNumber(value as long) as string {
    if (value < 1000) {
        return "" + value;
    } else if (value < 1000000) {
        return "" + (value / 1000) + "K";
    } else if (value < 1000000000) {
        return "" + ((value / 1000) as float / 1000) + "M";
    } else if (value < 1000000000000) {
        return "" + ((value / 1000000) as float / 1000) + "G";
    } else if (value < 1000000000000000) {
        return "" + ((value / 1000000000) as float / 1000) + "T";
    } else if (value < 1000000000000000000) {
        return "" + ((value / 1000000000000) as float / 1000) + "P";
    } else {
        return "" + ((value / 1000000000000000) as float / 1000) + "E";
    }
}