//Recipes By Hikari_Nova & Trigger.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;

import novaeng.hypernet.HyperNetHelper;

// 大型离子发生器
# 设置最大并行数
MachineModifier.setMaxParallelism("ion_generator", 64);

HyperNetHelper.proxyMachineForHyperNet("ion_generator");

# 控制器
RecipeBuilder.newBuilder("ion_generator_controller", "machine_arm", 1200)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 1,
        <ore:circuitUltimate> * 16,
        <contenttweaker:sensor_v1> * 12,
        <super_solar_panels:machines:25> * 4,
        <super_solar_panels:crafting:0> * 2,
        <super_solar_panels:crafting:13> * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:ion_generator_controller> * 1)
    .requireResearch("ion_generator")
    .build();

# 配方表
val ingredients as IIngredient[IIngredient]$orderly = {
    <ore:charcoal>                      : <minecraft:coal>,
    <ore:enderpearl>                    : <minecraft:ender_eye>,
    <ore:ingotTin>                      : <thermalfoundation:material:130>,
    <ore:woolYellow>                    : <minecraft:glowstone>,
    <ore:gemQuartz>                     : <appliedenergistics2:material>,
    <ore:ingotSteel>                    : <mets:titanium_ingot>,
    <ore:woolRed>                       : <minecraft:redstone_block>,
    <ore:woolBlue>                      : <minecraft:lapis_block>,
    <ore:ingotCopper>                   : <thermalfoundation:material:133>,
    <ic2:crafting:19>                   : <minecraft:diamond>,
    <ore:dustBlaze>                     : <thermalfoundation:material:1024>,
    <ore:dustObsidian>                  : <thermalfoundation:material:1027>,
    <ore:dustGlowstone>                 : <super_solar_panels:crafting:2>,
    <ore:ingotGold>                     : <thermalfoundation:material:134>,
    <minecraft:snowball>                : <thermalfoundation:material:1025>,
    <ore:coal>                          : <ic2:crafting:19>,
    <minecraft:glowstone>               : <super_solar_panels:crafting:1>,
    <ore:ingotIron>                     : <ic2:misc_resource:1>,
    <super_solar_panels:crafting:0>     : <super_solar_panels:crafting:52>,
    <minecraft:skull:1>                 : <minecraft:nether_star>,
    <contenttweaker:field_generator_v1> : <avaritia:endest_pearl>,
    <minecraft:skull:0>                 : <minecraft:skull:1>,
};

// *** long[IItemStack] = value[key] ***
val energyUsage as long[IIngredient] = {
    <ore:charcoal>                      : 50   * 1000,
    <ore:enderpearl>                    : 100  * 1000,
    <ore:ingotTin>                      : 500  * 1000,
    <ore:woolYellow>                    : 500  * 1000,
    <ore:gemQuartz>                     : 500  * 1000,
    <ore:ingotSteel>                    : 500  * 1000,
    <ore:woolRed>                       : 600  * 1000,
    <ore:woolBlue>                      : 700  * 1000,
    <ore:ingotCopper>                   : 750  * 1000,
    <ic2:crafting:19>                   : 1000 * 1000,
    <ore:dustBlaze>                     : 1.5  * 1000 * 1000,
    <ore:dustObsidian>                  : 1.75 * 1000 * 1000,
    <ore:dustGlowstone>                 : 2    * 1000 * 1000,
    <ore:ingotGold>                     : 2    * 1000 * 1000,
    <minecraft:snowball>                : 2    * 1000 * 1000,
    <ore:coal>                          : 9    * 1000 * 1000,
    <minecraft:glowstone>               : 18   * 1000 * 1000,
    <ore:ingotIron>                     : 25   * 1000 * 1000,
    <super_solar_panels:crafting:0>     : 75   * 1000 * 1000,
    <minecraft:skull:1>                 : 350  * 1000 * 1000,
    <contenttweaker:field_generator_v1> : 400  * 1000 * 1000,
    <minecraft:skull:0>                 : 1.25 * 1000 * 1000 * 1000,
};

var recipeCounter = 1;
for input, output in ingredients {
    RecipeBuilder.newBuilder("ion_generator_recipe_" + recipeCounter, "ion_generator", 5, recipeCounter, false)
        .addEnergyPerTickInput(energyUsage[input] / 5)
        .addInput(input)
        .addOutput(output)
        .requireComputationPoint(max(energyUsage[input] / 10000000.0F, 0.5F))
        .build();
    recipeCounter += 1;
}

function max(a as float, b as float) as float {
    return a >= b ? a : b;
}
