//Recipes By Hikari_Nova & Remilia.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.world.IWorld;
import crafttweaker.item.IItemStack;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.IngredientArrayBuilder;

import mods.modularmachinery.RecipeStartEvent;

import mods.modularmachinery.IMachineController;

import mods.modularmachinery.RecipeModifierBuilder;

//潮汐能发电机

val aquamarineModifier   = RecipeModifierBuilder.create("modularmachinery:energy", "output", 1.25, 1, false).build();
val dayTimeGenIncrease   = RecipeModifierBuilder.create("modularmachinery:energy", "output", 1.5, 1, false).build();
val nightTimeGenIncrease = RecipeModifierBuilder.create("modularmachinery:energy", "output", 2.0, 1, false).build();
val nightTimeGemAquamarineGenIncrease = RecipeModifierBuilder.create("modularmachinery:energy", "output", 3.0, 1, false).build();

# 控制器
RecipeBuilder.newBuilder("controller_tidal_generator", "workshop", 9600)
    .addEnergyPerTickInput(800000)
    .addItemInputs([
        <contenttweaker:industrial_circuit_v3> * 40,
        <contenttweaker:field_generator_v3> * 12,
        <ore:ingotFallenStarAlloy> * 20,
        <eternalsingularity:eternal_singularity> * 32,
        <astralsorcery:itemcraftingcomponent> * 60,
        <minecraft:prismarine:1> * 60,
    ])
    .addOutput(<modularmachinery:tidal_generator_controller> * 1)
    .requireComputationPoint(2700.0F)
    .requireResearch("tidal_generator")
    .build();

# 发电
RecipeBuilder.newBuilder("tidal_generator_gen", "tidal_generator", 100, 0, false)
    .addEnergyPerTickOutput(1500000000)
    .addCatalystInput(IngredientArrayBuilder.newBuilder()
        .addIngredients([<ore:gemAquamarine> * 10])
        .addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
            val worldTime = getWorldTime(ctrl.world);
            if (worldTime >= 12000 && worldTime <= 15000) {
                ctrl.addModifier("nightTimeAquamarineGen", nightTimeGemAquamarineGenIncrease);
            } else {
                ctrl.removeModifier("nightTimeAquamarineGen");
            }
            return item;
        }),
        ["海蓝宝石提供 §a1.25x§f 的发电加成。", "当时间处于 18:00 - 21:00 时，海蓝宝石还会叠加提供 §a3.0x§f 的发电加成。"],
        [aquamarineModifier]
    )
    .addStartHandler(function(event as RecipeStartEvent) {
        val ctrl = event.controller;
        val worldTime = getWorldTime(ctrl.world);
        if (worldTime >= 10 && worldTime <= 3000) {
            # 6:00 - 9:00 期间，发电量 x1.5
            ctrl.addModifier("dayTimeGen", dayTimeGenIncrease);
        } else if (worldTime >= 12000 && worldTime <= 15000) {
            # 18:00 - 21:00 期间，发电量 x2.0
            ctrl.addModifier("nightTimeGen", nightTimeGenIncrease);
        } else {
            ctrl.removeModifier("dayTimeGen");
            ctrl.removeModifier("nightTimeGen");
        }
    })
    .addRecipeTooltip("06:00 - 09:00 期间，发电量 §ax1.5§f。", "18:00 - 21:00 期间，发电量 §ax2.0§f。")
    .build();

function getWorldTime(world as IWorld) as int {
    return (world.provider.worldTime % 24000) as int;
}
