//Recipes By Hikari_Nova & Remilia.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.MachineModifier;

import novaeng.hypernet.HyperNetHelper;

val horologiumStellationPaper = <custommc:item129>.withTag({display: {Lore: ["§f诡异的§e时钟座§f隐藏在时间的各个角落中，无法§b以普通形式§f观测", "§f利用五大星座的星图作为线索，你成功观测到了§e时钟座。", "§f吸纳了§5奥力哈钢§f的§e时钟座§6星图§f有着超越时间的力量，任何以它指引的星能机器将§b不分昼夜的运行。"], Name: "§e时钟座§6星图"}});
val monocerosStellationPaper = <custommc:item833>.withTag({display: {Lore: ["§d麒麟座§f只会在§b新月§f出现。", "§f机敏的§d麒麟§f遨游宇宙，所有§9天体§f尽收眼底。", "§d相位§f引星塔需此星图从§9无垠宇宙中§f牵引§8陨石§f与§8陨铁§f。"], Name: "§d麒麟座§f星图"}});

// 相位引星塔
HyperNetHelper.proxyMachineForHyperNet("phase_planet_traction_tower");
MachineModifier.setMaxThreads("phase_planet_traction_tower", 16);

// 控制器
RecipeBuilder.newBuilder("phase_planet_traction_tower_controller", "machine_arm", 7200)
    .addEnergyPerTickInput(720000)
    .addInputs([
        <appliedenergistics2:sky_compass> * 7,
        <contenttweaker:exponential_level_processor> * 11,
        <contenttweaker:coil_v3> * 2,
        <gravisuite:crafting:4> * 16,
        <ore:blockElectricalSteel> * 7,
        <ore:blockSkyStone> * 60,
        <ore:blockObsidiorite> * 60,
        <modularmachinery:blockcasing> * 1,
    ])
    .addOutput(<modularmachinery:phase_planet_traction_tower_controller>)
    .requireResearch("phase_planet_traction_tower")
    .build();
RecipeBuilder.newBuilder("phase_planet_traction_tower_factory_controller", "workshop", 7200)
    .addEnergyPerTickInput(10240000)
    .addInputs([
        <modularmachinery:phase_planet_traction_tower_controller> * 4,
        <contenttweaker:industrial_circuit_v3> * 12,
        <moreplates:infinity_plate> * 1,
        <tconevo:metal:13> * 4,
        <tconevo:metal:8> * 16,
        <contenttweaker:yunshi> * 8
    ])
    .addOutputs(<modularmachinery:phase_planet_traction_tower_factory_controller> * 1)
    .requireResearch("phase_planet_traction_tower")
    .build();

RecipeBuilder.newBuilder("tower_working", "phase_planet_traction_tower", 5760)
    .addEnergyPerTickInput(160000)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        if (ctrl.pos.y < 200) {
            event.setFailed("只能在海拔 200 格以上的高度工作！");
        }
        val world = ctrl.world;
        if (world.isDayTime()) {
            event.setFailed("在没有时钟座星图的情况下只能在夜间工作！");
        }
    })
    .addInput(monocerosStellationPaper).setChance(0)
    .addInput(<extendedcrafting:material:40> * 1).setChance(0.12).setPreViewNBT({
        display: { Lore: ["§3末影类§f物质的特性，使引星塔检索§9浩瀚宇宙§f，定位§8天外陨石§f。"] }
    })
    .addOutput(<appliedenergistics2:sky_stone_block> * 42)
    .addOutput(<appliedenergistics2:sky_stone_block> * 19).setChance(0.42)
    .addOutput(<appliedenergistics2:sky_stone_block> * 9).setChance(0.21)
    .addOutput(<taiga:obsidiorite_block> * 9)
    .addOutput(<taiga:obsidiorite_block> * 5).setChance(0.42)
    .addOutput(<taiga:obsidiorite_block> * 2).setChance(0.21)
    .addRecipeTooltip("只能在§b夜间§f，并且在海拔 §a200§f 格以上的高度工作。")
    .requireComputationPoint(12.0F)
    .build();

RecipeBuilder.newBuilder("tower_working_horologium", "phase_planet_traction_tower", 5760)
    .addEnergyPerTickInput(160000)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        if (ctrl.pos.y < 200) {
            event.setFailed("只能在海拔 200 格以上的高度工作！");
        }
    })
    .addInput(horologiumStellationPaper).setChance(0)
    .addInput(monocerosStellationPaper).setChance(0)
    .addInput(<extendedcrafting:material:40> * 1).setChance(0.12).setPreViewNBT({
        display: { Lore: ["§3末影类§f物质的特性，使引星塔检索§9浩瀚宇宙§f，定位§8天外陨石§f。"] }
    })
    .addOutput(<appliedenergistics2:sky_stone_block> * 42)
    .addOutput(<appliedenergistics2:sky_stone_block> * 19).setChance(0.42)
    .addOutput(<appliedenergistics2:sky_stone_block> * 9).setChance(0.21)
    .addOutput(<taiga:obsidiorite_block> * 9)
    .addOutput(<taiga:obsidiorite_block> * 5).setChance(0.42)
    .addOutput(<taiga:obsidiorite_block> * 2).setChance(0.21)
    .addRecipeTooltip("只能在海拔 §a200§f 格以上的高度工作。")
    .requireComputationPoint(12.0F)
    .build();
