import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.IngredientArrayBuilder;
import mods.modularmachinery.IngredientArrayPrimer;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import crafttweaker.item.IItemStack;

//==============================相位灌注机==============================
// 并行线程数设置
MachineModifier.setMaxThreads("phaseinsolator",10);
MachineModifier.setInternalParallelism("phaseinsolator",311);

//相位灌注机：配方继承
//星图
val sz = <custommc:item129>.withTag({display: {Lore: ["§f诡异的§e时钟座§f隐藏在时间的各个角落中，无法§b以普通形式§f观测", "§f利用五大星座的星图作为线索，你成功观测到了§e时钟座。", "§f吸纳了§5奥力哈钢§f的§e时钟座§6星图§f有着超越时间的力量，任何以它指引的星能机器将§b不分昼夜的运行。"], Name: "§e时钟座§6星图"}});
val mf = <custommc:item833>.withTag({display: {Lore: ["§f只在§b残月§f和§b峨眉月§f时可被观测到的§a牧夫座", "§f天上的§a牧人§f不知疲倦的照料着芸芸众生。", "§b相位灌注机§f需此星图以§a滋养动物与植物。"], Name: "§a牧夫座§f星图"}});
//时间减半
val items = RecipeModifierBuilder.create("modularmachinery:item", "Output",0,0, false).build();
val flch = IngredientArrayBuilder.newBuilder().addIngredients([<thermalfoundation:fertilizer> * 3,<thermalfoundation:fertilizer:1> * 2,<thermalfoundation:fertilizer:2> * 1]);
//时钟座判定
val szxt = IngredientArrayBuilder.newBuilder().addIngredients([sz]);
val times = RecipeModifierBuilder.create("modularmachinery:duration", "input",0,0, false).build();
recipes.addShapeless(<modularmachinery:phaseinsolator_factory_controller>,[<modularmachinery:phaseinsolator_controller>]);

RecipeAdapterBuilder.create("phaseinsolator", "thermalexpansion:insolator_tree")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input",0.09, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy","input",19980,0, false).build())
    .addCatalystInput(flch.setChecker(function(ctrl as IMachineController, item as IItemStack) {
            val data = ctrl.customData;
            val map = data.asMap();
            map["bxsx"] = 32;
            ctrl.customData = data;
            return true;
        }),["输入肥料时，允许并行，并且所有产出乘3"], [items]).setChance(1).setParallelizeUnaffected(false)
    .addCatalystInput(szxt.setChecker(function(ctrl as IMachineController, item as IItemStack) {
            val data = ctrl.customData;
            val map = data.asMap();
            map["sfsz"] = 1;
            ctrl.customData = data;
            return true;
        }),["放入时钟座星图，将允许在白天工作"], [times]).setChance(0).setParallelizeUnaffected(true)
    .addItemInputs(mf).setChance(0).setParallelizeUnaffected(true)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val bxsx = Ddata.getInt("bxsx",1);
        event.activeRecipe.maxParallelism = bxsx;
    })
    .addPostCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val sfsz = Ddata.getInt("sfsz",0);
        if (sfsz != 1) {
            if(ctrl.world.isDayTime()){
                event.setFailed("§4白天，且没有时钟座星图");
                return;
            }
        }
    })
    .addFactoryStartHandler(function (event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val map = data.asMap();
        val bxsx = Ddata.getInt("bxsx",1);
        val bl = event.factoryRecipeThread;
        if(bxsx != 1){
            bl.addPermanentModifier("fbcc", RecipeModifierBuilder.create("modularmachinery:item", "Output",3,1, false).build());
        }

        map["sfsz"] = 0;
        map["bxsx"] = 1;
        ctrl.customData = data;
    })
    .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent){
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val sfsz = Ddata.getInt("sfsz",0);
        
        if (sfsz != 1) {
            if(ctrl.world.isDayTime()){
                event.preventProgressing("§4白天，且没有时钟座星图");
                return;
            }
        }
    })
    .setMaxThreads(1)
    .build();
RecipeAdapterBuilder.create("phaseinsolator", "thermalexpansion:insolator")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input",0.09, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy","input",19980,0, false).build())
    .addCatalystInput(flch.setChecker(function(ctrl as IMachineController, item as IItemStack) {
            val data = ctrl.customData;
            val map = data.asMap();
            map["bxsx"] = 32;
            ctrl.customData = data;
            return true;
        }),["输入肥料时，允许并行，并且时间减半"], [items]).setChance(1).setParallelizeUnaffected(false)
    .addCatalystInput(szxt.setChecker(function(ctrl as IMachineController, item as IItemStack) {
            val data = ctrl.customData;
            val map = data.asMap();
            map["sfsz"] = 1;
            ctrl.customData = data;
            return true;
        }),["放入时钟座星图，将允许在白天工作"], [times]).setChance(0).setParallelizeUnaffected(true)
    .addItemInputs(mf).setChance(0).setParallelizeUnaffected(true)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val bxsx = Ddata.getInt("bxsx",1);
        event.activeRecipe.maxParallelism = bxsx;
    })
    .addPostCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val sfsz = Ddata.getInt("sfsz",0);
        if (sfsz != 1) {
            if(ctrl.world.isDayTime()){
                event.setFailed("§4白天，且没有时钟座星图");
                return;
            }
        }
    })
    .addFactoryStartHandler(function (event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val map = data.asMap();
        val bxsx = Ddata.getInt("bxsx",1);
        val bl = event.factoryRecipeThread;
        if(bxsx != 1){
            bl.addPermanentModifier("fbcc", RecipeModifierBuilder.create("modularmachinery:item", "Output",3,1, false).build());
        }

        map["sfsz"] = 0;
        map["bxsx"] = 1;
        ctrl.customData = data;
    })
    .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent){
        val ctrl = event.controller;
        val data = ctrl.customData;
        val Ddata = D(data);
        val sfsz = Ddata.getInt("sfsz",0);
        
        if (sfsz != 1) {
            if(ctrl.world.isDayTime()){
                event.preventProgressing("§4白天，且没有时钟座星图");
                return;
            }
        }
    })
    .setMaxThreads(1)
    .build();