//Recipes By Hikari_Nova & Remilia.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.RecipeModifierBuilder;

import novaeng.hypernet.HyperNetHelper;

// 中子素吸积盘
MachineModifier.setMaxThreads("neutron_accretion_plate", 16);
// 控制器
RecipeBuilder.newBuilder("neutron_accretion_plate_controller", "machine_arm", 3600)
    .addEnergyPerTickInput(1024000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 12,
        <avaritia:neutron_collector> * 16,
        <mets:niobium_titanium_plate> * 64,
        <mets:niobium_titanium_plate> * 64,
        <mets:neutron_plate> * 48,
        <mets:super_iridium_compress_plate> * 8,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:neutron_accretion_plate_controller> * 1)
    .requireResearch("neutron_accretion_plate")
    .build();
RecipeBuilder.newBuilder("neutron_accretion_plate_factory_controller", "workshop", 7200)
    .addEnergyPerTickInput(10240000)
    .addInputs([
        <modularmachinery:neutron_accretion_plate_controller> * 8,
        <contenttweaker:industrial_circuit_v3> * 12,
        <moreplates:infinity_plate> * 1,
        <tconevo:metal:13> * 4,
        <tconevo:metal:8> * 16,
        <ore:plateCosmicNeutronium> * 64,
    ])
    .addOutputs(<modularmachinery:neutron_accretion_plate_factory_controller> * 1)
    .requireResearch("neutron_accretion_plate")
    .build();

RecipeBuilder.newBuilder("neutron_accretion_plate_working", "neutron_accretion_plate", 30)
    .addStartHandler(function(event as RecipeStartEvent) {
        val ctrl = event.controller;
        val yPos = ctrl.pos.y;
        if (yPos > 230) {
            ctrl.addModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:item", "output", 2, 1, false).build());
        } else if (yPos > 200) {
            ctrl.addModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:item", "output", 1.75, 1, false).build());
        } else if (yPos > 150) {
            ctrl.addModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:item", "output", 1.5, 1, false).build());
        } else if (yPos > 100) {
            ctrl.addModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:item", "output", 1.25, 1, false).build());
        }
    })
    .addOutput(<avaritia:resource:2>).setMinMaxAmount(1, 4)
    .addRecipeTooltip([
        "控制器高度大于 §b230§f 时，尘埃产出 §ax2§f。",
        "控制器高度大于 §b200§f 时，尘埃产出 §ax1.75§f。",
        "控制器高度大于 §b150§f 时，尘埃产出 §ax1.5§f。",
        "控制器高度大于 §b100§f 时，尘埃产出 §ax1.25§f。",
    ])
    .build();
