#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.FactoryRecipeThread;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import novaeng.hypernet.HyperNetHelper;
import crafttweaker.item.IItemStack;
import crafttweaker.liquid.ILiquidStack;
import crafttweaker.util.Math;
import crafttweaker.item.IIngredient;

var jsq = 0;
//线程设置
    MachineModifier.setMaxThreads("molten_casting", 0);
    MachineModifier.addCoreThread("molten_casting", FactoryRecipeThread.createCoreThread("温度控制核心"));
    MachineModifier.addCoreThread("molten_casting", FactoryRecipeThread.createCoreThread("合金熔炼铸造"));
    MachineModifier.addCoreThread("molten_casting", FactoryRecipeThread.createCoreThread("冷却模块"));
    MachineModifier.setInternalParallelism("molten_casting", 256);
# 铸造枢纽 - 控制器
    RecipeBuilder.newBuilder("molten_casting", "machine_arm", 1200)
        .addEnergyPerTickInput(96000)
        .addInputs([
            <contenttweaker:industrial_circuit_v1> * 8,
            <contenttweaker:electric_motor_v2> * 16,
            <contenttweaker:sensor_v1> * 16,
            <enderio:item_liquid_conduit:2> * 16,
            <thermalexpansion:augment:304> * 64,
            <tconstruct:smeltery_controller> * 1,
            <modularmachinery:blockcasing>,
        ])
        .addOutput(<modularmachinery:molten_casting_factory_controller>)
        .requireResearch("large_metallurgical_complex")
        .build();
//未提供流体降温
    MMEvents.onMachinePostTick("molten_casting", function(event as MachineTickEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val temperature = dData.getFloat("temperature",299.0);
        val gzzt = dData.getInt("gzzt",0);
        val map = data.asMap();
        val temperaturel = dData.getFloat("temperaturel",300.0);
            if(gzzt != 1){
                if (gzzt == 2){
                    if (temperaturel - 20.0f < 300){
                        map["temperaturel"] = 300.0f;
                    } else {
                        map["temperaturel"] = temperature - 20.0f;
                    }
                } else if (gzzt == 0) {
                    map["gzzt"] = 2;
                    ctrl.customData = data;
                }
            }
        if(map["temperaturel"] != temperature){
            map["temperature"] = map["temperaturel"];
            map["temperaturel"] = map["temperaturel"];
            ctrl.customData = data;
        }
    });
//GUI
    MMEvents.onControllerGUIRender("molten_casting", function(event as ControllerGUIRenderEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val temperature = dData.getFloat("temperature",300.0);
        var info as string[] = [
            "§a当前温度:§6" + temperature + "§aK",
            "",
            "§a允许使用熔岩，炽焱，硝化合金，等离子体进行加热",
            "§a分别可以达到的最高温度为2000K,4000K,6000K,10000K",
            "§a达到最高温度后将以10%的流体消耗速度运行",
            "§a低于配方需求温度时，耗电提高9倍，高于需求温度1000k，将会只消耗0.1倍的电",
            "",
            "§a温度每高于配方需求1000k后，每70k,将会提高1个并行",
            "§a缺失流体时，温度会以一个极快的速度下降",
            "§a温度低于配方所需温度1000K以上，将会罢工"
        ];
        event.extraInfo = info;
    });
//温度控制核心
    function ltsw(liquid as ILiquidStack,wdjx as float,swsd as float){
        RecipeBuilder.newBuilder("ltsw" + liquid.name, "molten_casting",1000,90000,true)
            .addFluidPerTickInput(liquid * 10)
            .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val map = data.asMap();
                
                map["gzzt"] = 1;
                ctrl.customData = data;
            })
            .addFactoryPostTickHandler(function(event as FactoryRecipeTickEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val bl = event.factoryRecipeThread;
                val dData = D(data);
                val map = data.asMap();
                val temperature = dData.getFloat("temperature",300.0);
                val wdzt = dData.getInt("wdzt",0);
                val temperaturel = dData.getFloat("temperaturel",300.0);
                    if (temperaturel >= wdjx){
                        if (temperaturel >= (wdjx + 3100)){
                            map["temperaturel"] = temperaturel - 2.5f;
                        } else if (temperaturel >= (wdjx + 2100)){
                            map["temperaturel"] = temperaturel - 2.0f;
                        } else if (temperaturel >= (wdjx + 1100)){
                            map["temperaturel"] = temperaturel - 1.5f;
                        } else if (temperaturel >= (wdjx + 100)){
                            map["temperaturel"] = temperaturel - 1.0f;
                        }
                    }
                    if (temperaturel < wdjx){
                        map["temperaturel"] = temperaturel + swsd;
                    }
                if(map["temperaturel"] != temperature){
                    map["temperature"] = temperaturel;
                    if (map["temperaturel"] >= wdjx){
                        bl.addPermanentModifier("typeMultiplier1", RecipeModifierBuilder.create("modularmachinery:fluid", "input",0.1,1, false).build());
                    }
                    if (map["temperaturel"] < wdjx){
                        bl.removePermanentModifier("typeMultiplier1");
                    }
                    ctrl.customData = data;
                }
            })
            .addRecipeTooltip("§6可以以§a" + swsd + "K/t§6的速度升温到§a" + wdjx + "K§6左右")
            .setParallelized(false)
            .setThreadName("温度控制核心")
        .build();
    }
    ltsw(<liquid:lava>,2000.0,2.5);
    ltsw(<liquid:pyrotheum>,4000.0,5);
    ltsw(<liquid:nitronite_fluid>,6000.0,7.5);
    ltsw(<liquid:plasma>,10000.0,10);
    //开始降温
        RecipeBuilder.newBuilder("ltjw", "molten_casting",1,9999999)
            .addPreCheckHandler(function(event as RecipeCheckEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val gzzt = dData.getInt("gzzt",0);

                if (gzzt != 1) {
                    event.setFailed("已在降温");
                    return;
                }
            })
            .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val map = data.asMap();
                map["gzzt"] = 0;
                ctrl.customData = data;
            })
            .addRecipeTooltip("未输入流体的情况下将会降温")
            .setParallelized(false)
            .setThreadName("温度控制核心")
        .build();
//合金熔炼铸造
    function rlzz(item as IIngredient[],output as IIngredient,wdxq as float,jsq as int){
        RecipeBuilder.newBuilder("rlzz" + jsq, "molten_casting",40)
            .addEnergyPerTickInput(1000000)
            .addInputs(item)
            .addPreCheckHandler(function(event as RecipeCheckEvent){
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val temperature = dData.getFloat("temperature",300.0);
                var bx = 1;
                if (temperature - wdxq > 1000){
                    bx += Math.max((temperature - wdxq - 1000.0f)/70.0f,0.0f);
                }
                event.activeRecipe.maxParallelism = bx;
                if (temperature < (wdxq - 1000)) {
                    event.setFailed("温度过低，无法运行");
                    return;
                }
            })
            .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val bl = event.factoryRecipeThread;
                val dData = D(data);
                val temperature = dData.getFloat("temperature",300.0);

                if (temperature - wdxq > 1000){
                    bl.addModifier("typeenergy1", RecipeModifierBuilder.create("modularmachinery:energy", "input",0.1,1, false).build());
                }
                if (temperature < wdxq){
                    bl.addModifier("typeenergy2", RecipeModifierBuilder.create("modularmachinery:energy", "input",10,1, false).build());
                }
            })
            .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
                val crtl = event.controller;
                val tick = event.factoryRecipeThread.activeRecipe.tick as float;
                val totalTick = event.factoryRecipeThread.activeRecipe.totalTick as float;
                val data = crtl.customData;
                val dData = D(data);
                val lqzt = dData.getInt("lqzt" , 0);

                if(tick >= (totalTick * 0.7) && lqzt == 0){
                    event.preventProgressing("§a熔炼完成，可开始冷却");
                    data.asMap()["kflq"] = 1;
                    crtl.customData = data;
                }
            })
            .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val map = data.asMap();
                val temperaturel = dData.getFloat("temperaturel",300.0);
                val temperature = dData.getFloat("temperature",300.0);

                val temperature1 = temperature * 0.005f;
                map["temperaturel"] = temperaturel - temperature1;
                map["lqzt"] = 0;

                ctrl.customData = data;
            })
            .addOutput(output)
            .addRecipeTooltip("§a每次运行后会损失当前热量的0.5%")
            .addRecipeTooltip("§6需求温度为" + wdxq)
            .addRecipeTooltip("§6每次配方进度抵达70%进入冷却状态","§6可以使用水，碎冰或凛冰进行冷却","§6冷却完成后方可正常运行")
            .setThreadName("合金熔炼铸造")
        .build();
    }
    rlzz([<taiga:eezo_ingot> * 2,<taiga:abyssum_ingot> * 2,<taiga:osram_ingot> * 2,<taiga:obsidiorite_ingot> * 9],<taiga:iox_ingot>,2000.0,jsq);jsq += 1;//离金锭
    rlzz([<taiga:eezo_ingot> * 4,<taiga:abyssum_ingot> * 4,<taiga:osram_ingot> * 4,<ore:obsidian> * 9,<taiga:meteorite_ingot> * 18],<taiga:iox_ingot>,2000.0,jsq);jsq += 1;//离金锭
    rlzz([<taiga:prometheum_ingot> * 3, <taiga:palladium_ingot> * 3,<taiga:eezo_ingot>], <taiga:proxii_ingot> * 3, 4000.0, jsq); jsq += 1; // 普罗克希锭
    rlzz([<taiga:terrax_ingot> * 3, <taiga:aurorium_ingot> * 2], <taiga:astrium_ingot> * 2, 2000.0, jsq); jsq += 1; // 曜金锭
    rlzz([<taiga:proxii_ingot> * 3, <taiga:abyssum_ingot>, <taiga:osram_ingot>], <taiga:nucleum_ingot> * 3, 4000.0, jsq); jsq += 1; // 辐光合金锭
    rlzz([<taiga:imperomite_ingot> * 3, <taiga:osram_ingot>, <taiga:eezo_ingot>], <taiga:nucleum_ingot> * 3.0,4000.0, jsq); jsq += 1; // 辐光合金锭
    rlzz([<taiga:niob_ingot> * 3, <taiga:eezo_ingot>, <taiga:abyssum_ingot>], <taiga:nucleum_ingot> * 3, 4000.0, jsq); jsq += 1; // 辐光合金锭
    rlzz([<taiga:tiberium_ingot> * 5, <taiga:basalt_ingot>], <taiga:triberium_ingot>, 3000.0, jsq); jsq += 1; // 泰伯利安
    rlzz([<taiga:tiberium_ingot> * 5, <taiga:dilithium_ingot> * 2], <taiga:triberium_ingot>, 3000.0, jsq); jsq += 1; // 泰伯利安
    rlzz([<tconstruct:ingots:1> * 2, <taiga:terrax_ingot> * 2, <taiga:osram_ingot>], <taiga:ignitz_ingot> * 2, 4000.0, jsq); jsq += 1; // 焰晶锭
    rlzz([<taiga:karmesine_ingot>, <taiga:ovium_ingot>, <taiga:jauxum_ingot>], <taiga:terrax_ingot> * 2, 4000.0, jsq); jsq += 1; // 地母锭
    rlzz([<taiga:duranite_ingot> * 3, <taiga:prometheum_ingot>, <taiga:abyssum_ingot>], <taiga:imperomite_ingot> * 2, 4000.0, jsq); jsq += 1; // 帝金锭
    rlzz([<taiga:iox_ingot> * 3, <taiga:solarium_ingot>, <taiga:vibranium_ingot>], <taiga:adamant_ingot> * 3, 7000.0, jsq); jsq += 1; // 铿金锭
    rlzz([<taiga:iox_ingot> * 3, <taiga:nihilite_ingot> * 2], <taiga:adamant_ingot> * 3, 7000.0, jsq); jsq += 1; // 铿金锭
    rlzz([<taiga:palladium_ingot>, <taiga:terrax_ingot>], <taiga:lumix_ingot>, 4000.0, jsq); jsq += 1; // 流光合金锭
    rlzz([<taiga:palladium_ingot> * 3, <taiga:duranite_ingot>, <taiga:osram_ingot>], <taiga:niob_ingot> * 3, 3000.0, jsq); jsq += 1; // 铌锭
    rlzz([<taiga:triberium_ingot> * 6, <ore:obsidian> * 3, <taiga:abyssum_ingot> * 2], <taiga:fractum_ingot> * 4, 5000.0, jsq); jsq += 1; // 碎金锭
    rlzz([<taiga:valyrium_ingot> * 2, <taiga:uru_ingot> * 2, <taiga:nucleum_ingot> * 1], <taiga:solarium_ingot> * 2, 2000.0, jsq); jsq += 1; // 阳光合金锭
    rlzz([<tconstruct:ingots> * 3, <taiga:terrax_ingot> * 2], <taiga:tritonite_ingot> * 2, 2000.0, jsq); jsq += 1; // 漩金锭
    rlzz([<taiga:triberium_ingot> * 3, <taiga:fractum_ingot>, <taiga:seismum_ingot>, <taiga:osram_ingot>], <taiga:dyonite_ingot> * 3, 4000.0, jsq); jsq += 1; // 烈金锭
    rlzz([<taiga:tiberium_ingot> * 12, <taiga:fractum_ingot>, <taiga:seismum_ingot>, <taiga:osram_ingot>], <taiga:dyonite_ingot> * 3, 4000.0, jsq); jsq += 1; // 烈金锭
    rlzz([<ore:obsidian> * 2, <taiga:triberium_ingot> * 2, <taiga:eezo_ingot>], <taiga:seismum_ingot> * 4, 3000.0, jsq); jsq += 1; // 地动合金锭
    rlzz([<taiga:uru_ingot> * 3, <taiga:valyrium_ingot> * 3, <taiga:osram_ingot>], <taiga:yrdeen_ingot> * 3, 3000.0, jsq); jsq += 1; // 原金锭
    rlzz([<taiga:uru_ingot> * 3, <taiga:valyrium_ingot> * 3, <taiga:eezo_ingot>], <taiga:yrdeen_ingot> * 3, 3000.0, jsq); jsq += 1; // 原金锭
    rlzz([<taiga:uru_ingot> * 3, <taiga:valyrium_ingot> * 3, <taiga:abyssum_ingot>], <taiga:yrdeen_ingot> * 3, 3000.0, jsq); jsq += 1; // 原金锭
    rlzz([<taiga:aurorium_ingot> * 3, <tconstruct:ingots:1> * 2], <taiga:violium_ingot> * 2, 3000.0, jsq); jsq += 1; // 瑟蓝锭
    rlzz([<taiga:vibranium_ingot>, <taiga:solarium_ingot>], <taiga:nihilite_ingot>, 5000.0, jsq); jsq += 1; // 虚金
    rlzz([<tconevo:material>, <liquid:ic2uu_matter> * 72], <tconevo:metal:40>, 3000.0, jsq); jsq += 1; // UU金属
    rlzz([<tconevo:material>, <ic2:dust:6> * 3], <tconevo:metal:35>, 3000.0, jsq); jsq += 1; // 能量锭
    rlzz([<ore:ingotManasteel> * 2,<ore:ingotDraconium> * 2,<ore:ingotCrystallineAlloy> * 6,<ore:ingotOsmium>,<ore:ingotGold>,<ore:ingotIron>,<ore:ingotCopper>,<ore:ingotTin>], <ore:ingotAlloyT1> * 2, 2000.0, jsq); jsq += 1; // 基础通用合金
    rlzz([<ore:ingotAlloyT1>,<ore:ingotCrystallineAlloy> * 8,<thermalfoundation:material:134> * 12],<ore:ingotBlueAlloy> * 6, 2000.0, jsq); jsq += 1; // 蓝晶合金
    rlzz([<ore:ingotTinSilver> * 4,<ore:dustRedstone> * 8,<ore:ingotBoron> * 2],<modularmachinery:itemmodularium> * 6, 2000.0, jsq); jsq += 1; // 模块化合金
    rlzz([<ore:oreClathrateEnder>*16],<minecraft:ender_pearl> * 64, 1000.0, jsq); jsq += 1; // 末影珍珠
    rlzz([<ore:clathrateEnder>*16],<minecraft:ender_pearl>*16, 500.0, jsq); jsq += 1; // 末影珍珠
    rlzz([<ore:dustCoal>,<ore:dustFluix>,<ore:ingotIron>],<ore:ingotFluixSteel>, 2000.0, jsq); jsq += 1;//福鲁伊克斯钢

//冷却模块
    function lqmk(liquid as ILiquidStack,time as int){
        RecipeBuilder.newBuilder("lqmk" + liquid.name, "molten_casting",time)
            .addFluidInput(liquid * 1000)
            .addPreCheckHandler(function(event as RecipeCheckEvent){
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val kflq = dData.getInt("kflq" , 0);
                if (kflq == 0){
                    event.setFailed("§a当前不需要冷却");
                    return;
                }
            })
            .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val temperature = dData.getFloat("temperature",300.0);

                val temperature1 = temperature * 0.005f;
                data.asMap()["temperature"] = temperature - temperature1;
                data.asMap()["lqzt"] = 1;
                data.asMap()["kflq"] = 0;

                ctrl.customData = data;
            })
            .addRecipeTooltip("§6可以在" + time + "t内冷却完毕")
            .addRecipeTooltip("§6不会因为单次并行的合金数量而增加需求")
            .setParallelized(false)
            .setThreadName("冷却模块")
        .build();
    }
    lqmk(<liquid:water>,100);
    lqmk(<liquid:ice>,50);
    lqmk(<liquid:cryotheum>,5);