//Recipes By Hikari_Nova.
//Machinery By nxc_in_china
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

// 高温熔化工厂
RecipeAdapterBuilder.create("high_temp_melting_factory", "nuclearcraft:melter")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.05, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy", "input", 1000, 1, false).build())
    .build();

MachineModifier.setMaxParallelism("high_temp_melting_factory",256);

// 高温熔化工厂 —— 控制器
RecipeBuilder.newBuilder("high_temp_melting_factory_controller", "mach_crafter", 1200)
    .addEnergyPerTickInput(2048)
    .addInputs([
        <contenttweaker:industrial_circuit_v1> * 12,
        <nuclearcraft:melter> * 4,
        <ic2:containment_plating> * 8,
        <contenttweaker:coil_v2> * 24,
        <nuclearcraft:alloy:11> * 16,
        <modularmachinery:blockcasing>,
    ])
    .addOutput(<modularmachinery:high_temp_melting_factory_controller>)
    .requireResearch("high_temp_melting_factory")
    .build();

// 高温熔化工厂：温度系统（等同于相位炼化棱镜）
// 加热时能量消耗 +250kRF/t
val heating = RecipeModifierBuilder.create("modularmachinery:energy", "input", 5, 1, false).build();

MMEvents.onMachinePostTick("high_temp_melting_factory", function(event as MachineTickEvent) {
    val controller = event.controller;
    val data = controller.customData;
    val map = data.asMap();

    val machineTemp = isNull(data.temperature) ? 300.0F : data.temperature as float;
    val newTemp = machineTemp + (controller.isWorking ? increaseTemperature(machineTemp) : -decreaseTemperature(machineTemp));
    if (newTemp != machineTemp) {
        data.memberSet("temperature", newTemp);
        controller.customData = data;
        val modifier as float = min(1500 as float / machineTemp, 2.5);
        controller.addPermanentModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:duration", "input", modifier, 1, false).build());
    }
});

MMEvents.onControllerGUIRender("high_temp_melting_factory", function(event as ControllerGUIRenderEvent) {
    val controller = event.controller;
    val data = controller.customData;
    val machineTemp = isNull(data.temperature) ? 300.0F : data.temperature as float;
    val modifier as float = min(1500 as float / machineTemp, 2.5) * 100;
    var info as string[] = [
        "§e炉心温度：§c" + (((machineTemp * 10) as int) as float) / 10 + "K",
        "§e烧制时间乘数：" + (modifier >= 100 ? "§c" : "§a") + (((modifier * 100) as int) as float) / 100 + "%",
    ];
    if (machineTemp <= 1500) {
        info += machineTemp <= 1000 ? "§e警告：温度偏低。" : "§e警告：温度过低。";
    }

    event.extraInfo = info;
});

function min(a as float, b as float) as float {
    return a <= b ? a : b;
}

function max(a as float, b as float) as float {
    return a >= b ? a : b;
}

function increaseTemperature(temperature as float) as float {
    if (temperature >= 10000) {
        return 0 as float;
    } else if (temperature >= 7000) {
        return 1.25 as float;
    } else if (temperature >= 3500) {
        return 2.5 as float;
    } else {
        return 5 as float;
    }
}

function decreaseTemperature(temperature as float) as float {
    if (temperature >= 7500) {
        return 3 as float;
    } else if (temperature >= 5000) {
        return 1.5 as float;
    } else if (temperature >= 300) {
        return 0.5 as float;
    } else {
        return 0 as float;
    }
}