#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.research.ResearchCognitionData;

MachineModifier.setMaxThreads("fluix", 6);
MachineModifier.setInternalParallelism("fluix",32);

//研究
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("fluix_factory", "ME改进档案",
        <appliedenergistics2:quartz_growth_accelerator>,    // 预览物品
        7.3,                                 // 科技等级（难度）
        (145 * 20 * 60 * 20),                          // 需要科研点
        145.0F,                               // 最低每 Tick 算力要求
        [
            "改进生产线，该项目专注于改进ME网络的原料生产。"
        ],
        [
            "§2解锁工业机械臂配方配方：§6Fluix晶胞催化重铸工厂。",
            "",
            "晶胞工厂，整合了［脉冲离心机］和［福鲁伊克斯聚合器］的功能。",
            "",
            "改进的机器能用不稳定红石充能赛特斯石英，利用率比红石高，速度比单独充能快。使用易气化的星能液作为溶剂，加速分离产物，且降低了原料混合不均导致的损耗。",
            "加上规模更大，功率更高的晶体催生线圈，整体吞吐量大幅提升。",
            "",
            "§2§o文案/模型：nxc_in_china，§2§o代码：nxc_in_china，Circulation"
        ],
        [
            "field_generator_v1"                                 // 前置科技
        ]
));
//控制器
    RecipeBuilder.newBuilder("fluix_factory_controller", "machine_arm", 1200)
        .addEnergyPerTickInput(96000)
        .addInputs([
            <enderio:item_liquid_conduit:2> * 16,
            <enderio:item_endergy_conduit:10> * 8,
            <enderio:item_item_conduit> * 8,
            <contenttweaker:hypernet_cpu_t2> * 4,
            <contenttweaker:sensor_v2> * 5,
            <contenttweaker:field_generator_v1> * 5,
            <contenttweaker:engineering_battery_v2> * 5,
            <contenttweaker:industrial_circuit_v2> * 5,
            <appliedenergistics2:quartz_growth_accelerator> * 10,
            <modularmachinery:blockcasing>
        ])
        .addOutput(<modularmachinery:fluix_factory_controller>)
        .requireResearch("fluix_factory")
        .build();
//配方
RecipeBuilder.newBuilder("fluix_pure1", "fluix", 10)
    .addEnergyPerTickInput(8192)
    .addInputs([
        <ore:gemCertusQuartz> * 4,
    ])
    .addInputs([
        <liquid:astralsorcery.liquidstarlight> * 4000
    ]).setChance(0)
    .addOutputs(<ore:crystalPureCertusQuartz> * 8)
    .build();
RecipeBuilder.newBuilder("fluix_pure2", "fluix", 10)
    .addEnergyPerTickInput(8192)
    .addInputs([
        <ore:gemQuartz> * 4,
    ])
    .addInputs([
        <liquid:astralsorcery.liquidstarlight> * 4000
    ]).setChance(0)
    .addOutputs(<ore:crystalPureNetherQuartz> * 8)
    .build();
RecipeBuilder.newBuilder("fluix_pure3", "fluix", 10)
    .addEnergyPerTickInput(8192)
    .addInputs([
        <ore:gemFluix> * 4,
    ])
    .addInputs([
        <liquid:astralsorcery.liquidstarlight> * 4000
    ]).setChance(0)
    .addOutputs(<ore:crystalPureFluix> * 8)
    .build();
RecipeBuilder.newBuilder("fluix_fluix", "fluix", 10)
    .addEnergyPerTickInput(16384)
    .addInputs([
        <ore:dustCertusQuartz> * 3,
        <ore:dustQuartz> * 3,
        <liquid:redstone> * 200
    ])
    .addOutputs(<ore:crystalPureFluix> * 6)
    .build();
RecipeBuilder.newBuilder("fluix_fluix_complex", "fluix", 10)
    .addEnergyPerTickInput(16384)
    .addInputs([
        <ore:dustCoal> * 3,
        <ore:dustFluix> * 3,
        <ore:itemSilicon> * 4,
    ])
    .addOutputs(<threng:material:1> * 4)
    .build();
RecipeBuilder.newBuilder("fluix_vibrant", "fluix", 10)
    .addEnergyPerTickInput(16384)
    .addInputs([
        <ore:gemDiamond> * 1,
        <ore:dustSkyStone> * 1,
        <liquid:ender> * 250,
    ])
    .addOutputs(<threng:material:5> * 1)
    .build();
RecipeBuilder.newBuilder("fluix_spectus", "fluix", 10)
    .addEnergyPerTickInput(16384)
    .addInputs([
        <threng:material:1> * 48,
        <ore:dustSkyStone> * 48,
        <appliedenergistics2:material:6> * 64,
    ])
    .addOutputs(<threng:material:13> * 1)
    .build();