//Recipes By Hikari_Nova.
//Machinery By nxc_in_china
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

// 共价超载器
RecipeAdapterBuilder.create("covalent_overloader", "nuclearcraft:infuser")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.05, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 1000, 1, false).build())
    .build();

MachineModifier.setMaxParallelism("covalent_overloader", 128);

// 共价超载器 —— 控制器
RecipeBuilder.newBuilder("covalent_overloader_controller", "mach_crafter", 1200)
    .addEnergyPerTickInput(3072)
    .addInputs([
        <contenttweaker:industrial_circuit_v1> * 24,
        <contenttweaker:electric_motor_v2> * 10,
        <ic2:plate:16> * 12,
        <nuclearcraft:infuser> * 8,
        <ic2:te:43> * 4,
        <enderio:block_tank:1> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutput(<modularmachinery:covalent_overloader_controller>)
    .requireResearch("covalent_overloader")
    .build();

// 共价超载器：机制系统
MMEvents.onMachinePostTick("covalent_overloader", function(event as MachineTickEvent) {
    val ctrl as IMachineController = event.controller;
    val data = ctrl.customData;
    val map = data.asMap();
    val internalPressure = isNull(map["pressure"]) ? 101.325F : map["pressure"].asFloat();

    val newTemp = internalPressure + (ctrl.isWorking ? increasePressure(internalPressure) : -decreasePressure(internalPressure));
    if (newTemp != internalPressure) {
        map["pressure"] = newTemp;
        ctrl.customData = data;
        val modifier as float = min(1500.0F / internalPressure, 5);
        ctrl.addPermanentModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:duration", "input", modifier, 1, false).build());
    }
});

MMEvents.onControllerGUIRender("covalent_overloader", function(event as ControllerGUIRenderEvent) {
    val ctrl as IMachineController = event.controller;
    val data = ctrl.customData.asMap();
    val internalPressure = isNull(data["pressure"]) ? 101.325F as float : data["pressure"].asFloat();
    val modifier as float = min(1500.0F / internalPressure, 5) * 100;
    var info as string[] = [
        "§9内部压力：§b" + (((internalPressure * 1000) as int) as float) / 1000 + "kPa",
        "§9注入时间乘数：" + (modifier >= 100 ? "§c" : "§a") + (((modifier * 100) as int) as float) / 100 + "%",
    ];
    if (internalPressure <= 5000) {
        info += "§e警告：压力过低。";
    } else if (internalPressure <= 8500) {
        info += "§e警告：压力偏低。";
    }

    event.extraInfo = info;
});

function min(a as float, b as float) as float {
    return a <= b ? a : b;
}

function max(a as float, b as float) as float {
    return a >= b ? a : b;
}

function increasePressure(pressure as float) as float {
    if (pressure >= 14999) {
        return 0 as float;
    } else if (pressure >= 7500) {
        return 2.5 as float;
    } else if (pressure >= 5000) {
        return 5 as float;
    } else {
        return 10 as float;
    }
}

function decreasePressure(pressure as float) as float {
    if (pressure >= 12500) {
        return 20 as float;
    } else if (pressure >= 5000) {
        return 12 as float;
    } else if (pressure >= 500) {
        return 5 as float;
    } else if (pressure >= 101.326F) {
        return 0.675 as float;
    } else {
        return 0 as float;
    }
}