//Recipes By Hikari_Nova & nxc_in_china.
//Machinery By nxc_in_china
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

MachineModifier.setInternalParallelism("chemical_complex", 8);
MachineModifier.setMaxParallelism("chemical_complex", 128);

# 化工复合体 - 控制器
RecipeBuilder.newBuilder("chemical_complex_controller", "machine_arm", 1200)
    .addEnergyPerTickInput(96000)
    .addInputs([
        <contenttweaker:industrial_circuit_v1> * 8,
        <contenttweaker:electric_motor_v2> * 8,
        <contenttweaker:sensor_v1> * 16,
        <mekanism:transmitter:2>.withTag({tier: 3}) * 16,
        <immersiveengineering:metal_device0:5> * 4,
        <ic2:rotor_carbon> * 1,
        <ic2:rotor_carbon> * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutput(<modularmachinery:chemical_complex_controller>)
    .requireResearch("chemical_complex")
    .build();

RecipeAdapterBuilder.create("chemical_complex", "nuclearcraft:chemical_reactor")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.05, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 1000, 1, false).build())
    .build();

# 碳纳米管
RecipeBuilder.newBuilder("carbon_nanotube", "chemical_complex", 160)
    .addEnergyPerTickInput(10000)
    .addInputs([
        <contenttweaker:graphene> * 2,
    ])
    .addInput(<mets:niobium_titanium_plate> * 1).setChance(0)
    .addOutputs([
        <contenttweaker:carbon_nanotube> * 1,
    ])
    .build();
