//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.Sync;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeTickEvent;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ControllerGUIRenderEvent;

import crafttweaker.world.IBlockPos;
import crafttweaker.world.IWorld;

val emptyEnergyOutput = RecipeModifierBuilder.create("modularmachinery:energy", "output", 0, 1, false).build();
val maxOutputRate = 20000000;

//==============================天气发电机==============================
RecipeBuilder.newBuilder("weather_generator_thundering", "weather_generator", 100, 0, true)
    .addEnergyPerTickOutput(maxOutputRate).setIgnoreOutputCheck(true)
    .addPreTickHandler(function(event as RecipeTickEvent) {
        val ctrl = event.controller;
        val ticksExisted = ctrl.ticksExisted;
        val world = ctrl.world;
        val worldInfo = world.worldInfo;
        val random = world.random;
        val pos = ctrl.pos;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        var energyCache = dData.getLong("energyCache", 0);
        val posY = pos.y;

        val chanceIncrement = min(max(posY, 60), 120) as float / 60.0F;
        if (ticksExisted % 20 == 0 && worldInfo.thundering && random.nextFloat() <= 0.04F * chanceIncrement) {
            if (energyCache + 20000000000 <= 1000000000000) {
                energyCache += 20000000000;
            }

            val offsetX = random.nextInt(-2, 2);
            val offsetY = random.nextInt(9, 15);
            val offsetZ = random.nextInt(-2, 2);
            Sync.addSyncTask(function() {
                world.summonLightningBolt(pos.x as double + offsetX, posY as double + offsetY, pos.z as double + offsetZ);
            });
        }

        if (energyCache + 5000000 <= 1000000000000) {
            energyCache += 5000000;
        }

        if (energyCache < maxOutputRate) {
            val modifier = maxOutputRate - energyCache;
            ctrl.addModifier("energyOutput", RecipeModifierBuilder.create("modularmachinery:energy", "output", -modifier, 0, false).build());
            energyCache += -energyCache;
        } else {
            energyCache -= maxOutputRate;
            ctrl.removeModifier("energyOutput");
        }

        map["energyCache"] = energyCache;
        ctrl.customData = data;
    })
    .addRecipeTooltip([
        "§c消耗机械内缓存的能量以输出能量。",
        "§c即使能量输出仓为满依然会消耗能量缓存。",
        "默认情况下，始终产出 §a5MRF§f 能量缓存。",
        "雷雨天时，每秒有 §a4%§f 的基础概率被闪电击中。",
        "发电机位置越高，击中概率越大，最高为 §a120§f 格。",
        "被击中时，增加 §c20GRF§f 的能量缓存。",
        "最多可缓存 §c1TRF§f 能量。",
    ])
    .build();

MMEvents.onControllerGUIRender("weather_generator", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val energyCache = dData.getLong("energyCache", 0);

    var info as string[] = [
        "§b////////// 天气发电机 //////////",
        "§a脉冲电容器缓存：§c" + formatNumber(energyCache) + " RF",
    ];

    event.extraInfo = info;
});

function formatNumber(value as long) as string {
    if (value < 1000) {
        return "" + value;
    } else if (value < 1000000) {
        return "" + (value / 1000) + "K";
    } else if (value < 1000000000) {
        return "" + ((value / 100000) as float / 10) + "M";
    } else if (value < 1000000000000) {
        return "" + ((value / 100000000) as float / 10) + "G";
    } else if (value < 1000000000000000) {
        return "" + ((value / 100000000000) as float / 10) + "T";
    } else if (value < 1000000000000000000) {
        return "" + ((value / 100000000000000) as float / 10) + "P";
    } else {
        return "" + ((value / 100000000000000000) as float / 10) + "E";
    }
}

function min(a as int, b as int) as int {
    return a <= b ? a : b;
}

function max(a as int, b as int) as int {
    return a >= b ? a : b;
}