//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import novaeng.hypernet.HyperNetHelper;

// 虚空采掘机
HyperNetHelper.proxyMachineForHyperNet("void_miner");
HyperNetHelper.proxyMachineForHyperNet("different_world");

RecipeBuilder.newBuilder("void_miner_controller", "machine_arm", 1200)
    .addEnergyPerTickInput(96000)
    .addInputs([
        <liquid:melodic_alloy> * 3456,
        <contenttweaker:hypernet_cpu_t2> * 1,
        <contenttweaker:sensor_v1> * 8,
        <ore:gemDimensionalShard> * 16,
        <ore:pearlEnderEye> * 12,
        <modularmachinery:mineral_extractor_factory_controller>,
    ])
    .addOutputs(<modularmachinery:void_miner_factory_controller> * 1)
    .requireResearch("void_miner")
    .build();

RecipeBuilder.newBuilder("different_world_controller", "machine_arm", 1200)
    .addEnergyPerTickInput(96000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 12,
        <contenttweaker:sensor_v2> * 12,
        <ore:ingotAlloyT1> * 6,
        <ore:gemDimensionalShard> * 32,
        <ore:netherStar> * 6,
        <modularmachinery:void_miner_factory_controller>,
    ])
    .addOutputs(<modularmachinery:different_world_factory_controller> * 1)
    .requireResearch("different_world")
    .build();

RecipeAdapterBuilder.create("void_miner", "modularmachinery:different_world")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input",  0.5, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input",  0.5, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:item",     "output", 0.5, 1, false).build())
    .addCatalystInput(
        <ancientspellcraft:charm_rift_bottle>,
        [
            "矿物输出 §ax10",
            "消耗时间 §ax0.15",
            "能量消耗 §cx50",
            "§5§o这个瓶子太奇怪了，或许它有其他用处。",
            "§5§o将其接入虚空采掘机，将会在机器中心撕裂出一道虚空裂缝。",
            "§5§o通过虚空裂缝，将允许机械将穿越在各个维度，极大程度的增强资源获取能力。",
            "§5§o为了维持这道不稳定的裂缝，你必须输入大量的能量来维持链接的稳定。",
            "§c§o警告：长时间使用后有可能会导致瓶子破裂。",
        ],
        [
            RecipeModifierBuilder.create("modularmachinery:duration", "input",  0.15, 1, false).build(),
            RecipeModifierBuilder.create("modularmachinery:energy",   "input",  50,   1, false).build(),
            RecipeModifierBuilder.create("modularmachinery:item",     "output", 10,   1, false).build(),
        ]
    ).setChance(0.0005F)
    .requireComputationPoint(7.5F)
    .build();
